/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.text.BreakIterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.control.IndexRange;
import javafx.util.Duration;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.CaretNode;
import org.fxmisc.richtext.CaretSelectionBind;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.ParagraphBox;
import org.fxmisc.richtext.Selection;
import org.fxmisc.richtext.SelectionImpl;
import org.fxmisc.richtext.SelectionPath;
import org.fxmisc.richtext.model.StyledDocument;
import org.reactfx.Subscription;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableNo;
import org.reactfx.util.Tuple3;
import org.reactfx.util.Tuples;
import org.reactfx.value.SuspendableVal;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

final class CaretSelectionBindImpl<PS, SEG, S>
implements CaretSelectionBind<PS, SEG, S> {
    private final CaretNode delegateCaret;
    private final Selection<PS, SEG, S> delegateSelection;
    private final Val<Integer> anchorPosition;
    private final Val<Integer> anchorParIndex;
    private final Val<Integer> anchorColPosition;
    private final SuspendableNo beingUpdated = new SuspendableNo();
    private final Var<Boolean> internalStartedByAnchor = Var.newSimpleVar(true);
    private final SuspendableVal<Boolean> startedByAnchor = this.internalStartedByAnchor.suspendable();
    private Subscription subscription = () -> {};

    @Override
    public Var<Caret.CaretVisibility> showCaretProperty() {
        return this.delegateCaret.showCaretProperty();
    }

    @Override
    public Caret.CaretVisibility getShowCaret() {
        return this.delegateCaret.getShowCaret();
    }

    @Override
    public void setShowCaret(Caret.CaretVisibility value) {
        this.delegateCaret.setShowCaret(value);
    }

    @Override
    public ObservableValue<Integer> positionProperty() {
        return this.delegateCaret.positionProperty();
    }

    @Override
    public int getPosition() {
        return this.delegateCaret.getPosition();
    }

    @Override
    public ObservableValue<Integer> paragraphIndexProperty() {
        return this.delegateCaret.paragraphIndexProperty();
    }

    @Override
    public int getParagraphIndex() {
        return this.delegateCaret.getParagraphIndex();
    }

    @Override
    public ObservableValue<OptionalInt> lineIndexProperty() {
        return this.delegateCaret.lineIndexProperty();
    }

    @Override
    public OptionalInt getLineIndex() {
        return this.delegateCaret.getLineIndex();
    }

    @Override
    public ObservableValue<Integer> columnPositionProperty() {
        return this.delegateCaret.columnPositionProperty();
    }

    @Override
    public int getColumnPosition() {
        return this.delegateCaret.getColumnPosition();
    }

    @Override
    public ObservableValue<Boolean> visibleProperty() {
        return this.delegateCaret.visibleProperty();
    }

    @Override
    public boolean isVisible() {
        return this.delegateCaret.isVisible();
    }

    @Override
    public ObservableValue<Duration> blinkRateProperty() {
        return this.delegateCaret.blinkRateProperty();
    }

    @Override
    public Duration getBlinkRate() {
        return this.delegateCaret.getBlinkRate();
    }

    @Override
    public void setBlinkRate(Duration blinkRate) {
        this.delegateCaret.setBlinkRate(blinkRate);
    }

    @Override
    public ObservableValue<Optional<Bounds>> caretBoundsProperty() {
        return this.delegateCaret.caretBoundsProperty();
    }

    @Override
    public Optional<Bounds> getCaretBounds() {
        return this.delegateCaret.getCaretBounds();
    }

    @Override
    public void clearTargetOffset() {
        this.delegateCaret.clearTargetOffset();
    }

    @Override
    public ParagraphBox.CaretOffsetX getTargetOffset() {
        return this.delegateCaret.getTargetOffset();
    }

    @Override
    public ObservableValue<IndexRange> rangeProperty() {
        return this.delegateSelection.rangeProperty();
    }

    @Override
    public IndexRange getRange() {
        return this.delegateSelection.getRange();
    }

    @Override
    public ObservableValue<Integer> lengthProperty() {
        return this.delegateSelection.lengthProperty();
    }

    @Override
    public int getLength() {
        return this.delegateSelection.getLength();
    }

    @Override
    public ObservableValue<Integer> paragraphSpanProperty() {
        return this.delegateSelection.paragraphSpanProperty();
    }

    @Override
    public int getParagraphSpan() {
        return this.delegateSelection.getParagraphSpan();
    }

    @Override
    public final ObservableValue<StyledDocument<PS, SEG, S>> selectedDocumentProperty() {
        return this.delegateSelection.selectedDocumentProperty();
    }

    @Override
    public final StyledDocument<PS, SEG, S> getSelectedDocument() {
        return this.delegateSelection.getSelectedDocument();
    }

    @Override
    public ObservableValue<String> selectedTextProperty() {
        return this.delegateSelection.selectedTextProperty();
    }

    @Override
    public String getSelectedText() {
        return this.delegateSelection.getSelectedText();
    }

    @Override
    public ObservableValue<Integer> startPositionProperty() {
        return this.delegateSelection.startPositionProperty();
    }

    @Override
    public int getStartPosition() {
        return this.delegateSelection.getStartPosition();
    }

    @Override
    public ObservableValue<Integer> startParagraphIndexProperty() {
        return this.delegateSelection.startParagraphIndexProperty();
    }

    @Override
    public int getStartParagraphIndex() {
        return this.delegateSelection.getStartParagraphIndex();
    }

    @Override
    public ObservableValue<Integer> startColumnPositionProperty() {
        return this.delegateSelection.startColumnPositionProperty();
    }

    @Override
    public int getStartColumnPosition() {
        return this.delegateSelection.getStartColumnPosition();
    }

    @Override
    public ObservableValue<Integer> endPositionProperty() {
        return this.delegateSelection.endPositionProperty();
    }

    @Override
    public int getEndPosition() {
        return this.delegateSelection.getEndPosition();
    }

    @Override
    public ObservableValue<Integer> endParagraphIndexProperty() {
        return this.delegateSelection.endParagraphIndexProperty();
    }

    @Override
    public int getEndParagraphIndex() {
        return this.delegateSelection.getEndParagraphIndex();
    }

    @Override
    public ObservableValue<Integer> endColumnPositionProperty() {
        return this.delegateSelection.endColumnPositionProperty();
    }

    @Override
    public int getEndColumnPosition() {
        return this.delegateSelection.getEndColumnPosition();
    }

    @Override
    public ObservableValue<Optional<Bounds>> selectionBoundsProperty() {
        return this.delegateSelection.selectionBoundsProperty();
    }

    @Override
    public Optional<Bounds> getSelectionBounds() {
        return this.delegateSelection.getSelectionBounds();
    }

    @Override
    public CaretNode getUnderlyingCaret() {
        return this.delegateCaret;
    }

    @Override
    public String getCaretName() {
        return this.delegateCaret.getCaretName();
    }

    @Override
    public Selection<PS, SEG, S> getUnderlyingSelection() {
        return this.delegateSelection;
    }

    @Override
    public String getSelectionName() {
        return this.delegateSelection.getSelectionName();
    }

    @Override
    public void configureSelectionPath(SelectionPath path) {
        this.delegateSelection.configureSelectionPath(path);
    }

    @Override
    public GenericStyledArea<PS, SEG, S> getArea() {
        return this.delegateSelection.getArea();
    }

    @Override
    public int getAnchorPosition() {
        return (Integer)this.anchorPosition.getValue();
    }

    @Override
    public ObservableValue<Integer> anchorPositionProperty() {
        return this.anchorPosition;
    }

    @Override
    public int getAnchorParIndex() {
        return (Integer)this.anchorParIndex.getValue();
    }

    @Override
    public ObservableValue<Integer> anchorParIndexProperty() {
        return this.anchorParIndex;
    }

    @Override
    public int getAnchorColPosition() {
        return (Integer)this.anchorColPosition.getValue();
    }

    @Override
    public ObservableValue<Integer> anchorColPositionProperty() {
        return this.anchorColPosition;
    }

    @Override
    public final boolean isBeingUpdated() {
        return this.beingUpdated.get();
    }

    @Override
    public final ObservableValue<Boolean> beingUpdatedProperty() {
        return this.beingUpdated;
    }

    private boolean anchorIsStart() {
        return (Boolean)this.startedByAnchor.getValue();
    }

    CaretSelectionBindImpl(String caretName, String selectionName, GenericStyledArea<PS, SEG, S> area) {
        this(caretName, selectionName, area, new IndexRange(0, 0));
    }

    CaretSelectionBindImpl(String caretName, String selectionName, GenericStyledArea<PS, SEG, S> area, IndexRange startingRange) {
        this(updater -> new CaretNode(caretName, area, (SuspendableNo)updater, startingRange.getStart()), updater -> new SelectionImpl(selectionName, area, startingRange, (SuspendableNo)updater));
    }

    CaretSelectionBindImpl(Function<SuspendableNo, ? extends CaretNode> createCaret, Function<SuspendableNo, Selection<PS, SEG, S>> createSelection) {
        SuspendableNo delegateUpdater = new SuspendableNo();
        this.delegateCaret = createCaret.apply(delegateUpdater);
        this.delegateSelection = createSelection.apply(delegateUpdater);
        if (this.delegateCaret.getArea() != this.delegateSelection.getArea()) {
            throw new IllegalArgumentException(String.format("Caret and Selection must be asociated with the same area. Caret area = %s | Selection area = %s", this.delegateCaret.getArea(), this.delegateSelection.getArea()));
        }
        Val<Integer> anchorPositions = this.startedByAnchor.flatMap(b -> b != false ? Val.constant(Tuples.t(this.getStartPosition(), this.getStartParagraphIndex(), this.getStartColumnPosition())) : Val.constant(Tuples.t(this.getEndPosition(), this.getEndParagraphIndex(), this.getEndColumnPosition())));
        this.anchorPosition = anchorPositions.map(Tuple3::get1);
        this.anchorParIndex = anchorPositions.map(Tuple3::get2);
        this.anchorColPosition = anchorPositions.map(Tuple3::get3);
        Suspendable omniSuspendable = Suspendable.combine(this.beingUpdated, this.startedByAnchor, delegateUpdater);
        this.subscription = omniSuspendable.suspendWhen(this.getArea().beingUpdatedProperty());
    }

    @Override
    public void moveBreaksForwards(int numOfBreaks, BreakIterator breakIterator) {
        if (this.getAreaLength() == 0) {
            return;
        }
        breakIterator.setText(this.getArea().getText());
        int position = this.calculatePositionViaBreakingForwards(numOfBreaks, breakIterator, this.getPosition());
        this.moveTo(position, NavigationActions.SelectionPolicy.CLEAR);
    }

    @Override
    public void moveBreaksBackwards(int numOfBreaks, BreakIterator breakIterator) {
        if (this.getAreaLength() == 0) {
            return;
        }
        breakIterator.setText(this.getArea().getText());
        int position = this.calculatePositionViaBreakingBackwards(numOfBreaks, breakIterator, this.getPosition());
        this.moveTo(position, NavigationActions.SelectionPolicy.CLEAR);
    }

    @Override
    public void selectRange(int startPosition, int endPosition) {
        this.doSelect(startPosition, endPosition, this.anchorIsStart());
    }

    @Override
    public void selectRange(int startParagraphIndex, int startColPosition, int endParagraphIndex, int endColPosition) {
        this.selectRange(this.textPosition(startParagraphIndex, startColPosition), this.textPosition(endParagraphIndex, endColPosition));
    }

    @Override
    public void updateStartBy(int amount, Selection.Direction direction) {
        int updatedStart = direction == Selection.Direction.LEFT ? this.getStartPosition() - amount : this.getStartPosition() + amount;
        this.selectRange(updatedStart, this.getEndPosition());
    }

    @Override
    public void updateEndBy(int amount, Selection.Direction direction) {
        int updatedEnd = direction == Selection.Direction.LEFT ? this.getEndPosition() - amount : this.getEndPosition() + amount;
        this.selectRange(this.getStartPosition(), updatedEnd);
    }

    @Override
    public void updateStartTo(int position) {
        this.selectRange(position, this.getEndPosition());
    }

    @Override
    public void updateStartTo(int paragraphIndex, int columnPosition) {
        this.updateStartTo(this.textPosition(paragraphIndex, columnPosition));
    }

    @Override
    public void updateStartByBreaksForward(int numOfBreaks, BreakIterator breakIterator) {
        if (this.getAreaLength() == 0) {
            return;
        }
        breakIterator.setText(this.getArea().getText());
        int position = this.calculatePositionViaBreakingForwards(numOfBreaks, breakIterator, this.getStartPosition());
        this.updateStartTo(position);
    }

    @Override
    public void updateStartByBreaksBackward(int numOfBreaks, BreakIterator breakIterator) {
        if (this.getAreaLength() == 0) {
            return;
        }
        breakIterator.setText(this.getArea().getText());
        int position = this.calculatePositionViaBreakingBackwards(numOfBreaks, breakIterator, this.getStartPosition());
        this.updateStartTo(position);
    }

    @Override
    public void updateEndTo(int position) {
        this.selectRange(this.getStartPosition(), position);
    }

    @Override
    public void updateEndTo(int paragraphIndex, int columnPosition) {
        this.updateEndTo(this.textPosition(paragraphIndex, columnPosition));
    }

    @Override
    public void updateEndByBreaksForward(int numOfBreaks, BreakIterator breakIterator) {
        if (this.getAreaLength() == 0) {
            return;
        }
        breakIterator.setText(this.getArea().getText());
        int position = this.calculatePositionViaBreakingForwards(numOfBreaks, breakIterator, this.getStartPosition());
        this.updateEndTo(position);
    }

    @Override
    public void updateEndByBreaksBackward(int numOfBreaks, BreakIterator breakIterator) {
        if (this.getAreaLength() == 0) {
            return;
        }
        breakIterator.setText(this.getArea().getText());
        int position = this.calculatePositionViaBreakingBackwards(numOfBreaks, breakIterator, this.getStartPosition());
        this.updateEndTo(position);
    }

    @Override
    public void selectAll() {
        this.selectRange(0, this.getAreaLength());
    }

    @Override
    public void selectParagraph(int paragraphIndex) {
        int start = this.textPosition(paragraphIndex, 0);
        int end = this.getArea().getParagraphLength(paragraphIndex);
        this.selectRange(start, end);
    }

    @Override
    public void selectWord(int wordPositionInArea) {
        if (this.getAreaLength() == 0) {
            return;
        }
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(this.getArea().getText());
        int start = this.calculatePositionViaBreakingBackwards(1, breakIterator, wordPositionInArea);
        int end = this.calculatePositionViaBreakingForwards(1, breakIterator, wordPositionInArea);
        this.selectRange(start, end);
    }

    @Override
    public void deselect() {
        this.selectRangeExpl(this.getPosition(), this.getPosition());
    }

    @Override
    public void selectRangeExpl(int anchorParagraph, int anchorColumn, int caretParagraph, int caretColumn) {
        this.selectRangeExpl(this.textPosition(anchorParagraph, anchorColumn), this.textPosition(caretParagraph, caretColumn));
    }

    @Override
    public void selectRangeExpl(int anchorPosition, int caretPosition) {
        if (anchorPosition <= caretPosition) {
            this.doSelect(anchorPosition, caretPosition, true);
        } else {
            this.doSelect(caretPosition, anchorPosition, false);
        }
    }

    @Override
    public void moveTo(int pos, NavigationActions.SelectionPolicy selectionPolicy) {
        switch (selectionPolicy) {
            case CLEAR: {
                this.selectRangeExpl(pos, pos);
                break;
            }
            case ADJUST: {
                this.selectRangeExpl(this.getAnchorPosition(), pos);
                break;
            }
            case EXTEND: {
                IndexRange sel = this.getRange();
                int anchor = pos <= sel.getStart() ? sel.getEnd() : (pos >= sel.getEnd() ? sel.getStart() : this.getAnchorPosition());
                this.selectRangeExpl(anchor, pos);
            }
        }
    }

    @Override
    public void moveTo(int paragraphIndex, int columnIndex, NavigationActions.SelectionPolicy selectionPolicy) {
        this.moveTo(this.textPosition(paragraphIndex, columnIndex), selectionPolicy);
    }

    @Override
    public void moveToPrevChar(NavigationActions.SelectionPolicy selectionPolicy) {
        if (this.getPosition() > 0) {
            int newCaretPos = Character.offsetByCodePoints(this.getArea().getText(), this.getPosition(), -1);
            this.moveTo(newCaretPos, selectionPolicy);
        }
    }

    @Override
    public void moveToNextChar(NavigationActions.SelectionPolicy selectionPolicy) {
        if (this.getPosition() < this.getAreaLength()) {
            int newCaretPos = Character.offsetByCodePoints(this.getArea().getText(), this.getPosition(), 1);
            this.moveTo(newCaretPos, selectionPolicy);
        }
    }

    @Override
    public void moveToParStart(NavigationActions.SelectionPolicy selectionPolicy) {
        this.moveTo(this.getPosition() - this.getColumnPosition(), selectionPolicy);
    }

    @Override
    public void moveToParEnd(NavigationActions.SelectionPolicy selectionPolicy) {
        this.moveTo(this.getPosition() - this.getColumnPosition() + this.getArea().getParagraphLength(this.getParagraphIndex()), selectionPolicy);
    }

    @Override
    public void moveToAreaStart(NavigationActions.SelectionPolicy selectionPolicy) {
        this.moveTo(0, selectionPolicy);
    }

    @Override
    public void moveToAreaEnd(NavigationActions.SelectionPolicy selectionPolicy) {
        this.moveTo(this.getArea().getLength(), selectionPolicy);
    }

    @Override
    public void displaceCaret(int position) {
        this.doUpdate(() -> this.delegateCaret.moveTo(position));
    }

    @Override
    public void displaceSelection(int startPosition, int endPosition) {
        this.doUpdate(() -> {
            this.delegateSelection.selectRange(startPosition, endPosition);
            this.internalStartedByAnchor.setValue(startPosition < endPosition);
        });
    }

    @Override
    public void dispose() {
        this.subscription.unsubscribe();
    }

    private void doSelect(int startPosition, int endPosition, boolean anchorIsStart) {
        this.doUpdate(() -> {
            this.delegateSelection.selectRange(startPosition, endPosition);
            this.internalStartedByAnchor.setValue(anchorIsStart);
            this.delegateCaret.moveTo(anchorIsStart ? endPosition : startPosition);
        });
    }

    private void doUpdate(Runnable updater) {
        if (this.isBeingUpdated()) {
            updater.run();
        } else {
            this.getArea().beingUpdatedProperty().suspendWhile(updater);
        }
    }

    private int textPosition(int paragraphIndex, int columnPosition) {
        return this.getArea().position(paragraphIndex, columnPosition).toOffset();
    }

    private int getAreaLength() {
        return this.getArea().getLength();
    }

    private int calculatePositionViaBreakingForwards(int numOfBreaks, BreakIterator breakIterator, int position) {
        breakIterator.following(position);
        for (int i = 1; i < numOfBreaks; ++i) {
            breakIterator.next(numOfBreaks);
        }
        return breakIterator.current();
    }

    private int calculatePositionViaBreakingBackwards(int numOfBreaks, BreakIterator breakIterator, int position) {
        breakIterator.preceding(position);
        for (int i = 1; i < numOfBreaks; ++i) {
            breakIterator.previous();
        }
        return breakIterator.current();
    }
}

