/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql;

import de.foellix.aql.Properties;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.LogMsg;
import de.foellix.aql.ui.gui.LogViewer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class Log {
    public static final int NONE = -1;
    public static final int IMPORTANT = 0;
    public static final int ERROR = 1;
    public static final int DEBUG_SPECIAL = 2;
    public static final int WARNING = 3;
    public static final int NORMAL = 4;
    public static final int DEBUG = 5;
    public static final int DEBUG_DETAILED = 6;
    public static final int VERBOSE = 7;
    public static final int ALL = 7;
    public static final int TYPE_MSG = 0;
    public static final int TYPE_NOTE = 1;
    public static final int TYPE_WARNING = 2;
    public static final int TYPE_ERROR = 3;
    public static final int SILENCE_LEVEL_NONE = -1;
    public static final int SILENCE_LEVEL_MSG = 0;
    public static final int SILENCE_LEVEL_NOTE = 1;
    public static final int SILENCE_LEVEL_WARNING = 2;
    public static final int SILENCE_LEVEL_ERROR = 3;
    public static final int SILENCE_LEVEL_ALL = 4;
    public static final String LOG_DATE_FORMAT = "MM/dd/yyyy - HH:mm:ss";
    private static int logLevel = 4;
    private static int logToFileLevel = 0;
    private static File logfile = new File("log.txt");
    private static PrintWriter logfileWriter;
    private static Set<String> log;
    private static boolean prefixEnabled;
    private static boolean shorten;
    private static int silence;
    private static int ignoredSilenceLevel;
    private static boolean alwaysIgnoreSilence;
    private static boolean ansiInstalled;
    private static Queue<LogMsg> logBuffer;
    private static PrintStream out;
    private static PrintStream err;
    private static PrintStream dummy;
    private static Lock lock;

    public static void msg(String msg, int loglevel) {
        Log.msg(msg, loglevel, true);
    }

    public static void msg(String msg, int loglevel, boolean newLine) {
        Log.msg(msg, loglevel, newLine, false);
    }

    public static void msg(String msg, int loglevel, boolean newLine, boolean ignoreSilence) {
        Log.ignoreSilenceStart(0, ignoreSilence);
        if (loglevel <= logLevel) {
            Log.outPrint(Log.prefix(msg.contains("\n")) + msg + (newLine ? "\n" : ""));
            Log.logToGUI(new LogMsg(msg, loglevel == 0 ? 4 : 0));
        }
        if (loglevel <= logToFileLevel) {
            Log.outOrErrPrintFile(Log.prefix(msg.contains("\n")) + msg + (newLine ? "\n" : ""));
        }
        Log.ignoreSilenceEnd(0);
    }

    public static void msg(Ansi msg, int loglevel) {
        Log.msg(msg, loglevel, true);
    }

    public static void msg(Ansi msg, int loglevel, boolean newLine) {
        Log.msg(msg, loglevel, true, false);
    }

    public static void msg(Ansi msg, int loglevel, boolean newLine, boolean ignoreSilence) {
        Log.ignoreSilenceStart(0, ignoreSilence);
        if (loglevel <= logLevel) {
            Log.checkAnsiInstalled();
            Log.outPrint(Log.prefix(msg.toString().contains("\n")) + msg.reset() + (newLine ? "\n" : ""));
            Log.logToGUI(new LogMsg(msg.toString(), loglevel == 0 ? 4 : 0));
        }
        if (loglevel <= logToFileLevel) {
            Log.outOrErrPrintFile(Log.prefix(msg.toString().contains("\n")) + msg.reset() + (newLine ? "\n" : ""));
        }
        Log.ignoreSilenceEnd(0);
    }

    public static void note(String msg) {
        Log.note(msg, logToFileLevel >= 4);
    }

    public static void note(String msg, boolean logToFile) {
        Log.note(msg, logToFile, false);
    }

    public static void note(String msg, boolean logToFile, boolean ignoreSilence) {
        Log.ignoreSilenceStart(1, ignoreSilence);
        msg = "Note: " + (String)msg;
        if (!log.contains(msg)) {
            if (4 <= logLevel) {
                Log.checkAnsiInstalled();
                Log.errPrint(Log.prefix(((String)msg).contains("\n")) + Ansi.ansi().fg(Ansi.Color.CYAN).a((String)msg).reset() + "\n");
                Log.logToGUI(new LogMsg((String)msg, 1));
                log.add((String)msg);
            }
            if (logToFile) {
                Log.outOrErrPrintFile(Log.prefix(((String)msg).contains("\n")) + (String)msg + "\n");
            }
        }
        Log.ignoreSilenceEnd(1);
    }

    public static void warning(String msg) {
        Log.warning(msg, logToFileLevel >= 3);
    }

    public static void warning(String msg, boolean logToFile) {
        Log.warning(msg, logToFile, false);
    }

    public static void warning(String msg, boolean logToFile, boolean ignoreSilence) {
        Log.ignoreSilenceStart(2, ignoreSilence);
        msg = "Warning: " + (String)msg;
        if (!log.contains(msg)) {
            if (3 <= logLevel) {
                Log.checkAnsiInstalled();
                Log.errPrint(Log.prefix(((String)msg).contains("\n")) + Ansi.ansi().fg(Ansi.Color.YELLOW).a((String)msg).reset() + "\n");
                Log.logToGUI(new LogMsg((String)msg, 2));
                log.add((String)msg);
            }
            if (logToFile) {
                Log.outOrErrPrintFile(Log.prefix(((String)msg).contains("\n")) + (String)msg + "\n");
            }
        }
        Log.ignoreSilenceEnd(2);
    }

    public static void error(String msg) {
        Log.error(msg, logToFileLevel >= 1);
    }

    public static void error(String msg, boolean logToFile) {
        Log.error(msg, logToFile, false);
    }

    public static void error(String msg, boolean logToFile, boolean ignoreSilence) {
        Log.ignoreSilenceStart(3, ignoreSilence);
        msg = "Error: " + (String)msg;
        if (!log.contains(msg)) {
            if (1 <= logLevel) {
                Log.checkAnsiInstalled();
                Log.errPrint(Log.prefix(((String)msg).contains("\n")) + Ansi.ansi().fg(Ansi.Color.RED).a((String)msg).reset() + "\n");
                Log.logToGUI(new LogMsg((String)msg, 3));
                log.add((String)msg);
            }
            if (logToFile) {
                Log.outOrErrPrintFile(Log.prefix(((String)msg).contains("\n")) + (String)msg + "\n");
            }
        }
        Log.ignoreSilenceEnd(3);
    }

    public static boolean logIt(int loglevel) {
        return Log.logIt(loglevel, false);
    }

    public static boolean logIt(int loglevel, boolean considerFileLevel) {
        return loglevel <= logLevel || considerFileLevel && loglevel <= logToFileLevel;
    }

    private static String prefix(boolean nl) {
        if (prefixEnabled) {
            return Properties.info().ABBREVIATION + " " + Log.date() + (nl ? "\n" : " ");
        }
        return "";
    }

    public static String date() {
        return Log.date(System.currentTimeMillis());
    }

    public static String date(long timestamp) {
        return Helper.getDate(timestamp, LOG_DATE_FORMAT);
    }

    private static void outPrint(String str) {
        lock.lock();
        System.out.print(str);
        lock.unlock();
    }

    private static void errPrint(String str) {
        lock.lock();
        System.err.print(str);
        lock.unlock();
    }

    private static void outOrErrPrintFile(String msg) {
        if (logfileWriter == null) {
            Log.initLogfileWriter();
        }
        logfileWriter.print(msg);
        logfileWriter.flush();
    }

    private static void initLogfileWriter() {
        try {
            if (logfileWriter != null) {
                logfileWriter.close();
            }
            FileWriter fw = new FileWriter(logfile, true);
            logfileWriter = new PrintWriter(fw);
        }
        catch (IOException e) {
            Log.error("Cannot access logfile for writing: " + logfile.getAbsolutePath() + Log.getExceptionAppendix(e));
        }
    }

    private static void ignoreSilenceStart(int type, boolean ignoreSilence) {
        ignoredSilenceLevel = Log.getSilenceLevel();
        if (!Log.isSilenced(type) || ignoredSilenceLevel > -1 && (ignoreSilence || alwaysIgnoreSilence)) {
            Log.setSilence(-1);
        }
    }

    private static void ignoreSilenceEnd(int type) {
        if (ignoredSilenceLevel > -1) {
            Log.setSilence(ignoredSilenceLevel);
        }
    }

    public static String getExceptionAppendix(Throwable e) {
        return Log.getExceptionAppendix(e, false);
    }

    public static String getExceptionAppendix(Throwable e, boolean newLine) {
        return (newLine ? "\n" : " ") + "(" + e.getClass().getSimpleName() + (String)(e.getMessage() != null ? ": " + e.getMessage() : "") + ")";
    }

    public static String getExceptionAppendixNoFormatting(Throwable e) {
        return e.getClass().getSimpleName() + (String)(e.getMessage() != null ? ": " + e.getMessage() : "");
    }

    private static void checkAnsiInstalled() {
        if (!ansiInstalled) {
            ansiInstalled = true;
            AnsiConsole.systemInstall();
        }
    }

    public static void emptyLine() {
        Log.outPrint("\n");
    }

    public static void reset() {
        log.clear();
    }

    public static void setLogLevel(int loglevel) {
        logLevel = loglevel;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void setLogToFileLevel(int loglevel) {
        logToFileLevel = loglevel;
    }

    public static int getLogToFileLevel() {
        return logToFileLevel;
    }

    public static void setPrefixEnabled(boolean value) {
        prefixEnabled = value;
    }

    public static boolean getShorten() {
        return shorten;
    }

    public static void setShorten(boolean shorten) {
        Log.shorten = shorten;
    }

    public static void setDifferentLogFile(File newLogFile) {
        logfile = newLogFile;
        Log.initLogfileWriter();
    }

    public static void setSilence(boolean silenceAll) {
        Log.setSilence(silenceAll, false);
    }

    public static void setSilence(boolean silenceAll, boolean ignoreSilenceInCaseOfAQLLog) {
        if (silenceAll) {
            Log.setSilence(4, ignoreSilenceInCaseOfAQLLog);
        } else {
            Log.setSilence(-1, ignoreSilenceInCaseOfAQLLog);
        }
    }

    public static void setSilence(int silenceLevel) {
        Log.setSilence(silenceLevel, false);
    }

    public static void setSilence(int silenceLevel, boolean ignoreSilenceInCaseOfAQLLog) {
        if (silenceLevel > -1 && Log.getLogLevel() < 7) {
            silence = silenceLevel;
            System.setOut(dummy);
            System.setErr(dummy);
        } else {
            silence = -1;
            System.setOut(out);
            System.setErr(err);
        }
        alwaysIgnoreSilence = ignoreSilenceInCaseOfAQLLog;
    }

    public static boolean isSilenced() {
        return silence > -1;
    }

    public static boolean isSilenced(int type) {
        switch (type) {
            case 0: {
                return silence > 0;
            }
            case 1: {
                return silence > 1;
            }
            case 2: {
                return silence > 2;
            }
            case 3: {
                return silence > 3;
            }
        }
        return silence > -1;
    }

    public static int getSilenceLevel() {
        return silence;
    }

    private static void logToGUI(LogMsg msg) {
        if (GUI.started) {
            LogViewer.log(msg);
        } else if (logBuffer != null) {
            logBuffer.add(msg);
        }
    }

    public static void enableGUIlogging() {
        if (logBuffer != null) {
            while (!logBuffer.isEmpty()) {
                LogViewer.log(logBuffer.poll());
            }
        }
    }

    public static void disableGUIlogging() {
        logBuffer = null;
    }

    public static String stripAnsi(String string) {
        return string.replaceAll("\\e\\[[\\d;]*[^\\d;]", "");
    }

    static {
        log = new HashSet<String>();
        prefixEnabled = true;
        shorten = false;
        silence = -1;
        alwaysIgnoreSilence = false;
        ansiInstalled = false;
        logBuffer = new LinkedList<LogMsg>();
        out = System.out;
        err = System.err;
        dummy = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        });
        lock = new ReentrantLock();
    }
}

