/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.config.wizard;

import de.foellix.aql.Log;
import de.foellix.aql.config.Config;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.config.Converters;
import de.foellix.aql.config.Operators;
import de.foellix.aql.config.Preprocessors;
import de.foellix.aql.config.Tool;
import de.foellix.aql.config.Tools;
import de.foellix.aql.config.wizard.EditorXML;
import de.foellix.aql.config.wizard.Menubar;
import de.foellix.aql.config.wizard.Overview;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.AQLSystem;
import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.IGUI;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class ConfigWizard
extends Stage
implements IGUI {
    private final Stage parent;
    private boolean started = false;
    private final Overview overview;
    private final EditorXML editor;
    private final Menubar menubar;
    private final FileChooser openDialogFile;
    private final FileChooser saveDialog;
    private Config currentConfig = null;
    private File currentConfigFile = null;
    private int newToolCounter = 0;

    public ConfigWizard(Stage parent, File configFile, boolean showImmediately) {
        this.parent = parent;
        this.currentConfig = configFile.exists() ? ConfigHandler.parseXML(configFile) : new Config();
        this.currentConfigFile = configFile;
        this.adjustTitle();
        this.getIcons().add((Object)new Image(new File("data/gui/images/editor_icon_16.png").toURI().toString(), 16.0, 16.0, false, true));
        this.getIcons().add((Object)new Image(new File("data/gui/images/editor_icon_32.png").toURI().toString(), 32.0, 32.0, false, true));
        this.getIcons().add((Object)new Image(new File("data/gui/images/editor_icon_64.png").toURI().toString(), 64.0, 64.0, false, true));
        this.overview = new Overview(this);
        this.editor = new EditorXML(this);
        BorderPane root = new BorderPane();
        TabPane tabPane = new TabPane();
        tabPane.setSide(Side.BOTTOM);
        Tab tabEditor = new Tab("Overview");
        tabEditor.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                if (ConfigWizard.this.started && ((Tab)event.getSource()).isSelected()) {
                    ConfigWizard.this.sync(false);
                    ConfigWizard.this.menubar.activate(true);
                }
            }
        });
        tabEditor.setContent((Node)this.overview);
        tabEditor.setClosable(false);
        Tab tabViewer = new Tab("XML");
        tabViewer.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                if (ConfigWizard.this.started && ((Tab)event.getSource()).isSelected()) {
                    ConfigWizard.this.sync(true);
                    ConfigWizard.this.menubar.activate(false);
                }
            }
        });
        tabViewer.setContent((Node)this.editor);
        tabViewer.setClosable(false);
        tabPane.getTabs().addAll((Object[])new Tab[]{tabEditor, tabViewer});
        this.menubar = new Menubar(this);
        root.setTop((Node)this.menubar);
        root.setCenter((Node)tabPane);
        Scene scene = new Scene((Parent)root, 1200.0, parent.getScene().getHeight() - 32.0);
        scene.getStylesheets().add((Object)new File("data/gui/style.css").toURI().toString());
        scene.getStylesheets().add((Object)new File("data/gui/highlight.css").toURI().toString());
        this.setScene(scene);
        this.openDialogFile = new FileChooser();
        this.saveDialog = new FileChooser();
        FileChooser.ExtensionFilter allFilter = new FileChooser.ExtensionFilter("*.* All files", new String[]{"*.*"});
        FileChooser.ExtensionFilter xmlFilter = new FileChooser.ExtensionFilter("*.xml Config File", new String[]{"*.xml"});
        this.openDialogFile.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{allFilter, xmlFilter});
        this.openDialogFile.setSelectedExtensionFilter(xmlFilter);
        this.saveDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{allFilter, xmlFilter});
        this.saveDialog.setSelectedExtensionFilter(xmlFilter);
        if (showImmediately || parent.isShowing()) {
            this.show();
        } else {
            new Thread(() -> {
                while (!parent.isShowing()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Platform.runLater(() -> this.show());
            }).start();
        }
        this.started = true;
    }

    @Override
    public void newFile() {
        this.currentConfig = new Config();
        this.sync();
        this.overview.clear();
    }

    @Override
    public void open() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_16.png").toURI().toString(), 16.0, 16.0, false, true));
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_32.png").toURI().toString(), 32.0, 32.0, false, true));
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_64.png").toURI().toString(), 64.0, 64.0, false, true));
        alert.setTitle("Open");
        alert.setHeaderText("Opening configuration!");
        alert.setContentText("Get configuration from:");
        Object[] btnType = new ButtonType[]{new ButtonType("Local File"), new ButtonType("Online File"), new ButtonType("AQL-WebService"), new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE)};
        alert.getButtonTypes().setAll(btnType);
        Optional result = alert.showAndWait();
        if (result.get() == btnType[0]) {
            this.openFile();
        } else if (result.get() == btnType[1]) {
            this.openURL();
        } else if (result.get() == btnType[2]) {
            this.openWebService();
        } else {
            return;
        }
    }

    public void openFile(File configFile) {
        if (configFile != null) {
            this.currentConfigFile = configFile;
            this.currentConfig = ConfigHandler.parseXML(this.currentConfigFile);
            this.editor.setContent(ConfigHandler.toXML(this.currentConfig));
            this.sync();
            this.overview.clear();
        }
    }

    public void openFile() {
        if (this.currentConfigFile != null) {
            this.openDialogFile.setInitialDirectory(this.currentConfigFile.getParentFile());
        }
        this.openFile(this.openDialogFile.showOpenDialog((Window)this));
    }

    private void openURL() {
        File tempConfigFile = FileHelper.getTempFile(".xml");
        TextInputDialog alert = new TextInputDialog("https://.../config.xml");
        Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_16.png").toURI().toString(), 16.0, 16.0, false, true));
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_32.png").toURI().toString(), 32.0, 32.0, false, true));
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_64.png").toURI().toString(), 64.0, 64.0, false, true));
        alert.setTitle("Open URL");
        alert.setHeaderText("Please specify the URL of the configuration (.xml) file.");
        alert.setContentText("URL:");
        Optional result = alert.showAndWait();
        if (result.isPresent()) {
            FileHelper.downloadFile((String)result.get(), tempConfigFile);
            this.openFile(tempConfigFile);
            this.sync();
            this.overview.clear();
        } else {
            Log.warning("Could not get configuration from online file!");
        }
    }

    private void openWebService() {
        File tempConfigFile = FileHelper.getTempFile(".xml");
        Dialog alert = new Dialog();
        Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_16.png").toURI().toString(), 16.0, 16.0, false, true));
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_32.png").toURI().toString(), 32.0, 32.0, false, true));
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_64.png").toURI().toString(), 64.0, 64.0, false, true));
        alert.setGraphic((Node)new ImageView(new Image(new File("data/gui/images/icon_64.png").toURI().toString())));
        alert.setTitle("AQL-WebSerivce Credentials");
        alert.setHeaderText("Please provide username and password now!");
        alert.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 10.0, 10.0, 10.0));
        TextField url = new TextField();
        TextField username = new TextField();
        PasswordField password = new PasswordField();
        grid.add((Node)new Label("URL:"), 0, 0);
        grid.add((Node)url, 1, 0);
        grid.add((Node)new Label("Username:"), 0, 1);
        grid.add((Node)username, 1, 1);
        grid.add((Node)new Label("Password:"), 0, 2);
        grid.add((Node)password, 1, 2);
        ColumnConstraints column1 = new ColumnConstraints();
        column1.setPercentWidth(20.0);
        ColumnConstraints column2 = new ColumnConstraints();
        column2.setPercentWidth(80.0);
        grid.getColumnConstraints().clear();
        grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
        alert.getDialogPane().setContent((Node)grid);
        alert.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.OK && url.getText() != null && !url.getText().isBlank() && username.getText() != null && !username.getText().isBlank() && password.getText() != null) {
                return url.getText() + ", " + username.getText() + ", " + password.getText();
            }
            return null;
        });
        Platform.runLater(() -> url.requestFocus());
        Optional result = alert.showAndWait();
        if (result.isPresent()) {
            String[] parts = ((String)result.get()).replace(", ", ",").split(",");
            if (parts.length < 3) {
                parts = new String[]{parts[0], parts[1], ""};
            }
            if (FileHelper.getConfigFromWebService(parts[0], parts[1], parts[2], tempConfigFile)) {
                ConfigHandler.updateConfig(tempConfigFile, true, Helper.getURL(parts[0]), parts[1]);
                this.openFile(tempConfigFile);
                this.sync();
                this.overview.clear();
            }
        } else {
            Log.warning("Could not get configuration from WebService!");
        }
    }

    @Override
    public void saveAs() {
        if (this.currentConfigFile != null) {
            this.saveDialog.setInitialDirectory(this.currentConfigFile.getParentFile());
        }
        this.currentConfigFile = this.saveDialog.showSaveDialog((Window)this);
        if (this.currentConfigFile != null) {
            this.save();
        }
    }

    @Override
    public void save() {
        this.sync(true);
        try {
            Files.write(this.currentConfigFile.toPath(), this.editor.getContent().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Log.msg("Could not write file: " + this.currentConfigFile.getAbsolutePath() + " (" + e.getMessage() + ")", 1);
        }
    }

    @Override
    public void exit() {
        if (GUI.options.getShowConfigWizard()) {
            System.exit(0);
        } else {
            this.hide();
        }
    }

    @Override
    public Stage getStage() {
        return this;
    }

    @Override
    public AQLSystem getSystem() {
        return null;
    }

    public void undo() {
        this.editor.undo();
    }

    public void redo() {
        this.editor.redo();
    }

    public void autoformat() {
        this.sync(true);
    }

    public void addTool() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_16.png").toURI().toString(), 16.0, 16.0, false, true));
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_32.png").toURI().toString(), 32.0, 32.0, false, true));
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_64.png").toURI().toString(), 64.0, 64.0, false, true));
        alert.setTitle("New Tool");
        alert.setHeaderText("What type of tool you want to add?");
        alert.setContentText("Choose your option!");
        Object[] btnType = new ButtonType[]{new ButtonType("Analysis Tool"), new ButtonType("Preprocessor"), new ButtonType("Operator"), new ButtonType("Converter"), new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE)};
        alert.getButtonTypes().setAll(btnType);
        Optional result = alert.showAndWait();
        Tool temp = new Tool();
        temp.setName("New Tool #" + ++this.newToolCounter);
        if (result.get() == btnType[0]) {
            if (this.currentConfig.getTools() == null) {
                this.currentConfig.setTools(new Tools());
            }
            this.currentConfig.getTools().getTool().add(temp);
        } else if (result.get() == btnType[1]) {
            if (this.currentConfig.getPreprocessors() == null) {
                this.currentConfig.setPreprocessors(new Preprocessors());
            }
            this.currentConfig.getPreprocessors().getTool().add(temp);
        } else if (result.get() == btnType[2]) {
            if (this.currentConfig.getOperators() == null) {
                this.currentConfig.setOperators(new Operators());
            }
            this.currentConfig.getOperators().getTool().add(temp);
        } else if (result.get() == btnType[3]) {
            if (this.currentConfig.getConverters() == null) {
                this.currentConfig.setConverters(new Converters());
            }
            this.currentConfig.getConverters().getTool().add(temp);
        } else {
            return;
        }
        this.sync();
    }

    public Config getConfig() {
        return this.currentConfig;
    }

    public void sync() {
        this.sync(true);
        this.sync(false);
    }

    public void sync(boolean overviewActiveBefore) {
        if (overviewActiveBefore) {
            this.editor.setContent(ConfigHandler.toXML(this.currentConfig));
        } else {
            this.currentConfig = ConfigHandler.parseXML(this.editor.getContent());
            this.overview.sync();
            this.overview.clear();
        }
        this.menubar.sync();
        this.adjustTitle();
    }

    private void adjustTitle() {
        Platform.runLater(() -> {
            if (this.currentConfig == null) {
                this.setTitle("AQL-ConfigWizard");
            } else {
                this.setTitle("AQL-ConfigWizard (" + this.currentConfigFile.getAbsolutePath() + ")");
            }
        });
    }

    public void continueWithCurrentConfig() {
        ConfigHandler.getInstance().setConfig(this.currentConfigFile);
        this.hide();
        if (!this.parent.isShowing()) {
            this.parent.show();
        }
    }
}

