/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.config.wizard;

import de.foellix.aql.config.Execute;
import de.foellix.aql.config.Priority;
import de.foellix.aql.config.Tool;
import de.foellix.aql.config.wizard.Overview;
import de.foellix.aql.ui.gui.FileChooserUIElement;
import de.foellix.aql.ui.gui.FontAwesome;
import java.io.File;
import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class EditorOverview
extends BorderPane {
    private static final int ITEM_NAME = 0;
    private static final int ITEM_VERSION = 1;
    private static final int ITEM_QUESTIONS = 2;
    private static final int ITEM_PRIORITY = 3;
    private static final int ITEM_PATH = 4;
    private static final int ITEM_RUN = 5;
    private static final int ITEM_RESULT = 6;
    private static final int ITEM_INSTANCES = 7;
    private static final int ITEM_MEMORY_PER_INSTANCE = 8;
    private static final int ITEM_URL = 9;
    private static final int ITEM_USERNAME = 10;
    private static final int ITEM_PASSWORD = 11;
    private static final int ITEM_RUN_ON_ENTRY = 12;
    private static final int ITEM_RUN_ON_ABORT = 13;
    private static final int ITEM_RUN_ON_FAIL = 14;
    private static final int ITEM_RUN_ON_SUCCESS = 15;
    private static final int ITEM_RUN_ON_EXIT = 16;
    private final Overview parent;
    private final Label[] labels = new Label[17];
    private final HelpButton[] helpBtn = new HelpButton[17];
    private final FlowPane[] helpPane = new FlowPane[17];
    private final FileChooserUIElement[] texts = new FileChooserUIElement[17];
    private ScrollPane priorityScroll;
    private TableView<Priority> priorityTable;
    private Button addBtn;
    private Button applyBtn;
    final RadioButton radioBtnInternal;
    final RadioButton radioBtnExternal;
    private VBox editorBox;
    private Tool currentTool;
    private static final String NEXT_TOOLTIP = "\r\n";
    private static final String START_TOOLTIP = "Available variables: \r\n\r\n";
    private static final String ALWAYS_TOOLTIP = "%ANDROID_PLATFORMS%: Android platforms directory\r\n%ANDROID_BUILDTOOLS%: Android build tools directory\r\n%MEMORY%: Memory\r\n%PID%: Process ID\r\n%DATE%: Current date (and time)";
    private static final String APP_TOOLTIP = "%APP_APK%: .apk file\r\n%APP_APK_FILENAME%: .apk file without path and \".apk\"\r\n%APP_APK_NAME%: App name\r\n%APP_APK_PACKAGE%: App's package name";
    private static final String APP_DETAIL_TOOLTIP = "%STATEMENT_IN%: Statement of IN reference\r\n%STATEMENT_FROM%: Statement of FROM reference\r\n%STATEMENT_TO%: Statement of TO reference\r\n%LINENUMBER_IN%: Linenumber of statement of IN reference\r\n%LINENUMBER_FROM%: Linenumber of statement of FROM reference\r\n%LINENUMBER_TO%: Linenumber of statement of TO reference\r\n%METHOD_IN%: Method of IN reference\r\n%METHOD_FROM%: Method of FROM reference\r\n%METHOD_TO%: Method of TO reference\r\n%CLASS_IN%: Class of IN reference\r\n%CLASS_FROM%: Class of FROM reference\r\n%CLASS_TO%: Class of TO reference\r\n%APP_APK_IN%: .apk file of IN reference\r\n%APP_APK_FROM%: .apk file of FROM reference\r\n%APP_APK_TO%: .apk file of TO reference\r\n%APP_APK_IN_FILENAME%: .apk file without path and \".apk\" of IN reference\r\n%APP_APK_FROM_FILENAME%: .apk file without path and \".apk\" of FROM reference\r\n%APP_APK_TO_FILENAME%: .apk file without path and \".apk\" of TO reference\r\n%APP_APK_IN_NAME%: App name of IN reference\r\n%APP_APK_FROM_NAME%: App name of FROM reference\r\n%APP_APK_TO_NAME%: App name of TO reference\r\n%APP_APK_IN_PACKAGE%: App's package name of IN reference\r\n%APP_APK_FROM_PACKAGE%: App's package name of FROM reference\r\n%APP_APK_TO_PACKAGE%: App's package name of TO reference";
    private static final String FILTER_OPERATOR_TOOLTIP = "[Only for filter operators]\r\n%KEY%: Key of key-value pair\r\n%VALUE%: Value of key-value pair\r\n%SOI%: Subject or interest (e.g. Flows) to filter\r\n%FILTER_STATEMENT%: Statement of reference to filter\r\n%FILTER_LINENUMBER%: Linenumber of statement of reference to filter\r\n%FILTER_METHOD%: Method of reference to filter\r\n%FILTER_CLASS%: Class of reference to filter\r\n%FILTER_APK%: .apk file of reference to filter\r\n%FILTER_APK_FILENAME%: .apk file without path and \".apk\" of reference to filter\r\n%FILTER_APK_NAME%: App name of reference to filter\r\n%FILTER_APK_PACKAGE%: App's package name of reference to filter";
    private static final String TOOLTIP_TOOL = "Available variables: \r\n\r\n%APP_APK%: .apk file\r\n%APP_APK_FILENAME%: .apk file without path and \".apk\"\r\n%APP_APK_NAME%: App name\r\n%APP_APK_PACKAGE%: App's package name\r\n\r\n%STATEMENT_IN%: Statement of IN reference\r\n%STATEMENT_FROM%: Statement of FROM reference\r\n%STATEMENT_TO%: Statement of TO reference\r\n%LINENUMBER_IN%: Linenumber of statement of IN reference\r\n%LINENUMBER_FROM%: Linenumber of statement of FROM reference\r\n%LINENUMBER_TO%: Linenumber of statement of TO reference\r\n%METHOD_IN%: Method of IN reference\r\n%METHOD_FROM%: Method of FROM reference\r\n%METHOD_TO%: Method of TO reference\r\n%CLASS_IN%: Class of IN reference\r\n%CLASS_FROM%: Class of FROM reference\r\n%CLASS_TO%: Class of TO reference\r\n%APP_APK_IN%: .apk file of IN reference\r\n%APP_APK_FROM%: .apk file of FROM reference\r\n%APP_APK_TO%: .apk file of TO reference\r\n%APP_APK_IN_FILENAME%: .apk file without path and \".apk\" of IN reference\r\n%APP_APK_FROM_FILENAME%: .apk file without path and \".apk\" of FROM reference\r\n%APP_APK_TO_FILENAME%: .apk file without path and \".apk\" of TO reference\r\n%APP_APK_IN_NAME%: App name of IN reference\r\n%APP_APK_FROM_NAME%: App name of FROM reference\r\n%APP_APK_TO_NAME%: App name of TO reference\r\n%APP_APK_IN_PACKAGE%: App's package name of IN reference\r\n%APP_APK_FROM_PACKAGE%: App's package name of FROM reference\r\n%APP_APK_TO_PACKAGE%: App's package name of TO reference\r\n\r\n%ANDROID_PLATFORMS%: Android platforms directory\r\n%ANDROID_BUILDTOOLS%: Android build tools directory\r\n%MEMORY%: Memory\r\n%PID%: Process ID\r\n%DATE%: Current date (and time)";
    private static final String TOOLTIP_PREPROCESSOR = "Available variables: \r\n\r\n%APP_APK%: .apk file\r\n%APP_APK_FILENAME%: .apk file without path and \".apk\"\r\n%APP_APK_NAME%: App name\r\n%APP_APK_PACKAGE%: App's package name\r\n\r\n%ANDROID_PLATFORMS%: Android platforms directory\r\n%ANDROID_BUILDTOOLS%: Android build tools directory\r\n%MEMORY%: Memory\r\n%PID%: Process ID\r\n%DATE%: Current date (and time)";
    private static final String TOOLTIP_OPERATOR = "Available variables: \r\n\r\n%ANSWERS%: Input AQL-Answers for operators\r\n%ANSWERSHASH%: SHA-256-hash of %ANSWERS%\r\n%ANSWERSHASH_SHA-256%: SHA-256-hash of %ANSWERS%\r\n%ANSWERSHASH_SHA-1%: SHA-1-hash of %ANSWERS%\r\n%ANSWERSHASH_MD5%: MD5-hash of %ANSWERS%\r\n\r\n[Only for filter operators]\r\n%KEY%: Key of key-value pair\r\n%VALUE%: Value of key-value pair\r\n%SOI%: Subject or interest (e.g. Flows) to filter\r\n%FILTER_STATEMENT%: Statement of reference to filter\r\n%FILTER_LINENUMBER%: Linenumber of statement of reference to filter\r\n%FILTER_METHOD%: Method of reference to filter\r\n%FILTER_CLASS%: Class of reference to filter\r\n%FILTER_APK%: .apk file of reference to filter\r\n%FILTER_APK_FILENAME%: .apk file without path and \".apk\" of reference to filter\r\n%FILTER_APK_NAME%: App name of reference to filter\r\n%FILTER_APK_PACKAGE%: App's package name of reference to filter\r\n\r\n%ANDROID_PLATFORMS%: Android platforms directory\r\n%ANDROID_BUILDTOOLS%: Android build tools directory\r\n%MEMORY%: Memory\r\n%PID%: Process ID\r\n%DATE%: Current date (and time)";
    private static final String TOOLTIP_CONVERTER_1 = "Available variables: \r\n\r\n%RESULT_FILE%: Result file of a tool\r\n\r\n%APP_APK%: .apk file\r\n%APP_APK_FILENAME%: .apk file without path and \".apk\"\r\n%APP_APK_NAME%: App name\r\n%APP_APK_PACKAGE%: App's package name\r\n\r\n%ANDROID_PLATFORMS%: Android platforms directory\r\n%ANDROID_BUILDTOOLS%: Android build tools directory\r\n%MEMORY%: Memory\r\n%PID%: Process ID\r\n%DATE%: Current date (and time)";
    private static final String TOOLTIP_CONVERTER_2 = "Available variables: \r\n\r\n%APP_APK%: .apk file\r\n%APP_APK_FILENAME%: .apk file without path and \".apk\"\r\n%APP_APK_NAME%: App name\r\n%APP_APK_PACKAGE%: App's package name\r\n\r\n%ANDROID_PLATFORMS%: Android platforms directory\r\n%ANDROID_BUILDTOOLS%: Android build tools directory\r\n%MEMORY%: Memory\r\n%PID%: Process ID\r\n%DATE%: Current date (and time)";
    private static final String TOOLTIP_EVENT = "Available variables: \r\n\r\n%ANDROID_PLATFORMS%: Android platforms directory\r\n%ANDROID_BUILDTOOLS%: Android build tools directory\r\n%MEMORY%: Memory\r\n%PID%: Process ID\r\n%DATE%: Current date (and time)";

    EditorOverview(Overview parent) {
        int i;
        this.parent = parent;
        ScrollPane scrollBox = new ScrollPane();
        scrollBox.setFitToWidth(true);
        this.editorBox = new VBox(5.0);
        this.editorBox.setPadding(new Insets(10.0));
        VBox executeBox = new VBox(5.0);
        executeBox.setPadding(new Insets(10.0));
        executeBox.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.rgb((int)200, (int)200, (int)200), BorderStrokeStyle.SOLID, new CornerRadii(3.0), BorderWidths.DEFAULT)}));
        final ToggleGroup toggleGroup = new ToggleGroup();
        this.radioBtnInternal = new RadioButton("Internal");
        this.radioBtnInternal.setToggleGroup(toggleGroup);
        this.radioBtnInternal.setSelected(true);
        this.radioBtnExternal = new RadioButton("External");
        this.radioBtnExternal.setToggleGroup(toggleGroup);
        this.radioBtnExternal.setSelected(false);
        HBox radioBox = new HBox(20.0);
        radioBox.getChildren().addAll((Object[])new Node[]{this.radioBtnInternal, this.radioBtnExternal});
        toggleGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                if (toggleGroup.getSelectedToggle() == EditorOverview.this.radioBtnInternal) {
                    int i;
                    for (i = 5; i <= 8; ++i) {
                        EditorOverview.this.show(i);
                    }
                    for (i = 9; i <= 11; ++i) {
                        EditorOverview.this.hide(i);
                    }
                } else {
                    int i;
                    for (i = 9; i <= 11; ++i) {
                        EditorOverview.this.show(i);
                    }
                    for (i = 5; i <= 8; ++i) {
                        EditorOverview.this.hide(i);
                    }
                }
            }
        });
        executeBox.getChildren().addAll((Object[])new Node[]{radioBox, new Separator()});
        VBox runOnEventBox = new VBox(5.0);
        TitledPane runOnEventRoot = new TitledPane("Run on Event", (Node)runOnEventBox);
        runOnEventRoot.setExpanded(false);
        this.labels[0] = new Label("Name:");
        this.labels[1] = new Label("Version:");
        this.labels[2] = new Label();
        this.labels[3] = new Label("Priority:");
        this.labels[4] = new Label("Path: ");
        this.helpBtn[4] = new HelpButton(TOOLTIP_TOOL);
        this.labels[5] = new Label("Run: ");
        this.helpBtn[5] = new HelpButton(TOOLTIP_TOOL);
        this.labels[6] = new Label("Result: ");
        this.helpBtn[6] = new HelpButton(TOOLTIP_TOOL);
        this.labels[7] = new Label("Instances (0 = \u221e):");
        this.labels[8] = new Label("Memory per instance (in GB):");
        this.labels[9] = new Label("URL: ");
        this.labels[10] = new Label("Username: ");
        this.labels[11] = new Label("Password: ");
        this.labels[12] = new Label("Run on Entry: ");
        this.helpBtn[12] = new HelpButton(TOOLTIP_EVENT);
        this.labels[13] = new Label("Run on Abort: ");
        this.helpBtn[13] = new HelpButton(TOOLTIP_EVENT);
        this.labels[14] = new Label("Run on Fail: ");
        this.helpBtn[14] = new HelpButton(TOOLTIP_EVENT);
        this.labels[15] = new Label("Run on Success: ");
        this.helpBtn[15] = new HelpButton(TOOLTIP_EVENT);
        this.labels[16] = new Label("Run on Exit: ");
        this.helpBtn[16] = new HelpButton(TOOLTIP_EVENT);
        for (i = 0; i <= 11; ++i) {
            if (i != 3) {
                Label toAdd;
                this.texts[i] = i == 4 || i == 5 || i == 6 || i == 12 || i == 13 || i == 14 || i == 15 || i == 16 ? new FileChooserUIElement(parent.getParentGUI().getStage(), "Browse...") : new FileChooserUIElement(parent.getParentGUI().getStage(), null);
                if (i == 7 || i == 8) {
                    this.texts[i].setNumeric();
                }
                if (i == 4) {
                    this.texts[i].setFolder();
                }
                if (this.helpBtn[i] != null) {
                    this.helpPane[i] = new FlowPane();
                    this.helpPane[i].getChildren().addAll((Object[])new Node[]{this.labels[i], this.helpBtn[i]});
                    toAdd = this.helpPane[i];
                } else {
                    toAdd = this.labels[i];
                }
                if (i == 5 || i == 6 || i == 7 || i == 8 || i == 9 || i == 10 || i == 11) {
                    executeBox.getChildren().addAll((Object[])new Node[]{toAdd, this.texts[i]});
                    if (!this.editorBox.getChildren().contains((Object)executeBox)) {
                        Separator separator = new Separator();
                        separator.setVisible(false);
                        this.editorBox.getChildren().addAll((Object[])new Node[]{separator, executeBox});
                    }
                } else {
                    this.editorBox.getChildren().addAll((Object[])new Node[]{toAdd, this.texts[i]});
                }
                if (i < 9 || i > 11) continue;
                this.hide(i);
                continue;
            }
            BorderPane priorityBox = new BorderPane();
            this.priorityTable = new TableView();
            this.priorityTable.setEditable(true);
            TableColumn colValue = new TableColumn("Value");
            colValue.setCellValueFactory((Callback)new PropertyValueFactory("value"));
            colValue.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new StringConverter<Integer>(){

                public String toString(Integer object) {
                    return object.toString();
                }

                public Integer fromString(String string) {
                    return Integer.valueOf(string);
                }
            }));
            colValue.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Priority, Integer>>(){

                public void handle(TableColumn.CellEditEvent<Priority, Integer> t) {
                    ((Priority)t.getTableView().getItems().get(t.getTablePosition().getRow())).setValue((Integer)t.getNewValue());
                }
            });
            TableColumn colFeature = new TableColumn("Feature");
            colFeature.setCellValueFactory((Callback)new PropertyValueFactory("feature"));
            colFeature.setCellFactory(TextFieldTableCell.forTableColumn());
            colFeature.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Priority, String>>(){

                public void handle(TableColumn.CellEditEvent<Priority, String> t) {
                    ((Priority)t.getTableView().getItems().get(t.getTablePosition().getRow())).setFeature((String)t.getNewValue());
                }
            });
            this.priorityTable.getColumns().addAll((Object[])new TableColumn[]{colValue, colFeature});
            this.priorityScroll = new ScrollPane(this.priorityTable);
            this.priorityScroll.setFitToWidth(true);
            this.priorityScroll.setMaxHeight(95.0);
            this.addBtn = new Button("Add");
            this.addBtn.setOnAction(eh -> this.priorityTable.getItems().add((Object)new Priority()));
            this.addBtn.setMaxHeight(95.0);
            priorityBox.setCenter((Node)this.priorityScroll);
            priorityBox.setRight((Node)this.addBtn);
            this.editorBox.getChildren().addAll((Object[])new Node[]{this.labels[i], priorityBox});
        }
        for (i = 12; i <= 16; ++i) {
            this.texts[i] = new FileChooserUIElement(parent.getParentGUI().getStage(), "Browse...");
            if (this.helpBtn[i] != null) {
                FlowPane helpPane = new FlowPane();
                helpPane.getChildren().addAll((Object[])new Node[]{this.labels[i], this.helpBtn[i]});
                runOnEventBox.getChildren().addAll((Object[])new Node[]{helpPane, this.texts[i]});
                continue;
            }
            runOnEventBox.getChildren().addAll((Object[])new Node[]{this.labels[i], this.texts[i]});
        }
        Separator separator = new Separator();
        separator.setVisible(false);
        this.editorBox.getChildren().addAll((Object[])new Node[]{separator, runOnEventRoot});
        scrollBox.setContent((Node)this.editorBox);
        this.applyBtn = new Button("\uf00c Apply");
        FontAwesome.applyFontAwesome((Control)this.applyBtn);
        this.applyBtn.setPrefHeight(25.0);
        this.applyBtn.setPrefWidth(2.147483647E9);
        this.applyBtn.setOnAction(eh -> this.apply());
        BorderPane applyPane = new BorderPane((Node)this.applyBtn);
        applyPane.setPadding(new Insets(7.0, 5.0, 7.0, 2.0));
        this.setBottom((Node)applyPane);
        this.setCenter((Node)scrollBox);
    }

    public void load(Tool tool, int type) {
        if (tool != null && tool.getName() != null) {
            this.currentTool = tool;
            boolean toggle = type == 3;
            this.labels[2].setText(Overview.typeToString(type) + " (separated by \",\")");
            this.helpBtn[4].setToolTip(EditorOverview.typeToToolTip(type, 1));
            this.helpBtn[5].setToolTip(EditorOverview.typeToToolTip(type, 1));
            this.helpBtn[6].setToolTip(EditorOverview.typeToToolTip(type, 2));
            this.texts[0].getTextField().setText(tool.getName());
            this.texts[1].getTextField().setText(tool.getVersion());
            this.texts[2].getTextField().setText(tool.getQuestions());
            this.priorityScroll.setDisable(toggle);
            this.addBtn.setDisable(toggle);
            this.priorityTable.setDisable(toggle);
            this.priorityTable.getItems().setAll(tool.getPriority());
            this.texts[4].getTextField().setText(tool.getPath());
            if (!tool.isExternal()) {
                this.radioBtnExternal.setSelected(false);
                this.radioBtnInternal.setSelected(true);
                if (tool.getExecute() != null) {
                    this.texts[5].getTextField().setText(tool.getExecute().getRun());
                    this.texts[6].getTextField().setText(tool.getExecute().getResult());
                    this.texts[7].getTextField().setText(String.valueOf(tool.getExecute().getInstances()));
                    this.texts[8].getTextField().setText(String.valueOf(tool.getExecute().getMemoryPerInstance()));
                } else {
                    this.texts[5].getTextField().setText("");
                    this.texts[6].getTextField().setText("");
                    this.texts[7].getTextField().setText("");
                    this.texts[8].getTextField().setText("");
                }
                this.texts[7].setDisable(toggle);
                this.texts[9].getTextField().clear();
                this.texts[10].getTextField().clear();
                this.texts[11].getTextField().clear();
            } else {
                this.radioBtnExternal.setSelected(true);
                this.radioBtnInternal.setSelected(false);
                if (tool.getExecute() != null) {
                    this.texts[9].getTextField().setText(tool.getExecute().getUrl());
                    this.texts[10].getTextField().setText(tool.getExecute().getUsername());
                    this.texts[11].getTextField().setText(tool.getExecute().getPassword());
                }
                this.texts[5].getTextField().clear();
                this.texts[6].getTextField().clear();
                this.texts[7].getTextField().clear();
                this.texts[8].getTextField().clear();
            }
            this.texts[12].setDisable(toggle);
            this.texts[13].setDisable(toggle);
            this.texts[14].setDisable(toggle);
            this.texts[15].setDisable(toggle);
            this.texts[16].setDisable(toggle);
            this.texts[12].getTextField().setText(tool.getRunOnEntry());
            this.texts[13].getTextField().setText(tool.getRunOnAbort());
            this.texts[14].getTextField().setText(tool.getRunOnFail());
            this.texts[15].getTextField().setText(tool.getRunOnSuccess());
            this.texts[16].getTextField().setText(tool.getRunOnExit());
            for (Node child : this.editorBox.getChildren()) {
                child.setDisable(false);
            }
            this.applyBtn.setDisable(false);
        } else {
            for (Node child : this.editorBox.getChildren()) {
                child.setDisable(true);
            }
            this.applyBtn.setDisable(true);
        }
    }

    private void apply() {
        this.currentTool.setName(this.texts[0].getTextField().getText());
        this.currentTool.setVersion(this.texts[1].getTextField().getText());
        this.currentTool.setQuestions(this.texts[2].getTextField().getText());
        this.currentTool.getPriority().clear();
        this.currentTool.getPriority().addAll((Collection<Priority>)this.priorityTable.getItems());
        this.currentTool.setPath(this.texts[4].getTextField().getText());
        this.currentTool.setExecute(new Execute());
        if (this.radioBtnExternal.isSelected()) {
            this.currentTool.setExternal(true);
        } else {
            this.currentTool.setExternal(false);
        }
        if (this.currentTool.isExternal()) {
            this.currentTool.getExecute().setUrl(this.texts[9].getTextField().getText());
            this.currentTool.getExecute().setUsername(this.texts[10].getTextField().getText());
            this.currentTool.getExecute().setPassword(this.texts[11].getTextField().getText());
        } else {
            this.currentTool.getExecute().setRun(this.texts[5].getTextField().getText());
            this.currentTool.getExecute().setResult(this.texts[6].getTextField().getText());
            if (!this.texts[7].getTextField().getText().isBlank()) {
                this.currentTool.getExecute().setInstances(Integer.parseInt(this.texts[7].getTextField().getText()));
            }
            if (!this.texts[8].getTextField().getText().isBlank()) {
                this.currentTool.getExecute().setMemoryPerInstance(Integer.parseInt(this.texts[8].getTextField().getText()));
            }
        }
        if (this.texts[12].getTextField().getText() != null && !this.texts[12].getTextField().getText().isBlank()) {
            this.currentTool.setRunOnEntry(this.texts[12].getTextField().getText());
        } else {
            this.currentTool.setRunOnEntry(null);
        }
        if (this.texts[13].getTextField().getText() != null && !this.texts[13].getTextField().getText().isBlank()) {
            this.currentTool.setRunOnAbort(this.texts[13].getTextField().getText());
        } else {
            this.currentTool.setRunOnAbort(null);
        }
        if (this.texts[14].getTextField().getText() != null && !this.texts[14].getTextField().getText().isBlank()) {
            this.currentTool.setRunOnFail(this.texts[14].getTextField().getText());
        } else {
            this.currentTool.setRunOnFail(null);
        }
        if (this.texts[15].getTextField().getText() != null && !this.texts[15].getTextField().getText().isBlank()) {
            this.currentTool.setRunOnSuccess(this.texts[15].getTextField().getText());
        } else {
            this.currentTool.setRunOnSuccess(null);
        }
        if (this.texts[16].getTextField().getText() != null && !this.texts[16].getTextField().getText().isBlank()) {
            this.currentTool.setRunOnExit(this.texts[16].getTextField().getText());
        } else {
            this.currentTool.setRunOnExit(null);
        }
        this.parent.apply();
    }

    private static String typeToToolTip(int type, int number) {
        if (type == 0) {
            return TOOLTIP_TOOL;
        }
        if (type == 1) {
            return "Available variables: \r\n\r\n%APP_APK%: .apk file\r\n%APP_APK_FILENAME%: .apk file without path and \".apk\"\r\n%APP_APK_NAME%: App name\r\n%APP_APK_PACKAGE%: App's package name\r\n\r\n%ANDROID_PLATFORMS%: Android platforms directory\r\n%ANDROID_BUILDTOOLS%: Android build tools directory\r\n%MEMORY%: Memory\r\n%PID%: Process ID\r\n%DATE%: Current date (and time)";
        }
        if (type == 2) {
            return TOOLTIP_OPERATOR;
        }
        if (type == 3) {
            if (number == 1) {
                return TOOLTIP_CONVERTER_1;
            }
            return "Available variables: \r\n\r\n%APP_APK%: .apk file\r\n%APP_APK_FILENAME%: .apk file without path and \".apk\"\r\n%APP_APK_NAME%: App name\r\n%APP_APK_PACKAGE%: App's package name\r\n\r\n%ANDROID_PLATFORMS%: Android platforms directory\r\n%ANDROID_BUILDTOOLS%: Android build tools directory\r\n%MEMORY%: Memory\r\n%PID%: Process ID\r\n%DATE%: Current date (and time)";
        }
        return "UNKNOWN TYPE";
    }

    private void hide(int id) {
        if (this.labels[id] != null) {
            this.labels[id].setVisible(false);
            this.labels[id].setManaged(false);
        }
        if (this.texts[id] != null) {
            this.texts[id].setVisible(false);
            this.texts[id].getTextField().clear();
            this.texts[id].setManaged(false);
        }
        if (this.helpPane[id] != null) {
            this.helpPane[id].setVisible(false);
            this.helpPane[id].setManaged(false);
        }
    }

    private void show(int id) {
        if (this.labels[id] != null) {
            this.labels[id].setVisible(true);
            this.labels[id].setManaged(true);
        }
        if (this.texts[id] != null) {
            this.texts[id].setVisible(true);
            this.texts[id].setManaged(true);
        }
        if (this.helpPane[id] != null) {
            this.helpPane[id].setVisible(true);
            this.helpPane[id].setManaged(true);
        }
    }

    private class HelpButton
    extends Button {
        String toolTip;

        HelpButton(String toolTip) {
            super("?");
            this.toolTip = toolTip;
            this.setTooltip(new Tooltip(toolTip));
            FontAwesome.getInstance().setBlue(this);
            this.setOnAction(eh -> this.showToolTip());
        }

        private void showToolTip() {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
            alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_16.png").toURI().toString(), 16.0, 16.0, false, true));
            alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_32.png").toURI().toString(), 32.0, 32.0, false, true));
            alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_64.png").toURI().toString(), 64.0, 64.0, false, true));
            alert.setTitle("Help");
            alert.setHeaderText(this.toolTip.substring(0, this.toolTip.indexOf(EditorOverview.NEXT_TOOLTIP)));
            String text = this.toolTip.substring(this.toolTip.indexOf(EditorOverview.NEXT_TOOLTIP) + 4);
            TextArea textArea = new TextArea(text);
            textArea.setEditable(false);
            textArea.setPrefHeight((double)text.split(EditorOverview.NEXT_TOOLTIP).length * 17.0 + 10.0);
            textArea.setWrapText(true);
            BorderPane content = new BorderPane();
            content.setCenter((Node)textArea);
            alert.getDialogPane().setContent((Node)content);
            alert.showAndWait();
        }

        public void setToolTip(String toolTip) {
            this.toolTip = toolTip;
        }
    }
}

