/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.config.wizard;

import de.foellix.aql.config.wizard.ConfigWizard;
import de.foellix.aql.ui.gui.FileChooserUIElement;
import de.foellix.aql.ui.gui.FontAwesome;
import de.foellix.aql.ui.gui.MenuFile;
import de.foellix.aql.ui.gui.MenuHelp;
import de.foellix.aql.ui.gui.ToolsetFile;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class Menubar
extends VBox {
    private final ConfigWizard parent;
    private final FileChooserUIElement maxMemChooser;
    private final FileChooserUIElement fileChooserPlatforms;
    private final FileChooserUIElement fileChooserBuildTools;
    private final Button btnAutoFormat;
    private final Button btnAddTool;
    private final Label labelMaxMem;
    private final Label labelAndroidPlatforms;
    private final Label labelAndroidBuildTools;

    Menubar(final ConfigWizard parent) {
        this.parent = parent;
        MenuBar menuBar = new MenuBar();
        Menu menuEdit = new Menu("Edit");
        MenuItem menuItemUndo = FontAwesome.getInstance().createMenuItem("\uf0e2", "Undo");
        menuItemUndo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemUndo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.undo();
            }
        });
        MenuItem menuItemRedo = FontAwesome.getInstance().createMenuItem("\uf01e", "Redo");
        menuItemRedo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemRedo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.redo();
            }
        });
        MenuItem menuItemAutoFormat = FontAwesome.getInstance().createMenuItem("\uf03c", "Auto-Format");
        menuItemAutoFormat.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.autoformat();
            }
        });
        MenuItem menuItemAddTool = FontAwesome.getInstance().createMenuItem("\uf067", "Add new tool");
        menuItemAddTool.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.addTool();
            }
        });
        MenuItem menuItemContinue = FontAwesome.getInstance().createMenuItem("\uf04b", "Continue with this configuration");
        menuItemContinue.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.continueWithCurrentConfig();
            }
        });
        menuEdit.getItems().addAll((Object[])new MenuItem[]{menuItemUndo, menuItemRedo, new SeparatorMenuItem(), menuItemAutoFormat, new SeparatorMenuItem(), menuItemAddTool, new SeparatorMenuItem(), menuItemContinue});
        menuBar.getMenus().addAll((Object[])new Menu[]{new MenuFile(parent), menuEdit, new MenuHelp(null).removeConfigWizard()});
        ToolBar toolBar = new ToolBar();
        this.btnAutoFormat = FontAwesome.getInstance().createButton("\uf03c");
        this.btnAutoFormat.setTooltip(new Tooltip("Auto-Format"));
        this.btnAutoFormat.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.autoformat();
            }
        });
        this.btnAddTool = FontAwesome.getInstance().createButton("\uf067");
        this.btnAddTool.setTooltip(new Tooltip("Add new tool"));
        this.btnAddTool.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.addTool();
            }
        });
        HBox spacer = new HBox();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.labelMaxMem = new Label("Max. GB Memory: ");
        this.maxMemChooser = new FileChooserUIElement(parent.getStage(), null);
        this.maxMemChooser.setNumeric();
        this.maxMemChooser.getTextField().setPrefWidth(50.0);
        this.maxMemChooser.getTextField().textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals("")) {
                parent.getConfig().setMaxMemory(Integer.parseInt(newValue));
            }
        });
        this.labelAndroidPlatforms = new Label("   Android Platforms: ");
        this.fileChooserPlatforms = new FileChooserUIElement(parent.getStage(), "Browse...");
        this.fileChooserPlatforms.getTextField().setPrefWidth(200.0);
        this.fileChooserPlatforms.getTextField().textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals("")) {
                parent.getConfig().setAndroidPlatforms((String)newValue);
            }
        });
        this.fileChooserPlatforms.setFolder();
        this.labelAndroidBuildTools = new Label("   Android Build Tools: ");
        this.fileChooserBuildTools = new FileChooserUIElement(parent.getStage(), "Browse...");
        this.fileChooserBuildTools.getTextField().setPrefWidth(200.0);
        this.fileChooserBuildTools.getTextField().textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals("")) {
                parent.getConfig().setAndroidBuildTools((String)newValue);
            }
        });
        this.fileChooserBuildTools.setFolder();
        Button btnContinue = FontAwesome.getInstance().createButton("\uf04b");
        btnContinue.setTooltip(new Tooltip("Continue with this configuration"));
        btnContinue.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.continueWithCurrentConfig();
            }
        });
        FontAwesome.getInstance().setGreen(btnContinue);
        toolBar.getItems().addAll((Object[])new Node[]{new ToolsetFile(parent), new Separator(), this.btnAutoFormat, new Separator(), this.btnAddTool, spacer, this.labelMaxMem, this.maxMemChooser, this.labelAndroidPlatforms, this.fileChooserPlatforms, new Separator(), this.labelAndroidBuildTools, this.fileChooserBuildTools, new Separator(), btnContinue});
        this.activate(true);
        this.sync();
        this.getChildren().addAll((Object[])new Node[]{menuBar, toolBar});
    }

    public void activate(boolean overviewActiveAfterwards) {
        this.btnAutoFormat.setDisable(overviewActiveAfterwards);
        this.btnAddTool.setDisable(!overviewActiveAfterwards);
        this.labelMaxMem.setDisable(!overviewActiveAfterwards);
        this.labelAndroidPlatforms.setDisable(!overviewActiveAfterwards);
        this.labelAndroidBuildTools.setDisable(!overviewActiveAfterwards);
        this.maxMemChooser.setDisable(!overviewActiveAfterwards);
        this.fileChooserPlatforms.setDisable(!overviewActiveAfterwards);
        this.fileChooserBuildTools.setDisable(!overviewActiveAfterwards);
    }

    public void sync() {
        if (this.parent.getConfig() != null) {
            if (this.parent.getConfig().getMaxMemory() > 0) {
                this.maxMemChooser.getTextField().setText(String.valueOf(this.parent.getConfig().getMaxMemory()));
            } else {
                this.maxMemChooser.getTextField().clear();
            }
            if (this.parent.getConfig().getAndroidPlatforms() != null && !this.parent.getConfig().getAndroidPlatforms().isEmpty()) {
                this.fileChooserPlatforms.getTextField().setText(this.parent.getConfig().getAndroidPlatforms());
            } else {
                this.fileChooserPlatforms.getTextField().clear();
            }
            if (this.parent.getConfig().getAndroidBuildTools() != null && !this.parent.getConfig().getAndroidBuildTools().isEmpty()) {
                this.fileChooserBuildTools.getTextField().setText(this.parent.getConfig().getAndroidBuildTools());
            } else {
                this.fileChooserBuildTools.getTextField().clear();
            }
        } else {
            this.maxMemChooser.getTextField().clear();
            this.fileChooserPlatforms.getTextField().clear();
            this.fileChooserBuildTools.getTextField().clear();
        }
    }
}

