/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.converter;

import de.foellix.aql.config.Tool;
import de.foellix.aql.converter.DefaultConverter;
import de.foellix.aql.converter.amandroid.ConverterAmandroid;
import de.foellix.aql.converter.amandroid.ConverterAmandroid2;
import de.foellix.aql.converter.dialdroid.ConverterDIALDroid;
import de.foellix.aql.converter.didfail.ConverterDidFail;
import de.foellix.aql.converter.droidsafe.ConverterDroidSafe;
import de.foellix.aql.converter.flowdroid.ConverterFD;
import de.foellix.aql.converter.horndroid.ConverterHD;
import de.foellix.aql.converter.ic3.ConverterIC3;
import de.foellix.aql.converter.iccta.ConverterIccTA;
import de.foellix.aql.converter.panda2.ConverterPAndA2;
import java.util.ArrayList;
import java.util.List;

public class DefaultConverterRegistry {
    private final List<Identifier> converters = new ArrayList<Identifier>();
    private static DefaultConverterRegistry instance = new DefaultConverterRegistry();

    private DefaultConverterRegistry() {
        this.converters.add(new Identifier(new DefaultConverter("PAndA2", ConverterPAndA2.class), "PAndA2"));
        this.converters.add(new Identifier(new DefaultConverter("FlowDroid", ConverterIccTA.class), "FlowDroid", "1", false));
        this.converters.add(new Identifier(new DefaultConverter("FlowDroid*", ConverterFD.class), "FlowDroid", "2", true));
        this.converters.add(new Identifier(new DefaultConverter("IccTA", ConverterIccTA.class), "IccTA", "1", true));
        this.converters.add(new Identifier(new DefaultConverter("IccTA", ConverterFD.class), "IccTA", "2", false));
        this.converters.add(new Identifier(new DefaultConverter("IC3", ConverterIC3.class), "IC3"));
        this.converters.add(new Identifier(new DefaultConverter("DidFail", ConverterDidFail.class), "DidFail"));
        this.converters.add(new Identifier(new DefaultConverter("Amandroid", ConverterAmandroid.class), "Amandroid", "312", false));
        this.converters.add(new Identifier(new DefaultConverter("Amandroid*", ConverterAmandroid2.class), "Amandroid", "320", true));
        this.converters.add(new Identifier(new DefaultConverter("DIALDroid", ConverterDIALDroid.class), "DIALDroid"));
        this.converters.add(new Identifier(new DefaultConverter("DroidSafe", ConverterDroidSafe.class), "DroidSafe"));
        this.converters.add(new Identifier(new DefaultConverter("HornDroid", ConverterHD.class), "HornDroid"));
    }

    public static DefaultConverterRegistry getInstance() {
        return instance;
    }

    public Tool getConverter(Tool tool) {
        ArrayList<Identifier> candidates = new ArrayList<Identifier>();
        String toolLC = tool.getName().toLowerCase();
        for (Identifier identifier : this.converters) {
            if (!toolLC.startsWith(identifier.getName().toLowerCase())) continue;
            candidates.add(identifier);
        }
        int bestFit = -1;
        Identifier selection = null;
        for (Identifier identifier : candidates) {
            int fit = this.fits(tool, identifier);
            if (fit <= bestFit) continue;
            selection = identifier;
            bestFit = fit;
        }
        if (bestFit < 0) {
            for (Identifier identifier : candidates) {
                if (!identifier.isDefault()) continue;
                return identifier.getConverter();
            }
        }
        if (selection == null) {
            return null;
        }
        return selection.getConverter();
    }

    private int fits(Tool tool, Identifier identifier) {
        int fits1 = this.fits(tool.getVersion(), identifier.getVersion());
        int fits2 = this.fits(tool.getName().toLowerCase().replace(identifier.getName(), ""), identifier.getVersion());
        return Math.max(fits1, fits2);
    }

    private int fits(String version1, String version2) {
        if (version1 == null || version2 == null || version1.isEmpty() || version2.isEmpty()) {
            return -1;
        }
        version1 = version1.replace(".", "");
        version2 = version2.replace(".", "");
        int fits = -1;
        for (int i = 0; i < version1.length() && i < version2.length(); ++i) {
            if (Integer.valueOf(version1.charAt(i)) == Integer.valueOf(version2.charAt(i))) {
                fits += 2;
                continue;
            }
            if (Integer.valueOf(version1.charAt(i)) <= Integer.valueOf(version2.charAt(i))) break;
            ++fits;
        }
        return fits *= Integer.valueOf(version2).intValue();
    }

    private class Identifier {
        private Tool converter;
        private String name;
        private String version;
        private boolean isDefault;

        public Identifier(Tool converter, String name) {
            this.converter = converter;
            this.name = name.toLowerCase();
            this.version = null;
            this.isDefault = true;
        }

        public Identifier(Tool converter, String name, String version, boolean isDefault) {
            this.converter = converter;
            this.name = name.toLowerCase();
            this.version = version;
            this.isDefault = isDefault;
        }

        public Tool getConverter() {
            return this.converter;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isDefault() {
            return this.isDefault;
        }
    }
}

