/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.converter.amandroid;

import de.foellix.aql.Log;
import de.foellix.aql.converter.IConverter;
import de.foellix.aql.converter.amandroid.ConverterAmandroidBase;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.Statement;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.helper.JawaHelper;
import de.foellix.aql.system.task.ConverterTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ConverterAmandroid2
extends ConverterAmandroidBase
implements IConverter {
    @Override
    public Answer parse(ConverterTask task) throws Exception {
        this.resultFile = new File(task.getTaskInfo().getData("%RESULT_FILE%"));
        this.app = Helper.createApp(Helper.getAppFromData(task.getTaskInfo()));
        Answer answer = new Answer();
        this.needles = new HashSet();
        this.intentLines = new LinkedList();
        this.extractNeedles();
        File srcDir = new File(this.resultFile.getParentFile().getParentFile(), "src");
        if (!srcDir.exists()) {
            Log.warning("Result indicated by \"" + this.resultFile.getAbsolutePath() + "\" is incomplete!");
            return answer;
        }
        this.sourceFiles = this.searchRecursively(srcDir);
        this.mapReferences = new HashMap();
        this.createReferences();
        answer.setFlows(this.computeFlows());
        this.computeIntents(answer);
        return answer;
    }

    private void extractNeedles() {
        try {
            FileReader fr = new FileReader(this.resultFile);
            BufferedReader br = new BufferedReader(fr);
            StringBuilder sb = new StringBuilder();
            String line = "";
            while ((line = br.readLine()) != null) {
                if (line.startsWith("        List(")) {
                    List<String> parts = this.getParts(line);
                    if (parts.get(0).contains("#") && parts.get(0).contains(".  ")) {
                        String fromStr = Helper.cut(parts.get(0), "#", ".  ");
                        this.needles.add(fromStr);
                    }
                    if (!parts.get(parts.size() - 1).contains("#") || !parts.get(parts.size() - 1).contains(".  ")) continue;
                    String toStr = Helper.cut(parts.get(parts.size() - 1), "#", ".  ");
                    this.needles.add(toStr);
                    continue;
                }
                if (line.startsWith("Component ")) {
                    this.intentLines.add(line);
                    continue;
                }
                if (line.startsWith("      Caller Context: ")) {
                    this.needles.add(Helper.cut(line, ",", ")"));
                    this.intentLines.add(line);
                    continue;
                }
                if (line.startsWith("    IntentFilter:(")) {
                    this.intentLines.add(this.cleanUpIntentString(line));
                    continue;
                }
                if (line.startsWith("        Intent:")) {
                    sb.append(line);
                    continue;
                }
                if (line.startsWith("          ") && !sb.isEmpty()) {
                    sb.append(line);
                    continue;
                }
                if (sb.isEmpty()) continue;
                for (String part : sb.toString().split(" Intent:")) {
                    if (part.isBlank()) continue;
                    this.intentLines.add(this.cleanUpIntentString(" Intent:" + part));
                }
                sb.setLength(0);
            }
            br.close();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error("Error while reading file: " + this.resultFile.getAbsolutePath());
        }
    }

    private List<File> searchRecursively(File resultFolder) {
        ArrayList<File> returnList = new ArrayList<File>();
        for (File file : resultFolder.listFiles()) {
            if (file.isDirectory()) {
                returnList.addAll(this.searchRecursively(file));
                continue;
            }
            if (!file.getAbsolutePath().endsWith(".jawa")) continue;
            returnList.add(file);
        }
        return returnList;
    }

    private void createReferences() {
        for (File sourceFile : this.sourceFiles) {
            try {
                FileReader fr = new FileReader(sourceFile);
                BufferedReader br = new BufferedReader(fr);
                String line = br.readLine();
                if (line == null) {
                    br.close();
                    throw new NullPointerException();
                }
                String classname = Helper.cut(line, "record `", "` @kind ");
                String method = null;
                while ((line = br.readLine()) != null) {
                    String key;
                    if (line.startsWith("procedure `")) {
                        method = Helper.cut(line, "@signature `", "` @");
                        continue;
                    }
                    if (!line.startsWith("  #") || !line.contains(".  ") || method == null || !this.needles.contains(key = Helper.cut(line, "  #", ".  "))) continue;
                    try {
                        this.mapReferences.put(key, this.createReference(line, classname, method));
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                }
                br.close();
                fr.close();
            }
            catch (IOException e) {
                Log.error("Error while reading file: " + this.resultFile.getAbsolutePath());
            }
        }
    }

    private Reference createReference(String line, String classname, String method) {
        Reference reference = new Reference();
        reference.setStatement(this.toStatement(line));
        reference.setMethod(this.toMethod(method));
        reference.setClassname(classname);
        reference.setApp(this.app);
        return reference;
    }

    private Statement toStatement(String amandroidString) {
        String stmClass = Helper.cut(amandroidString, " @signature `", ";.");
        stmClass = JawaHelper.toJavaType(stmClass);
        String stmReturntype = Helper.cut(amandroidString, ")", "` @kind ", -1);
        stmReturntype = JawaHelper.toJavaType(stmReturntype);
        String stmParameters = Helper.cut(amandroidString, "(", ")", -1);
        if (!stmParameters.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String parameter : stmParameters.split(";")) {
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append(JawaHelper.toJavaType(parameter));
            }
            stmParameters = sb.toString();
        }
        String stmName = Helper.cut(amandroidString, ";.", ":(");
        String jimpleString = stmClass + ": " + stmReturntype + " " + stmName + "(" + stmParameters + ")";
        Statement statement = Helper.createStatement("<" + jimpleString + ">", false);
        return statement;
    }

    private String toMethod(String amandroidString) {
        String stmClass = Helper.cutFromStart(amandroidString, ";.");
        stmClass = JawaHelper.toJavaType(stmClass);
        String stmReturntype = Helper.cut(amandroidString, ")", -1);
        stmReturntype = JawaHelper.toJavaType(stmReturntype);
        String stmParameters = Helper.cut(amandroidString, "(", ")");
        if (!stmParameters.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String parameter : stmParameters.split(";")) {
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append(JawaHelper.toJavaType(parameter));
            }
            stmParameters = sb.toString();
        }
        String stmName = Helper.cut(amandroidString, ";.", ":(");
        return "<" + stmClass + ": " + stmReturntype + " " + stmName + "(" + stmParameters + ")>";
    }

    private Flows computeFlows() {
        Flows flows = new Flows();
        try {
            FileReader fr = new FileReader(this.resultFile);
            BufferedReader br = new BufferedReader(fr);
            Flow flow = null;
            String line = "";
            while ((line = br.readLine()) != null) {
                if (line.startsWith("      The path consists of the following edges (\"->\"). The nodes have the context information (p1 to pn means which parameter). The source is at the top :")) {
                    flow = new Flow();
                    continue;
                }
                if (flow == null || !line.startsWith("        List(")) continue;
                List<String> parts = this.getParts(line);
                String fromStr = Helper.cut(parts.get(0), "#", ".  ");
                String toStr = Helper.cut(parts.get(parts.size() - 1), "#", ".  ");
                Reference from = (Reference)this.mapReferences.get(fromStr);
                Reference to = (Reference)this.mapReferences.get(toStr);
                if (from != null && to != null) {
                    from.setType("from");
                    to.setType("to");
                    flow.getReference().add(from);
                    flow.getReference().add(to);
                    flows.getFlow().add(flow);
                    continue;
                }
                Log.msg("Could not convert the following flow in Amandroid's result: " + line, 6);
            }
            br.close();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error("Error while reading file: " + this.resultFile.getAbsolutePath());
        }
        return flows;
    }

    private List<String> getParts(String line) {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(line.substring(13, line.length() - 1).split(";, ")));
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String part : parts) {
            if (part.contains("  call ")) continue;
            toRemove.add(part);
        }
        parts.removeAll(toRemove);
        return parts;
    }
}

