/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.converter.amandroid;

import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Attribute;
import de.foellix.aql.datastructure.Attributes;
import de.foellix.aql.datastructure.Data;
import de.foellix.aql.datastructure.Intentfilter;
import de.foellix.aql.datastructure.Intentfilters;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsinks;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.Target;
import de.foellix.aql.helper.Helper;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConverterAmandroidBase {
    protected static final String SEPARATOR = "###SEPARATOR###";
    protected File resultFile;
    protected List<File> sourceFiles;
    protected App app;
    protected Set<String> needles;
    protected Map<String, Reference> mapReferences;
    protected List<String> intentLines;

    protected String cleanUpIntentString(String original) {
        original = Helper.replaceDoubleSpaces(original);
        return original;
    }

    /*
     * WARNING - void declaration
     */
    protected void computeIntents(Answer answer) {
        Intentfilters intentfilters = new Intentfilters();
        Intentsinks intentsinks = new Intentsinks();
        Reference ref = null;
        for (String string : this.intentLines) {
            void var6_13;
            if (string.startsWith("Component ")) {
                ref = new Reference();
                ref.setClassname(string.substring(10));
                ref.setApp(this.app);
                continue;
            }
            if (string.startsWith("      Caller Context: ")) {
                String needle = string.substring(string.indexOf(",") + 1, string.indexOf(")"));
                ref = this.mapReferences.get(needle);
                continue;
            }
            if (string.startsWith(" IntentFilter:")) {
                Intentfilter intentfilter = new Intentfilter();
                intentfilter.setReference(ref);
                Data data = null;
                String string3 = string.substring(14);
                string3 = string3.replace(",", SEPARATOR).replace("\"###SEPARATOR###\"", "\",\"");
                for (String part : string3.split(SEPARATOR)) {
                    if (part.contains("Data:[")) {
                        part = part.replace("Data:[", "");
                        data = new Data();
                        intentfilter.getData().add(data);
                    }
                    if (!part.contains(":")) continue;
                    String name = this.cleanUpIntentPart(part.substring(0, part.indexOf(":")));
                    String[] values = this.cleanUpIntentPart(Helper.cutFromFirstToLast(part, "\"", "\"")).split("\",\"");
                    if (name.equals("Actions")) {
                        for (String value : values) {
                            intentfilter.getAction().add(value);
                        }
                        continue;
                    }
                    if (name.equals("Categories")) {
                        for (String value : values) {
                            intentfilter.getCategory().add(value);
                        }
                        continue;
                    }
                    if (values[0].isEmpty()) continue;
                    if (name.equals("Hosts")) {
                        data.setHost(values[0]);
                        continue;
                    }
                    if (name.equals("MimeTypes")) {
                        data.setType(values[0]);
                        continue;
                    }
                    if (name.equals("PathPatterns")) {
                        data.setPathPattern(values[0]);
                        continue;
                    }
                    if (name.equals("PathPrefixs")) {
                        data.setPathPrefix(values[0]);
                        continue;
                    }
                    if (name.equals("Paths")) {
                        data.setPath(values[0]);
                        continue;
                    }
                    if (name.equals("Ports")) {
                        data.setPort(values[0]);
                        continue;
                    }
                    if (!name.equals("Schemes")) continue;
                    data.setScheme(values[0]);
                }
                intentfilters.getIntentfilter().add(intentfilter);
                continue;
            }
            if (!string.startsWith(" Intent:")) continue;
            Intentsink intentsink = new Intentsink();
            intentsink.setReference(ref);
            Target target = new Target();
            intentsink.setTarget(target);
            Data data = new Data();
            Attributes attributes = new Attributes();
            intentsink.setAttributes(attributes);
            String string5 = string.substring(9);
            string5 = string5.replace("Component Names:", "Component-Names:").replace("ICC Targets:", "ICC-Targets:").replace(": ", ":").replace("= ", "=").replace(" ", SEPARATOR);
            if (string5.contains("ICC-Targets:")) {
                String lineICC = string5.substring(string5.indexOf("ICC-Targets:")).replace(SEPARATOR, ",");
                String string6 = string5.substring(0, string5.indexOf("ICC-Targets:")) + lineICC;
            }
            String name = null;
            for (String part : var6_13.split(SEPARATOR)) {
                String value;
                if (part.contains("=")) {
                    if (part.startsWith("Data:")) {
                        part = part.substring(5);
                    }
                    name = this.cleanUpIntentPart(part.substring(0, part.indexOf("=")));
                    value = this.cleanUpIntentPart(part.substring(part.indexOf("=") + 1));
                } else if (part.contains(":")) {
                    name = this.cleanUpIntentPart(part.substring(0, part.indexOf(":")));
                    value = this.cleanUpIntentPart(part.substring(part.indexOf(":") + 1));
                } else {
                    value = this.cleanUpIntentPart(part);
                }
                if (name == null || value.equals("null")) continue;
                if (name.equals("Component-Names")) {
                    Reference targetComponent = new Reference();
                    targetComponent.setClassname(value);
                    targetComponent.setApp(this.app);
                    intentsink.getTarget().setReference(targetComponent);
                    continue;
                }
                if (name.equals("Actions")) {
                    intentsink.getTarget().getAction().add(value);
                    continue;
                }
                if (name.equals("Categories")) {
                    intentsink.getTarget().getCategory().add(value);
                    continue;
                }
                if (name.equals("host")) {
                    data.setHost(value);
                    if (target.getData().contains(data)) continue;
                    target.getData().add(data);
                    continue;
                }
                if (name.equals("Types")) {
                    data.setType(value);
                    if (target.getData().contains(data)) continue;
                    target.getData().add(data);
                    continue;
                }
                if (name.equals("pathPattern")) {
                    data.setPathPattern(value);
                    if (target.getData().contains(data)) continue;
                    target.getData().add(data);
                    continue;
                }
                if (name.equals("pathPrefix")) {
                    data.setPathPrefix(value);
                    if (target.getData().contains(data)) continue;
                    target.getData().add(data);
                    continue;
                }
                if (name.equals("path")) {
                    data.setPath(value);
                    if (target.getData().contains(data)) continue;
                    target.getData().add(data);
                    continue;
                }
                if (name.equals("port")) {
                    data.setPort(value);
                    if (target.getData().contains(data)) continue;
                    target.getData().add(data);
                    continue;
                }
                if (name.equals("schemes")) {
                    data.setScheme(value);
                    if (target.getData().contains(data)) continue;
                    target.getData().add(data);
                    continue;
                }
                if (name == null || name.isBlank() || name.equals("null") || value == null || value.isBlank() || value.equals("null")) continue;
                Attribute attribute = new Attribute();
                attribute.setName(name);
                attribute.setValue(value);
                attributes.getAttribute().add(attribute);
            }
            if (Helper.isEmpty(intentsink.getTarget())) continue;
            intentsinks.getIntentsink().add(intentsink);
        }
        if (intentfilters.getIntentfilter().size() > 0) {
            answer.setIntentfilters(intentfilters);
        }
        if (intentsinks.getIntentsink().size() > 0) {
            answer.setIntentsinks(intentsinks);
        }
    }

    protected String cleanUpIntentPart(String part) {
        return part.replaceAll("[\\[\\]\\(\\)]", "");
    }
}

