/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.converter.dialdroid;

import com.mysql.cj.jdbc.MysqlDataSource;
import de.foellix.aql.Log;
import de.foellix.aql.converter.IConverter;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.query.DefaultQuestion;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.helper.HashHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.ConverterTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ConverterDIALDroid
implements IConverter {
    private static final File DATABASE_PROPERTIES = new File(FileHelper.getConverterDirectory(), "dialdroid_config.properties");
    private List<String> logLines;

    @Override
    public Answer parse(ConverterTask task) {
        File resultFile = new File(task.getTaskInfo().getData("%RESULT_FILE%"));
        DefaultQuestion question = (DefaultQuestion)Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task);
        App appFrom = task.getTaskInfo().getData("%APP_APK_FROM%") != null ? Helper.createApp(task.getTaskInfo().getData("%APP_APK_FROM%")) : Helper.createApp(task.getTaskInfo().getData("%APP_APK_IN%"));
        App appTo = task.getTaskInfo().getData("%APP_APK_TO%") != null ? Helper.createApp(task.getTaskInfo().getData("%APP_APK_TO%")) : Helper.createApp(task.getTaskInfo().getData("%APP_APK_IN%"));
        try (BufferedReader br = new BufferedReader(new FileReader(resultFile));){
            this.logLines = new ArrayList<String>();
            String line = "";
            while ((line = br.readLine()) != null) {
                if (line.contains("com.mysql.jdbc.exceptions.jdbc4.MySQLIntegrityConstraintViolationException: Cannot add or update a child row: a foreign key constraint fails")) {
                    throw new IOException(line);
                }
                if (!line.contains(" (in ")) continue;
                this.logLines.add(line);
            }
        }
        catch (IOException e) {
            Log.error("Could not read log file: " + resultFile.getAbsolutePath());
        }
        Answer answer = new Answer();
        if (!this.logLines.isEmpty()) {
            Flows flows = new Flows();
            MysqlDataSource dataSource = new MysqlDataSource();
            try {
                Properties prop = new Properties();
                FileInputStream in = new FileInputStream(DATABASE_PROPERTIES);
                prop.load(in);
                in.close();
                dataSource.setUser(prop.getProperty("user"));
                if (prop.getProperty("password") != null && !prop.getProperty("password").equals("") && !prop.getProperty("password").equals(" ")) {
                    dataSource.setPassword(prop.getProperty("password"));
                }
                dataSource.setServerName(prop.getProperty("server"));
                dataSource.setDatabaseName(prop.getProperty("database"));
            }
            catch (IOException e) {
                Log.error("Could not read DIALDroid-Converter's config file: " + DATABASE_PROPERTIES.getAbsolutePath());
            }
            try {
                Connection conn = dataSource.getConnection();
                Statement stmt = conn.createStatement();
                String query = "SELECT ICCEntryLeaks.leak_sink AS toStatement, ICCExitLeaks.leak_source AS fromStatement, EntryPoints.method AS toMethod, ExitPoints.method AS fromMethod FROM SensitiveChannels JOIN Applications Applications_A ON Applications_A.id = SensitiveChannels.fromapp JOIN Applications Applications_B ON Applications_B.id = SensitiveChannels.toapp JOIN ExitPoints ON SensitiveChannels.exitpoint = ExitPoints.id JOIN ICCExitLeaks ON SensitiveChannels.exitpoint = ICCExitLeaks.exit_point_id JOIN EntryPoints ON SensitiveChannels.entryclass = EntryPoints.class_id JOIN ICCEntryLeaks ON EntryPoints.id = ICCEntryLeaks.entry_point_id WHERE Applications_A.shasum = '" + HashHelper.getHash(appFrom.getHashes(), "SHA-256").toUpperCase() + "' AND Applications_B.shasum = '" + (question.getAllReferences().size() > 1 ? HashHelper.getHash(appTo.getHashes(), "SHA-256").toUpperCase() : HashHelper.getHash(appFrom.getHashes(), "SHA-256").toUpperCase()) + "' GROUP BY CONCAT(toStatement, fromStatement, toMethod, fromMethod)";
                Log.msg(query, 6);
                ResultSet rs = stmt.executeQuery(query);
                while (rs.next()) {
                    Reference from = new Reference();
                    Reference to = new Reference();
                    from.setStatement(Helper.createStatement(rs.getString("fromStatement")));
                    from.setMethod(this.searchMethod(from.getStatement().getStatementfull()));
                    from.setClassname(Helper.cut(from.getMethod(), "<", ": "));
                    from.setApp(appFrom);
                    from.setType("from");
                    to.setStatement(Helper.createStatement(rs.getString("toStatement")));
                    to.setMethod(rs.getString("toMethod"));
                    to.setClassname(Helper.cut(rs.getString("toMethod"), "<", ": "));
                    to.setApp(question.getAllReferences().size() > 1 ? appTo : appFrom);
                    to.setType("to");
                    Flow flow = new Flow();
                    flow.getReference().add(from);
                    flow.getReference().add(to);
                    flows.getFlow().add(flow);
                }
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (Exception e) {
                Log.error("An error occurred while accessing the DIALDroid database: " + e.getMessage());
            }
            if (!flows.getFlow().isEmpty()) {
                answer.setFlows(flows);
            }
        }
        return answer;
    }

    private String searchMethod(String statement) {
        String method = null;
        try {
            for (String line : this.logLines) {
                if (!line.contains(statement) || !line.contains(" (in ")) continue;
                String temp = Helper.cutFromFirstToLast(line, " (in ", ")");
                if (method != null && !temp.equals(method)) {
                    return null;
                }
                if (method != null) continue;
                method = temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return method;
    }
}

