/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.converter.flowdroid;

import de.foellix.aql.Log;
import de.foellix.aql.converter.IConverter;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.task.ConverterTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConverterFD
implements IConverter {
    private static final String EMPTY_RESULT_FILE_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><DataFlowResults TerminationState=\"Success\"><Results></Results></DataFlowResults>";
    private App app;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Answer parse(ConverterTask task) {
        File resultFile = new File(task.getTaskInfo().getData("%RESULT_FILE%"));
        this.app = Helper.createApp(Helper.getAppFromData(task.getTaskInfo()));
        Answer answer = new Answer();
        if (this.app != null) {
            answer.setFlows(new Flows());
            try {
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
                Document resultDocument = domBuilder.parse(resultFile);
                resultDocument.getDocumentElement().normalize();
                if (resultDocument.getElementsByTagName("Result") == null) return answer;
                NodeList results = resultDocument.getElementsByTagName("Result");
                for (int i = 0; i < results.getLength(); ++i) {
                    Element resultNode = (Element)results.item(i);
                    Node sink = resultNode.getElementsByTagName("Sink").item(0);
                    Reference sinkRef = this.getReference(sink, false);
                    NodeList sources = ((Element)resultNode.getElementsByTagName("Sources").item(0)).getElementsByTagName("Source");
                    for (int j = 0; j < sources.getLength(); ++j) {
                        Reference sourceRef = this.getReference(sources.item(j), true);
                        Flow newFlow = new Flow();
                        newFlow.getReference().add(sourceRef);
                        newFlow.getReference().add(sinkRef);
                        answer.getFlows().getFlow().add(newFlow);
                    }
                }
                return answer;
            }
            catch (Exception e) {
                Log.error("Error while reading file: " + resultFile.getAbsolutePath() + Log.getExceptionAppendix(e));
                return answer;
            }
        } else {
            Log.error("Error while converting result: App object was not created!");
        }
        return answer;
    }

    private Reference getReference(Node sourceOrSinkNode, boolean isSource) {
        int linenumber;
        Element node = (Element)sourceOrSinkNode;
        String statement = node.getAttribute("Statement");
        String method = node.getAttribute("Method");
        String classname = Helper.cut(method, "<", ": ");
        try {
            linenumber = node.hasAttribute("LineNumber") && node.getAttribute("LineNumber") != null && !node.getAttribute("LineNumber").isEmpty() ? Integer.parseInt(node.getAttribute("LineNumber")) : -1;
        }
        catch (NumberFormatException e) {
            linenumber = -1;
        }
        Reference ref = new Reference();
        if (isSource) {
            ref.setType("from");
        } else {
            ref.setType("to");
        }
        ref.setApp(this.app);
        ref.setClassname(classname);
        ref.setMethod(method);
        ref.setStatement(Helper.createStatement(statement));
        if (linenumber > 0) {
            ref.getStatement().setLinenumber(linenumber);
        }
        return ref;
    }

    @Override
    public File recoverResultFromOutput(List<String> output, File expectedResultFile) {
        if (output.contains("[main] WARN soot.jimple.infoflow.android.SetupApplication - No entry points")) {
            expectedResultFile = new File(expectedResultFile.getAbsolutePath().replace('*', '_'));
            try {
                Files.write(expectedResultFile.toPath(), EMPTY_RESULT_FILE_CONTENT.getBytes(), new OpenOption[0]);
                Log.msg("Recovered answer file (\"" + expectedResultFile.getAbsolutePath() + "\") from FlowDroid's output.", 6);
                return expectedResultFile;
            }
            catch (IOException e) {
                Log.msg("Could not recover answer file (\"" + expectedResultFile.getAbsolutePath() + "\") from FlowDroid's output.", 6);
            }
        }
        return IConverter.super.recoverResultFromOutput(output, expectedResultFile);
    }
}

