/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.converter.ic3;

import de.foellix.aql.Log;
import de.foellix.aql.converter.IConverter;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Data;
import de.foellix.aql.datastructure.Intent;
import de.foellix.aql.datastructure.Intentfilter;
import de.foellix.aql.datastructure.Intentfilters;
import de.foellix.aql.datastructure.Intents;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsinks;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Intentsources;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.Target;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.task.ConverterTask;
import edu.psu.cse.siis.ic3.Ic3Data;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ConverterIC3
implements IConverter {
    @Override
    public Answer parse(ConverterTask task) {
        Ic3Data.Application app;
        File resultFile = new File(task.getTaskInfo().getData("%RESULT_FILE%"));
        App appRef = Helper.createApp(Helper.getAppFromData(task.getTaskInfo()));
        try {
            FileInputStream input = new FileInputStream(resultFile);
            app = Ic3Data.Application.parseFrom(input);
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error("Error while reading file: " + resultFile.getAbsolutePath());
            return null;
        }
        return this.convert(app, appRef);
    }

    private Answer convert(Ic3Data.Application data, App appRef) {
        Answer answer = new Answer();
        Log.msg(data.toString(), 6);
        if (data.getComponentsList() != null && !data.getComponentsList().isEmpty()) {
            answer.setIntentfilters(new Intentfilters());
            for (Ic3Data.Application.Component component : data.getComponentsList()) {
                Reference originReduced;
                Ic3Data.Application.Component.Instruction instruction;
                for (Ic3Data.Application.Component.Extra ex : component.getExtrasList()) {
                    instruction = ex.getInstruction();
                    originReduced = new Reference();
                    originReduced.setClassname(instruction.getClassName());
                    originReduced.setApp(appRef);
                    if (component.getIntentFiltersList().isEmpty()) continue;
                    for (Ic3Data.Application.Component.IntentFilter intentfilter : component.getIntentFiltersList()) {
                        Intentfilter intentfilterObj = new Intentfilter();
                        intentfilterObj.setReference(originReduced);
                        Object dataObj = null;
                        for (Ic3Data.Attribute attribute : intentfilter.getAttributesList()) {
                            if (attribute.getKind() == Ic3Data.AttributeKind.CATEGORY) {
                                for (String value : attribute.getValueList()) {
                                    intentfilterObj.getCategory().add(value);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.ACTION) {
                                for (String value : attribute.getValueList()) {
                                    intentfilterObj.getAction().add(value);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.TYPE) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || ((Data)dataObj).getType() != null) {
                                        dataObj = new Data();
                                    }
                                    ((Data)dataObj).setType(value);
                                    intentfilterObj.getData().add((Data)dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.SCHEME) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || ((Data)dataObj).getScheme() != null) {
                                        dataObj = new Data();
                                    }
                                    ((Data)dataObj).setScheme(value);
                                    intentfilterObj.getData().add((Data)dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.SSP) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || ((Data)dataObj).getSsp() != null) {
                                        dataObj = new Data();
                                    }
                                    ((Data)dataObj).setSsp(value);
                                    intentfilterObj.getData().add((Data)dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.HOST) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || ((Data)dataObj).getHost() != null) {
                                        dataObj = new Data();
                                    }
                                    ((Data)dataObj).setHost(value);
                                    intentfilterObj.getData().add((Data)dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.PORT) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || ((Data)dataObj).getPort() != null) {
                                        dataObj = new Data();
                                    }
                                    ((Data)dataObj).setPort(value);
                                    intentfilterObj.getData().add((Data)dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.PATH) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || ((Data)dataObj).getPath() != null) {
                                        dataObj = new Data();
                                    }
                                    ((Data)dataObj).setPath(value);
                                    intentfilterObj.getData().add((Data)dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.URI) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || ((Data)dataObj).getScheme() != null || ((Data)dataObj).getHost() != null || ((Data)dataObj).getPort() != null || ((Data)dataObj).getPath() != null) {
                                        dataObj = new Data();
                                    }
                                    Helper.extractDataFromURI(value, (Data)dataObj);
                                    intentfilterObj.getData().add((Data)dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() != Ic3Data.AttributeKind.AUTHORITY) continue;
                            for (String value : attribute.getValueList()) {
                                if (dataObj == null || ((Data)dataObj).getHost() != null || value.contains(":") && ((Data)dataObj).getPort() != null) {
                                    dataObj = new Data();
                                }
                                Helper.extractDataFromAuthority(value, (Data)dataObj);
                                intentfilterObj.getData().add((Data)dataObj);
                            }
                        }
                        answer.getIntentfilters().getIntentfilter().add(intentfilterObj);
                    }
                }
                if (!component.getExtrasList().isEmpty()) {
                    if (answer.getIntentsources() == null) {
                        answer.setIntentsources(new Intentsources());
                    }
                    for (Ic3Data.Application.Component.Extra ex : component.getExtrasList()) {
                        instruction = ex.getInstruction();
                        originReduced = new Reference();
                        originReduced.setClassname(instruction.getClassName());
                        Reference origin = new Reference();
                        origin.setStatement(Helper.createStatement(instruction.getStatement()));
                        origin.setMethod(instruction.getMethod());
                        origin.setClassname(instruction.getClassName());
                        origin.setApp(appRef);
                        Intentsource intentsourceExp = new Intentsource();
                        intentsourceExp.setReference(origin);
                        Target targetExp = new Target();
                        targetExp.setReference(originReduced);
                        intentsourceExp.setTarget(targetExp);
                        answer.getIntentsources().getIntentsource().add(intentsourceExp);
                        if (component.getIntentFiltersList().isEmpty()) continue;
                        for (Ic3Data.Application.Component.IntentFilter intentfilter : component.getIntentFiltersList()) {
                            Intentsource intentsource = new Intentsource();
                            intentsource.setReference(origin);
                            Target targetImp = new Target();
                            Data dataObj = null;
                            for (Ic3Data.Attribute attribute : intentfilter.getAttributesList()) {
                                if (attribute.getKind() == Ic3Data.AttributeKind.CATEGORY) {
                                    for (String value : attribute.getValueList()) {
                                        targetImp.getCategory().add(value);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() == Ic3Data.AttributeKind.ACTION) {
                                    for (String value : attribute.getValueList()) {
                                        targetImp.getAction().add(value);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() == Ic3Data.AttributeKind.TYPE) {
                                    for (String value : attribute.getValueList()) {
                                        if (dataObj == null || dataObj.getType() != null) {
                                            dataObj = new Data();
                                        }
                                        dataObj.setType(value);
                                        targetImp.getData().add(dataObj);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() == Ic3Data.AttributeKind.SCHEME) {
                                    for (String value : attribute.getValueList()) {
                                        if (dataObj == null || dataObj.getScheme() != null) {
                                            dataObj = new Data();
                                        }
                                        dataObj.setScheme(value);
                                        targetImp.getData().add(dataObj);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() == Ic3Data.AttributeKind.SSP) {
                                    for (String value : attribute.getValueList()) {
                                        if (dataObj == null || dataObj.getSsp() != null) {
                                            dataObj = new Data();
                                        }
                                        dataObj.setSsp(value);
                                        targetImp.getData().add(dataObj);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() == Ic3Data.AttributeKind.HOST) {
                                    for (String value : attribute.getValueList()) {
                                        if (dataObj == null || dataObj.getHost() != null) {
                                            dataObj = new Data();
                                        }
                                        dataObj.setHost(value);
                                        targetImp.getData().add(dataObj);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() == Ic3Data.AttributeKind.PORT) {
                                    for (String value : attribute.getValueList()) {
                                        if (dataObj == null || dataObj.getPort() != null) {
                                            dataObj = new Data();
                                        }
                                        dataObj.setPort(value);
                                        targetImp.getData().add(dataObj);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() == Ic3Data.AttributeKind.PATH) {
                                    for (String value : attribute.getValueList()) {
                                        if (dataObj == null || dataObj.getPath() != null) {
                                            dataObj = new Data();
                                        }
                                        dataObj.setPath(value);
                                        targetImp.getData().add(dataObj);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() == Ic3Data.AttributeKind.URI) {
                                    for (String value : attribute.getValueList()) {
                                        if (dataObj == null || dataObj.getScheme() != null || dataObj.getHost() != null || dataObj.getPort() != null || dataObj.getPath() != null) {
                                            dataObj = new Data();
                                        }
                                        Helper.extractDataFromURI(value, dataObj);
                                        targetImp.getData().add(dataObj);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() != Ic3Data.AttributeKind.AUTHORITY) continue;
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || dataObj.getHost() != null || value.contains(":") && dataObj.getPort() != null) {
                                        dataObj = new Data();
                                    }
                                    Helper.extractDataFromAuthority(value, dataObj);
                                    targetImp.getData().add(dataObj);
                                }
                            }
                            intentsource.setTarget(targetImp);
                            answer.getIntentsources().getIntentsource().add(intentsource);
                        }
                    }
                }
                if (component.getExitPointsList().isEmpty()) continue;
                if (answer.getIntents() == null) {
                    answer.setIntents(new Intents());
                }
                if (answer.getIntentsinks() == null) {
                    answer.setIntentsinks(new Intentsinks());
                }
                for (Ic3Data.Application.Component.ExitPoint exitpoint : component.getExitPointsList()) {
                    instruction = exitpoint.getInstruction();
                    Reference origin = new Reference();
                    origin.setStatement(Helper.createStatement(instruction.getStatement()));
                    origin.setMethod(instruction.getMethod());
                    origin.setClassname(instruction.getClassName());
                    origin.setApp(appRef);
                    for (Ic3Data.Application.Component.ExitPoint.Intent intent : exitpoint.getIntentsList()) {
                        Intent intentObj = new Intent();
                        Intentsink intentsink = new Intentsink();
                        intentObj.setReference(origin);
                        intentsink.setReference(origin);
                        Target target = new Target();
                        Reference targetRef = null;
                        Data dataObj = null;
                        for (Ic3Data.Attribute attribute : intent.getAttributesList()) {
                            if (attribute.getKind() == Ic3Data.AttributeKind.CATEGORY) {
                                for (String value : attribute.getValueList()) {
                                    target.getCategory().add(value);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.ACTION) {
                                for (String value : attribute.getValueList()) {
                                    target.getAction().add(value);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.TYPE) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || dataObj.getType() != null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setType(value);
                                    target.getData().add(dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.SCHEME) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || dataObj.getScheme() != null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setScheme(value);
                                    target.getData().add(dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.SSP) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || dataObj.getSsp() != null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setSsp(value);
                                    target.getData().add(dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.HOST) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || dataObj.getHost() != null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setHost(value);
                                    target.getData().add(dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.PORT) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || dataObj.getPort() != null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setPort(value);
                                    target.getData().add(dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.PATH) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || dataObj.getPath() != null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setPath(value);
                                    target.getData().add(dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.URI) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || dataObj.getScheme() != null || dataObj.getHost() != null || dataObj.getPort() != null || dataObj.getPath() != null) {
                                        dataObj = new Data();
                                    }
                                    Helper.extractDataFromURI(value, dataObj);
                                    target.getData().add(dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.AUTHORITY) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null || dataObj.getHost() != null || value.contains(":") && dataObj.getPort() != null) {
                                        dataObj = new Data();
                                    }
                                    Helper.extractDataFromAuthority(value, dataObj);
                                    target.getData().add(dataObj);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.CLASS) {
                                for (String value : attribute.getValueList()) {
                                    if (targetRef == null) {
                                        targetRef = new Reference();
                                    }
                                    targetRef.setClassname(value.replace("/", "."));
                                }
                                continue;
                            }
                            if (attribute.getKind() != Ic3Data.AttributeKind.PACKAGE) continue;
                            for (String value : attribute.getValueList()) {
                                if (targetRef == null) {
                                    targetRef = new Reference();
                                }
                                if (targetRef.getClassname() != null && !targetRef.getClassname().isEmpty()) continue;
                                targetRef.setClassname(value);
                            }
                        }
                        if (targetRef != null) {
                            target.setReference(targetRef);
                        }
                        intentObj.setTarget(target);
                        intentsink.setTarget(target);
                        answer.getIntents().getIntent().add(intentObj);
                        answer.getIntentsinks().getIntentsink().add(intentsink);
                    }
                }
            }
        }
        return answer;
    }
}

