/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.converter.iccta;

import de.foellix.aql.Log;
import de.foellix.aql.converter.IConverter;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.Statement;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.task.ConverterTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ConverterIccTA
implements IConverter {
    @Override
    public Answer parse(ConverterTask task) {
        File resultFile = new File(task.getTaskInfo().getData("%RESULT_FILE%"));
        App app = Helper.createApp(Helper.getAppFromData(task.getTaskInfo()));
        Answer answer = new Answer();
        answer.setFlows(new Flows());
        try {
            Flow flow = new Flow();
            Reference to = null;
            FileReader fr = new FileReader(resultFile);
            BufferedReader br = new BufferedReader(fr);
            String zeile = "";
            while ((zeile = br.readLine()) != null) {
                String classname;
                String method;
                String statement;
                if (zeile.contains("The sink") && zeile.contains("was called with values from the following sources:")) {
                    statement = Helper.cut(zeile, "The sink ", " in method ");
                    method = Helper.cut(zeile, " in method ", " was called with values from the following sources:");
                    classname = Helper.cut(method, "<", ": ");
                    to = new Reference();
                    to.setType("to");
                    to.setApp(app);
                    to.setClassname(classname);
                    to.setMethod(method);
                    to.setStatement(this.createStatement(statement));
                    flow = new Flow();
                    flow.getReference().add(to);
                    continue;
                }
                if (!zeile.contains("[main] INFO soot.jimple.infoflow.Infoflow - - ") || !zeile.contains(" in method ")) continue;
                statement = Helper.cut(zeile, "[main] INFO soot.jimple.infoflow.Infoflow - - ", " in method ");
                method = Helper.cut(zeile, " in method ");
                classname = Helper.cut(method, "<", ": ");
                Reference from = new Reference();
                from.setType("from");
                from.setApp(app);
                from.setClassname(classname);
                from.setMethod(method);
                from.setStatement(this.createStatement(statement));
                flow.getReference().add(from);
                if (to == null) continue;
                answer.getFlows().getFlow().add(flow);
                flow = new Flow();
                flow.getReference().add(to);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error("Error while reading file: " + resultFile.getAbsolutePath());
            return null;
        }
        return answer;
    }

    private Statement createStatement(String statement) {
        int lineNumber;
        try {
            if (!statement.contains(" on line ")) {
                throw new StringIndexOutOfBoundsException("\" on line \" not found in: " + statement);
            }
            String[] parts = statement.split(" on line ");
            lineNumber = Integer.parseInt(parts[1]);
            statement = parts[0];
        }
        catch (Exception e) {
            lineNumber = -1;
        }
        return Helper.createStatement(statement, lineNumber);
    }
}

