/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure.handler;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnswerSanitizer {
    private static final String[] ELEMTNS_WITH_ATTRIBUTES = new String[]{"permission", "intentsource", "intentsink", "intent", "intentfilter", "flow", "source", "sink"};
    private static final List<String> ALL_KNOWN_ELEMENTS = Arrays.asList("hash", "file", "hashes", "method", "classname", "app", "name", "value", "attribute", "reference", "attributes", "permission", "type", "scheme", "ssp", "sspPattern", "sspPrefix", "host", "port", "path", "pathPattern", "pathPrefix", "action", "category", "data", "parameter", "statementfull", "statementgeneric", "linenumber", "parameters", "statement", "target", "intentsource", "intentsink", "intent", "intentfilter", "flow", "source", "sink", "permissions", "intentsources", "intentsinks", "intents", "intentfilters", "flows", "sources", "sinks", "answer");

    public static String sanitize(File xmlFile) {
        try {
            Document newDoc;
            FileInputStream is = new FileInputStream(xmlFile);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document oldDoc = builder.parse(is);
            Element oldRoot = oldDoc.getDocumentElement();
            if (oldRoot.getNodeName().equals("answer")) {
                newDoc = oldDoc;
            } else {
                newDoc = builder.newDocument();
                Element newRoot = newDoc.createElement("answer");
                newDoc.appendChild(newRoot);
                newRoot.appendChild(newDoc.importNode(oldRoot, true));
            }
            for (String listElement : ELEMTNS_WITH_ATTRIBUTES) {
                NodeList nl = newDoc.getElementsByTagName(listElement);
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node childNlE;
                    int j;
                    Node nlE = nl.item(i);
                    NodeList childNl = nlE.getChildNodes();
                    Node attributes = null;
                    for (j = 0; j < childNl.getLength(); ++j) {
                        childNlE = childNl.item(j);
                        if (!childNlE.getNodeName().equals("attributes")) continue;
                        attributes = childNlE;
                    }
                    if (attributes == null) {
                        Element newAttributes = newDoc.createElement("attributes");
                        attributes = newAttributes;
                        nlE.appendChild(attributes);
                    }
                    for (j = 0; j < childNl.getLength(); ++j) {
                        childNlE = childNl.item(j);
                        if (childNlE.getNodeName().startsWith("#") || childNlE.getNodeName().equals("attributes") || ALL_KNOWN_ELEMENTS.contains(childNlE.getNodeName())) continue;
                        Element newAttribute = newDoc.createElement("attribute");
                        Element newName = newDoc.createElement("name");
                        newName.setTextContent(childNlE.getNodeName());
                        Element newValue = newDoc.createElement("value");
                        newValue.setTextContent(childNlE.getTextContent());
                        newAttribute.appendChild(newName);
                        newAttribute.appendChild(newValue);
                        attributes.appendChild(newAttribute);
                    }
                }
            }
            DOMSource domSource = new DOMSource(newDoc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (Exception e) {
            Log.error("Could not parse AQL-Answer: " + xmlFile.getAbsolutePath() + Log.getExceptionAppendix(e));
            return AnswerHandler.createXMLString(new Answer());
        }
    }
}

