/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure.handler;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.handler.ParseException;
import de.foellix.aql.datastructure.handler.QuestionHandler;
import de.foellix.aql.datastructure.handler.QuestionParser;
import de.foellix.aql.datastructure.query.Query;
import de.foellix.aql.ui.gui.GUI;
import java.io.ByteArrayInputStream;

public class QueryHandler {
    public static Query parseQuery(String query) {
        return QueryHandler.parseQuery(query, false);
    }

    public static Query parseQuery(String query, boolean ignoreExceptions) {
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(query.getBytes());
            QuestionParser parser = new QuestionParser(input);
            parser.queries();
            QuestionHandler questionHandler = parser.getQuestionHandler();
            Query currentQuery = questionHandler.getQuery();
            return currentQuery;
        }
        catch (ParseException e) {
            if (!ignoreExceptions) {
                Log.error("Query is not valid! Syntax error at line " + e.currentToken.beginLine + " near symbol \"" + e.currentToken.image + "\".");
                if (GUI.started) {
                    GUI.alert(true, "Error", "Query is not valid!", "Syntax error at line " + e.currentToken.beginLine + " near symbol \"" + e.currentToken.image + "\".");
                }
                if (Log.logIt(6)) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

