/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure.handler;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.query.DefaultQuestion;
import de.foellix.aql.datastructure.query.FilterQuestion;
import de.foellix.aql.datastructure.query.IStringOrQuestion;
import de.foellix.aql.datastructure.query.LoadingQuestion;
import de.foellix.aql.datastructure.query.OperatorQuestion;
import de.foellix.aql.datastructure.query.Query;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.datastructure.query.QuestionReference;
import de.foellix.aql.datastructure.query.QuestionString;
import de.foellix.aql.datastructure.query.StringOrQuestionPair;
import java.io.File;
import java.util.ArrayList;
import java.util.Stack;

public class QuestionHandler {
    private static final int ARGUMENT_FEATURES = 1;
    private static final int ARGUMENT_USES = 2;
    private static final int ARGUMENT_WITHS_KEY = 3;
    private static final int ARGUMENT_WITHS_VALUE = 4;
    private static final int ARGUMENT_REFERENCE_STATEMENT = 5;
    private static final int ARGUMENT_REFERENCE_METHOD = 6;
    private static final int ARGUMENT_REFERENCE_CLASS = 7;
    private static final int ARGUMENT_REFERENCE_APP = 8;
    private static final int ARGUMENT_FILTER_KEY = 9;
    private static final int ARGUMENT_FILTER_VALUE = 10;
    private static final int ARGUMENT_PREPROCESSOR_KEYWORD = 15;
    private static final int OPERATOR_QUESTIONS = 16;
    private static final int FILTER_QUESTION = 17;
    private Query completeQuery;
    private Stack<QuestionReference> referenceStack;
    private boolean bracketsActive;
    private Stack<Integer> innerQueryMode;
    private Stack<StringOrQuestionPair> filterKeyValuePairs;
    private String variable;

    public void startQueries() {
        this.completeQuery = new Query();
        this.referenceStack = new Stack();
        this.bracketsActive = false;
        this.innerQueryMode = new Stack();
        this.filterKeyValuePairs = new Stack();
        this.variable = null;
    }

    public void endQueries() {
        if (this.completeQuery.getQuestionStack().isEmpty()) {
            this.completeQuery.destroy();
        } else {
            Log.error("Query corrupted: Question stack was not empty after reading the complete query.");
        }
        if (this.referenceStack.isEmpty()) {
            this.referenceStack = null;
        } else {
            Log.error("Query corrupted: Reference stack was not empty after reading the complete query.");
        }
    }

    public void startQuery() {
    }

    public void activateBrackets() {
        this.bracketsActive = true;
    }

    public void deactivateBrackets() {
        this.bracketsActive = false;
    }

    public void endQuery() {
    }

    public void startQuestion() {
    }

    public void endQuestion(String endingSymbol) {
        this.getCurrentQuestion().setEndingSymbol(endingSymbol.charAt(0));
        this.completeQuery.getQuestionStack().pop();
    }

    public void startDefaultQuestion() {
        this.addQuestion(new DefaultQuestion());
    }

    public void startOperatorQuestion(String operator) {
        this.addQuestion(new OperatorQuestion(operator));
    }

    public void startInnerOperatorQuestions() {
        this.innerQueryMode.push(16);
    }

    public void endInnerOperatorQuestions() {
        this.innerQueryMode.pop();
    }

    public void startFilterQuestion() {
        this.addQuestion(new FilterQuestion());
    }

    public void startInnerFilterQuestion() {
        this.innerQueryMode.push(17);
    }

    public void endInnerFilterQuestion() {
        this.innerQueryMode.pop();
    }

    public void startLoadingQuestion() {
        this.addQuestion(new LoadingQuestion());
    }

    public void endDefaultQuestion() {
    }

    public void endOperatorQuestion() {
    }

    public void endFilterQuestion() {
    }

    public void endLoadingQuestion() {
    }

    public void setSubjectOfInterest(String subjectOfInterest) {
        this.getCurrentDefaultQuestion().setSubjectOfInterest(subjectOfInterest);
    }

    public void startFeatures() {
        this.getCurrentDefaultQuestion().setFeatures(new ArrayList<IStringOrQuestion>());
    }

    public void addFeature(String feature) {
        this.getCurrentDefaultQuestion().getFeatures().add(new QuestionString(this.removeQuotes(feature)));
    }

    public void startFeaturesQuery() {
        this.innerQueryMode.push(1);
    }

    public void endFeaturesQuery() {
        this.innerQueryMode.pop();
    }

    public void endFeatures() {
    }

    public void startUses() {
        this.getCurrentDefaultQuestion().setUses(new ArrayList<IStringOrQuestion>());
    }

    public void addUse(String use) {
        this.getCurrentDefaultQuestion().getUses().add(new QuestionString(this.removeQuotes(use)));
    }

    public void startUsesQuery() {
        this.innerQueryMode.push(2);
    }

    public void endUsesQuery() {
        this.innerQueryMode.pop();
    }

    public void endUses() {
    }

    public void startWiths() {
        this.getCurrentDefaultQuestion().setWiths(new Stack<StringOrQuestionPair>());
    }

    public void startWith() {
        this.getCurrentDefaultQuestion().getWiths().push(new StringOrQuestionPair());
    }

    public void setWithKey(String key) {
        this.getCurrentDefaultQuestion().getWiths().peek().setKey(new QuestionString(this.removeQuotes(key)));
    }

    public void startWithKeyQuery() {
        this.innerQueryMode.push(3);
    }

    public void endWithKeyQuery() {
        this.innerQueryMode.pop();
    }

    public void setWithValue(String value) {
        this.getCurrentDefaultQuestion().getWiths().peek().setValue(new QuestionString(this.removeQuotes(value)));
    }

    public void startWithValueQuery() {
        this.innerQueryMode.push(4);
    }

    public void endWithValueQuery() {
        this.innerQueryMode.pop();
    }

    public void startWithsQuery() {
    }

    public void endWithsQuery() {
    }

    public void endWith() {
    }

    public void endWiths() {
    }

    public void startFilterKeyValuePair() {
        this.filterKeyValuePairs.push(new StringOrQuestionPair());
    }

    public void startFilterKeyQuery() {
        this.innerQueryMode.push(9);
    }

    public void endFilterKeyQuery() {
        this.innerQueryMode.pop();
    }

    public void setFilterKey(String key) {
        this.filterKeyValuePairs.peek().setKey(new QuestionString(this.removeQuotes(key)));
    }

    public void startFilterValueQuery() {
        this.innerQueryMode.push(10);
    }

    public void endFilterValueQuery() {
        this.innerQueryMode.pop();
    }

    public void setFilterValue(String value) {
        this.filterKeyValuePairs.peek().setValue(new QuestionString(this.removeQuotes(value)));
    }

    public void endFilterKeyValuePair() {
        this.getCurrentFilterQuestion().setFilterPair(this.filterKeyValuePairs.pop());
    }

    public void startFilterReference() {
        this.referenceStack.push(new QuestionReference());
        this.getCurrentFilterQuestion().setFilterReference(this.referenceStack.peek());
    }

    public void endFilterReference() {
    }

    public void setFilterSubjectOfInterest(String subjectOfInterest) {
        this.getCurrentFilterQuestion().setFilterSubjectOfInterest(subjectOfInterest);
    }

    public void startFrom() {
        this.referenceStack.push(new QuestionReference());
        this.getCurrentDefaultQuestion().setFrom(this.referenceStack.peek());
    }

    public void endFrom() {
    }

    public void startTo() {
        this.referenceStack.push(new QuestionReference());
        this.getCurrentDefaultQuestion().setTo(this.referenceStack.peek());
    }

    public void endTo() {
    }

    public void startIn() {
        this.referenceStack.push(new QuestionReference());
        this.getCurrentDefaultQuestion().setIn(this.referenceStack.peek());
    }

    public void endIn() {
    }

    public void startReference() {
    }

    public void setStatement(String statement) {
        this.referenceStack.peek().setStatement(new QuestionString(this.removeQuotes(statement)));
    }

    public void setLineNumber(String lineNumber) {
        this.referenceStack.peek().setLineNumber(Integer.parseInt(lineNumber));
    }

    public void startStatementQuery() {
        this.innerQueryMode.push(5);
    }

    public void endStatementQuery() {
        this.innerQueryMode.pop();
    }

    public void setMethod(String method) {
        this.referenceStack.peek().setMethod(new QuestionString(this.removeQuotes(method)));
    }

    public void startMethodQuery() {
        this.innerQueryMode.push(6);
    }

    public void endMethodQuery() {
        this.innerQueryMode.pop();
    }

    public void setClass(String classname) {
        this.referenceStack.peek().setClassname(new QuestionString(this.removeQuotes(classname)));
    }

    public void startClassQuery() {
        this.innerQueryMode.push(7);
    }

    public void endClassQuery() {
        this.innerQueryMode.pop();
    }

    public void setApp(String app) {
        this.referenceStack.peek().setApp(new QuestionString(this.sanitizeFile(this.removeQuotes(app))));
    }

    public void startAppQuery() {
        this.innerQueryMode.push(8);
    }

    public void endAppQuery() {
        this.innerQueryMode.pop();
    }

    public void endReference() {
        this.referenceStack.pop();
    }

    public void setKeyword(String keyword) {
        this.referenceStack.peek().getPreprocessorKeywords().add(new QuestionString(this.removeQuotes(keyword)));
    }

    public void startKeywordQuery() {
        this.innerQueryMode.push(15);
    }

    public void endKeywordQuery() {
        this.innerQueryMode.pop();
    }

    public void addAnswer(String file) {
        this.getCurrentLoadingQuestion().setFile(this.removeQuotes(file));
    }

    private void addQuestion(Question question) {
        question.setParent(this.getCurrentQuestion());
        question.setWithBrackets(this.bracketsActive);
        if (this.completeQuery.getQuestionStack() != null && !this.completeQuery.getQuestionStack().isEmpty()) {
            switch (this.innerQueryMode.peek()) {
                case 16: {
                    if (this.getCurrentQuestion() instanceof FilterQuestion) {
                        this.getCurrentFilterQuestion().setQuestion(question);
                        break;
                    }
                    if (this.getCurrentQuestion() instanceof OperatorQuestion) {
                        this.getCurrentOperatorQuestion().getQuestions().add(question);
                        break;
                    }
                    this.addQuestionToListOrVariable(question);
                    break;
                }
                case 17: {
                    if (this.getCurrentQuestion() instanceof FilterQuestion) {
                        this.getCurrentFilterQuestion().setQuestion(question);
                        break;
                    }
                    if (this.getCurrentQuestion() instanceof OperatorQuestion) {
                        this.getCurrentOperatorQuestion().getQuestions().add(question);
                        break;
                    }
                    this.addQuestionToListOrVariable(question);
                    break;
                }
                case 1: {
                    this.getCurrentDefaultQuestion().getFeatures().add(question);
                    break;
                }
                case 2: {
                    this.getCurrentDefaultQuestion().getUses().add(question);
                    break;
                }
                case 3: {
                    this.getCurrentDefaultQuestion().getWiths().peek().setKey(question);
                    break;
                }
                case 4: {
                    this.getCurrentDefaultQuestion().getWiths().peek().setValue(question);
                    break;
                }
                case 5: {
                    this.referenceStack.peek().setStatement(question);
                    break;
                }
                case 6: {
                    this.referenceStack.peek().setMethod(question);
                    break;
                }
                case 7: {
                    this.referenceStack.peek().setClassname(question);
                    break;
                }
                case 8: {
                    this.referenceStack.peek().setApp(question);
                    break;
                }
                case 9: {
                    this.filterKeyValuePairs.peek().setKey(question);
                    break;
                }
                case 10: {
                    this.filterKeyValuePairs.peek().setValue(question);
                    break;
                }
                case 15: {
                    this.referenceStack.peek().getPreprocessorKeywords().add(question);
                    break;
                }
                default: {
                    Log.error("Query corrupted: Inner query placed at invalid position.");
                    break;
                }
            }
        } else {
            this.addQuestionToListOrVariable(question);
        }
        this.completeQuery.getQuestionStack().push(question);
    }

    private void addQuestionToListOrVariable(Question question) {
        if (this.variable == null) {
            this.completeQuery.getQuestions().add(question);
        } else {
            this.completeQuery.getVariableMap().put(this.variable, question);
            this.variable = null;
        }
    }

    private Question getCurrentQuestion() {
        if (this.completeQuery.getQuestionStack().isEmpty()) {
            return null;
        }
        return this.completeQuery.getQuestionStack().peek();
    }

    private DefaultQuestion getCurrentDefaultQuestion() {
        if (this.getCurrentQuestion() instanceof DefaultQuestion) {
            return (DefaultQuestion)this.getCurrentQuestion();
        }
        Log.error("Query corrupted: A different question type (default) was expected.");
        return null;
    }

    private OperatorQuestion getCurrentOperatorQuestion() {
        if (this.getCurrentQuestion() instanceof OperatorQuestion) {
            return (OperatorQuestion)this.getCurrentQuestion();
        }
        Log.error("Query corrupted: A different question type (operator) was expected.");
        return null;
    }

    private FilterQuestion getCurrentFilterQuestion() {
        if (this.getCurrentQuestion() instanceof FilterQuestion) {
            return (FilterQuestion)this.getCurrentQuestion();
        }
        Log.error("Query corrupted: A different question type (filter) was expected.");
        return null;
    }

    private LoadingQuestion getCurrentLoadingQuestion() {
        if (this.getCurrentQuestion() instanceof LoadingQuestion) {
            return (LoadingQuestion)this.getCurrentQuestion();
        }
        Log.error("Query corrupted: A different question type (loading) was expected.");
        return null;
    }

    private String removeQuotes(String value) {
        return value.substring(1, value.length() - 1);
    }

    private String sanitizeFile(String file) {
        if (file.startsWith("%") && file.endsWith("%")) {
            return file;
        }
        return new File(file.replace("\\", "/")).getAbsolutePath();
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public void getVariable(String variable) {
        if (this.completeQuery.getVariableMap().containsKey(variable)) {
            Question variableQuestion = this.completeQuery.getVariableMap().get(variable);
            if (this.completeQuery.getQuestionStack().isEmpty()) {
                this.completeQuery.getQuestions().add(variableQuestion);
            } else {
                if (variableQuestion.isWithBrackets()) {
                    this.activateBrackets();
                }
                this.addQuestion(variableQuestion);
                this.endQuestion(String.valueOf(variableQuestion.getEndingSymbol()).toString());
                this.deactivateBrackets();
            }
        } else {
            Log.error("Query corrupted: Variable \"" + variable + "\" was not declared before usage.");
        }
    }

    public Query getQuery() {
        return this.completeQuery;
    }
}

