/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure.query;

import de.foellix.aql.datastructure.query.IStringOrQuestion;
import de.foellix.aql.datastructure.query.OperatorQuestion;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.datastructure.query.QuestionReference;
import de.foellix.aql.datastructure.query.StringOrQuestionPair;
import java.util.Collection;
import java.util.HashSet;

public class FilterQuestion
extends OperatorQuestion {
    private static final long serialVersionUID = -6492486171076759598L;
    private static String OPERATOR = "FILTER";
    private Question question;
    private StringOrQuestionPair filterPair;
    private QuestionReference filterReference;
    private String filterSubjectOfInterest;

    public FilterQuestion() {
        super(OPERATOR);
    }

    public Question getQuestion() {
        return this.question;
    }

    public StringOrQuestionPair getFilterPair() {
        return this.filterPair;
    }

    public QuestionReference getFilterReference() {
        return this.filterReference;
    }

    public String getFilterSubjectOfInterest() {
        return this.filterSubjectOfInterest;
    }

    public void setQuestion(Question question) {
        this.question = question;
    }

    public void setFilterPair(StringOrQuestionPair filterPair) {
        this.filterPair = filterPair;
    }

    public void setFilterReference(QuestionReference filterReference) {
        this.filterReference = filterReference;
    }

    public void setFilterSubjectOfInterest(String filterSubjectOfInterest) {
        this.filterSubjectOfInterest = filterSubjectOfInterest;
    }

    @Override
    public String toString(int level) {
        StringBuilder sb = new StringBuilder(this.getIndent(level) + (this.withBrackets ? "{ " : "") + "FILTER [\n");
        sb.append(this.question.toString(level + 1));
        if (this.filterPair != null) {
            sb.append(" | " + this.filterPair);
        }
        if (this.filterReference != null) {
            sb.append(" | " + this.filterReference);
        }
        if (this.filterSubjectOfInterest != null) {
            sb.append(" | " + this.filterSubjectOfInterest);
        }
        sb.append("\n" + this.getIndent(level) + "] " + this.endingSymbol + (this.withBrackets ? " }" : ""));
        return sb.toString();
    }

    @Override
    public Collection<Question> getChildren(boolean recursively) {
        return this.getChildren(recursively, false);
    }

    public Collection<Question> getChildren(boolean recursively, boolean noFilterChilds) {
        HashSet<Question> children = new HashSet<Question>();
        if (this.question != null) {
            children.add(this.question);
            if (recursively) {
                children.addAll(this.question.getChildren(true));
            }
        }
        if (!noFilterChilds) {
            if (this.filterPair != null) {
                if (this.filterPair.getKey() instanceof Question) {
                    children.add((Question)this.filterPair.getKey());
                    if (recursively) {
                        children.addAll(((Question)this.filterPair.getKey()).getChildren(true));
                    }
                }
                if (this.filterPair.getValue() instanceof Question) {
                    children.add((Question)this.filterPair.getValue());
                    if (recursively) {
                        children.addAll(((Question)this.filterPair.getValue()).getChildren(true));
                    }
                }
            }
            if (this.filterReference != null) {
                children.addAll(this.filterReference.getChildren(recursively));
            }
        }
        return children;
    }

    @Override
    public boolean replaceChild(Question childToReplace, IStringOrQuestion replacement) {
        boolean replaced = false;
        if (replacement instanceof Question) {
            if (this.question == childToReplace) {
                this.question = (Question)replacement;
                replaced = true;
            }
            if (this.filterPair != null) {
                if (this.filterPair.getKey() == childToReplace) {
                    this.filterPair.setKey(replacement);
                    replaced = true;
                }
                if (this.filterPair.getValue() == childToReplace) {
                    this.filterPair.setValue(replacement);
                    replaced = true;
                }
            }
        }
        return replaced;
    }

    @Override
    public Collection<QuestionReference> getAllReferences(boolean recursively) {
        HashSet<QuestionReference> references = new HashSet<QuestionReference>();
        if (this.filterReference != null) {
            references.add(this.filterReference);
        }
        if (recursively) {
            for (Question child : this.getChildren(true)) {
                references.addAll(child.getAllReferences(true));
            }
        }
        return references;
    }

    @Override
    public boolean isComplete(boolean takeUnansweredIntoAccount) {
        if (!(!takeUnansweredIntoAccount || this.filterPair == null || this.filterPair.getKey().isComplete(takeUnansweredIntoAccount) && this.filterPair.getValue().isComplete(takeUnansweredIntoAccount))) {
            return false;
        }
        if (takeUnansweredIntoAccount && this.filterReference != null && !this.filterReference.isComplete(takeUnansweredIntoAccount)) {
            return false;
        }
        return super.isComplete(takeUnansweredIntoAccount);
    }
}

