/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure.query;

import de.foellix.aql.datastructure.query.IStringOrQuestion;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.datastructure.query.QuestionReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class OperatorQuestion
extends Question {
    private static final long serialVersionUID = 2138086911624865494L;
    private String operator;
    private List<Question> questions;

    public OperatorQuestion(String operator) {
        this.operator = operator;
        this.questions = new ArrayList<Question>();
    }

    public String getOperator() {
        return this.operator;
    }

    public List<Question> getQuestions() {
        return this.questions;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setQuestions(List<Question> questions) {
        this.questions = questions;
    }

    @Override
    public String toString(int level) {
        StringBuilder sb = new StringBuilder(this.getIndent(level) + (this.withBrackets ? "{ " : "") + this.operator + " [\n");
        if (this.questions != null && !this.questions.isEmpty()) {
            Iterator<Question> i = this.questions.iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString(level + 1));
                if (!i.hasNext()) continue;
                sb.append(",\n");
            }
        }
        sb.append("\n" + this.getIndent(level) + "] " + this.endingSymbol + (this.withBrackets ? " }" : ""));
        return sb.toString();
    }

    @Override
    public Collection<Question> getChildren(boolean recursively) {
        LinkedHashSet<Question> children = new LinkedHashSet<Question>();
        for (Question question : this.questions) {
            children.add(question);
            if (!recursively) continue;
            children.addAll(question.getChildren(true));
        }
        return children;
    }

    @Override
    public boolean replaceChild(Question childToReplace, IStringOrQuestion replacement) {
        if (replacement instanceof Question && this.questions.remove(childToReplace)) {
            this.questions.add((Question)replacement);
            return true;
        }
        return false;
    }

    @Override
    public Collection<QuestionReference> getAllReferences(boolean recursively) {
        LinkedHashSet<QuestionReference> references = new LinkedHashSet<QuestionReference>();
        for (Question child : this.getChildren(recursively)) {
            references.addAll(child.getAllReferences(recursively));
        }
        return references;
    }

    @Override
    public boolean isComplete(boolean takeUnansweredIntoAccount) {
        return super.isComplete(takeUnansweredIntoAccount);
    }
}

