/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure.query;

import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.query.DefaultQuestion;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.datastructure.query.QuestionReference;
import de.foellix.aql.datastructure.query.QuestionString;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Query {
    private List<Question> questions = new ArrayList<Question>();
    private Stack<Question> questionStack = new Stack();
    private Map<String, Question> variableMap = new HashMap<String, Question>();

    public List<Question> getQuestions() {
        return this.questions;
    }

    public Stack<Question> getQuestionStack() {
        return this.questionStack;
    }

    public Collection<Question> getAllQuestions() {
        HashSet<Question> questions = new HashSet<Question>();
        for (Question question : this.questions) {
            questions.addAll(question.getChildren(true));
        }
        questions.addAll(this.questions);
        return questions;
    }

    public Collection<QuestionReference> getAllReferences() {
        HashSet<QuestionReference> references = new HashSet<QuestionReference>();
        for (Question question : this.questions) {
            references.addAll(question.getAllReferences());
        }
        return references;
    }

    public Collection<App> getAllApps() {
        HashSet<App> apps = new HashSet<App>();
        for (Question question : this.questions) {
            apps.addAll(question.getAllApps());
        }
        return apps;
    }

    public void setQuestions(List<Question> questions) {
        this.questions = questions;
    }

    public void setQuestionStack(Stack<Question> questionStack) {
        this.questionStack = questionStack;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Question> i = this.questions.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public Map<String, Question> getVariableMap() {
        return this.variableMap;
    }

    public void destroy() {
        this.questionStack = null;
        this.variableMap = null;
    }

    public void replaceAvailableRAW() {
        Collection<Question> questions = this.getAllQuestions();
        for (Question question : questions) {
            Question parent;
            if (!(question instanceof DefaultQuestion) || question.getEndingSymbol() != '.' || !question.isComplete(true)) continue;
            ArrayList<Task> rememberParentTasks = new ArrayList<Task>();
            for (parent = question; parent != null; parent = parent.getParent()) {
                rememberParentTasks.add(Storage.getInstance().getData().getTaskFromQuestionTaskMap(parent));
            }
            QuestionString raw = new QuestionString(Storage.getInstance().getData().getTaskFromQuestionTaskMap(question).getTaskAnswer().getRawContent());
            if (question.getParent() != null) {
                question.getParent().replaceChild(question, raw);
            }
            for (parent = question; parent != null; parent = parent.getParent()) {
                Storage.getInstance().getData().putIntoQuestionTaskMap(parent, (Task)rememberParentTasks.get(0));
                rememberParentTasks.remove(0);
            }
        }
    }
}

