/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure.query;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.query.IStringOrQuestion;
import de.foellix.aql.datastructure.query.QuestionReference;
import de.foellix.aql.helper.HashHelper;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.TaskAnswer;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class Question
implements IStringOrQuestion,
Serializable {
    public static final int QUESTION_TYPE_UNKNOWN = -1;
    public static final int QUESTION_TYPE_FLOWS = 0;
    public static final int QUESTION_TYPE_PERMISSIONS = 1;
    public static final int QUESTION_TYPE_INTENTS = 2;
    public static final int QUESTION_TYPE_INTENTFILTER = 3;
    public static final int QUESTION_TYPE_INTENTSOURCES = 4;
    public static final int QUESTION_TYPE_INTENTSINKS = 5;
    public static final int QUESTION_TYPE_SLICE = 6;
    public static final int QUESTION_TYPE_SOURCES = 7;
    public static final int QUESTION_TYPE_SINKS = 8;
    public static final int QUESTION_TYPE_ARGUMENTS = 9;
    public static final char ENDING_SYMBOL_AQL = '?';
    public static final char ENDING_SYMBOL_FILE = '!';
    public static final char ENDING_SYMBOL_RAW = '.';
    private static final long serialVersionUID = -5772254649214549993L;
    protected static final Set<Question> CHILDREN_EMPTY = new LinkedHashSet<Question>();
    protected static final Set<QuestionReference> REFERENCES_EMPTY = new LinkedHashSet<QuestionReference>();
    private Question parent = null;
    protected char endingSymbol = (char)42;
    protected boolean withBrackets = false;

    public void copy(Question copy) {
        copy.setParent(this.getParent());
        copy.setEndingSymbol(this.getEndingSymbol());
        copy.setWithBrackets(this.isWithBrackets());
    }

    @Override
    public boolean isComplete(boolean takeUnansweredIntoAccount) {
        if (takeUnansweredIntoAccount && (Storage.getInstance().getData().getTaskFromQuestionTaskMap(this) == null || !Storage.getInstance().getData().getTaskFromQuestionTaskMap(this).getTaskAnswer().isAnswered())) {
            return false;
        }
        if (this.getChildren(false).isEmpty()) {
            return true;
        }
        for (Question child : this.getChildren(false)) {
            if (child.isComplete(takeUnansweredIntoAccount)) continue;
            return false;
        }
        return true;
    }

    public char getEndingSymbol() {
        return this.endingSymbol;
    }

    public boolean isWithBrackets() {
        return this.withBrackets;
    }

    public void setEndingSymbol(char endingSymbol) {
        this.endingSymbol = endingSymbol;
    }

    public void setWithBrackets(boolean withBrackets) {
        this.withBrackets = withBrackets;
    }

    public Question getParent() {
        return this.parent;
    }

    public void setParent(Question parent) {
        this.parent = parent;
    }

    protected String getIndent(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("\t");
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toStringInAnswer() {
        if (this.isComplete(true)) {
            TaskAnswer ta = Storage.getInstance().getData().getTaskFromQuestionTaskMap(this).getTaskAnswer();
            if (ta.getType() == 2) {
                return (String)ta.getAnswer();
            }
            if (ta.getType() == 1) {
                return ((File)ta.getAnswer()).getAbsolutePath();
            }
            Log.error("Cannot use answer as String considering following question:\n" + this.toString());
        } else {
            Log.msg("Answer not available, yet. Considering question:\n" + this.toString(), 6);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    public Collection<Question> getLeafs() {
        LinkedHashSet<Question> leafs = new LinkedHashSet<Question>();
        for (Question child : this.getChildren(true)) {
            if (!child.getChildren(false).isEmpty()) continue;
            leafs.add(child);
        }
        return leafs;
    }

    public abstract String toString(int var1);

    public Collection<Question> getChildren() {
        return this.getChildren(false);
    }

    public abstract Collection<Question> getChildren(boolean var1);

    public abstract boolean replaceChild(Question var1, IStringOrQuestion var2);

    public Collection<QuestionReference> getAllReferences() {
        return this.getAllReferences(false);
    }

    public abstract Collection<QuestionReference> getAllReferences(boolean var1);

    public Collection<App> getAllApps() {
        return this.getAllApps(false);
    }

    public Collection<App> getAllApps(boolean recursively) {
        return this.getAllApps(recursively, true);
    }

    public Collection<App> getAllApps(boolean recursively, boolean mergeByHash) {
        LinkedHashSet<App> temp = new LinkedHashSet<App>();
        HashSet<String> checkSet = new HashSet<String>();
        for (QuestionReference qRef : this.getAllReferences(recursively)) {
            Reference ref = qRef.toReference();
            if (ref == null || ref.getApp() == null) continue;
            String hash = HashHelper.getHash(ref.getApp().getHashes(), "SHA-256");
            if (mergeByHash && checkSet.contains(hash)) continue;
            temp.add(ref.getApp());
            checkSet.add(hash);
        }
        return temp;
    }
}

