/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure.query;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.query.IStringOrQuestion;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.storage.Storage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QuestionReference
implements IStringOrQuestion,
Serializable {
    private static final long serialVersionUID = 4404315370639941792L;
    private IStringOrQuestion statement;
    private IStringOrQuestion method;
    private IStringOrQuestion classname;
    private IStringOrQuestion app;
    private int lineNumber = -1;
    private Reference reference;
    private List<IStringOrQuestion> preprocessorKeywords = new ArrayList<IStringOrQuestion>();
    private List<String> executedPreprocessorKeywords = new ArrayList<String>();

    public QuestionReference copy() {
        QuestionReference copiedReference = new QuestionReference();
        copiedReference.setStatement(this.getStatement());
        copiedReference.setMethod(this.getMethod());
        copiedReference.setClassname(this.getClassname());
        return copiedReference;
    }

    public Collection<Question> getChildren(boolean recursively) {
        ArrayList<Question> children = new ArrayList<Question>();
        if (this.statement instanceof Question) {
            children.add((Question)this.statement);
            if (recursively) {
                children.addAll(((Question)this.statement).getChildren(true));
            }
        }
        if (this.method instanceof Question) {
            children.add((Question)this.method);
            if (recursively) {
                children.addAll(((Question)this.method).getChildren(true));
            }
        }
        if (this.classname instanceof Question) {
            children.add((Question)this.classname);
            if (recursively) {
                children.addAll(((Question)this.classname).getChildren(true));
            }
        }
        if (this.app instanceof Question) {
            children.add((Question)this.app);
            if (recursively) {
                children.addAll(((Question)this.app).getChildren(true));
            }
        }
        if (this.preprocessorKeywords != null && !this.preprocessorKeywords.isEmpty()) {
            for (IStringOrQuestion preprocessor : this.preprocessorKeywords) {
                if (!(preprocessor instanceof Question)) continue;
                Question preprocessorQuestion = (Question)preprocessor;
                children.add(preprocessorQuestion);
                if (!recursively) continue;
                children.addAll(preprocessorQuestion.getChildren(true));
            }
        }
        return children;
    }

    @Override
    public boolean isComplete(boolean takeUnansweredIntoAccount) {
        if (!this.preprocessorKeywords.isEmpty()) {
            for (IStringOrQuestion keyword : this.preprocessorKeywords) {
                if (keyword.isComplete(takeUnansweredIntoAccount) && this.executedPreprocessorKeywords.contains(keyword.toStringInAnswer(false))) continue;
                return false;
            }
        }
        if (this.statement instanceof Question && (Storage.getInstance().getData().getTaskFromQuestionTaskMap((Question)this.statement) == null || !Storage.getInstance().getData().getTaskFromQuestionTaskMap((Question)this.statement).getTaskAnswer().isAnswered())) {
            return false;
        }
        if (this.method instanceof Question && (Storage.getInstance().getData().getTaskFromQuestionTaskMap((Question)this.method) == null || !Storage.getInstance().getData().getTaskFromQuestionTaskMap((Question)this.method).getTaskAnswer().isAnswered())) {
            return false;
        }
        if (this.classname instanceof Question && (Storage.getInstance().getData().getTaskFromQuestionTaskMap((Question)this.classname) == null || !Storage.getInstance().getData().getTaskFromQuestionTaskMap((Question)this.classname).getTaskAnswer().isAnswered())) {
            return false;
        }
        if (this.app instanceof Question && (Storage.getInstance().getData().getTaskFromQuestionTaskMap((Question)this.app) == null || !Storage.getInstance().getData().getTaskFromQuestionTaskMap((Question)this.app).getTaskAnswer().isAnswered())) {
            return false;
        }
        if (this.getChildren(false).isEmpty()) {
            return true;
        }
        for (Question child : this.getChildren(false)) {
            if (child.isComplete(takeUnansweredIntoAccount)) continue;
            return false;
        }
        return true;
    }

    public Reference toReference() {
        if (!this.isComplete(true)) {
            return null;
        }
        if (this.reference == null) {
            this.reference = new Reference();
            if (this.statement != null) {
                this.reference.setStatement(Helper.createStatement(this.statement.toStringInAnswer(false)));
                if (this.lineNumber > 0) {
                    this.reference.getStatement().setLinenumber(this.lineNumber);
                }
            }
            if (this.method != null) {
                this.reference.setMethod(this.method.toStringInAnswer(false));
            }
            if (this.classname != null) {
                this.reference.setClassname(this.classname.toStringInAnswer(false));
            }
            if (this.app != null) {
                Object app = new String(this.app.toStringInAnswer(false));
                if (((String)app).equals("''") || ((String)app).equals("'/'") || ((String)app).equals("''") || ((String)app).equals("'*'")) {
                    app = "'.'";
                } else if (((String)app).endsWith("*'")) {
                    app = ((String)app).substring(0, ((String)app).length() - 2) + "'";
                }
                this.reference.setApp(Helper.createApp((String)app));
            }
        }
        return this.reference;
    }

    @Override
    public String toStringInAnswer() {
        if (this.isComplete(true)) {
            return this.toString();
        }
        Log.msg("Answer not available, yet. Considering question:\n" + this.toString(), 6);
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.statement != null) {
            sb.append("Statement(" + this.statement + (String)(this.lineNumber > 0 ? "," + this.lineNumber : "") + ")->");
        }
        if (this.method != null) {
            sb.append("Method(" + this.method + ")->");
        }
        if (this.classname != null) {
            sb.append("Class(" + this.classname + ")->");
        }
        sb.append("App(" + this.app);
        if (this.preprocessorKeywords != null && !this.preprocessorKeywords.isEmpty()) {
            for (IStringOrQuestion preprocessorKeyword : this.preprocessorKeywords) {
                sb.append(" | " + preprocessorKeyword);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public IStringOrQuestion getStatement() {
        return this.statement;
    }

    public IStringOrQuestion getMethod() {
        return this.method;
    }

    public IStringOrQuestion getClassname() {
        return this.classname;
    }

    public IStringOrQuestion getApp() {
        return this.app;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public List<IStringOrQuestion> getPreprocessorKeywords() {
        return this.preprocessorKeywords;
    }

    public List<String> getExecutedPreprocessorKeywords() {
        return this.executedPreprocessorKeywords;
    }

    public void setStatement(IStringOrQuestion statement) {
        this.statement = statement;
    }

    public void setMethod(IStringOrQuestion method) {
        this.method = method;
    }

    public void setClassname(IStringOrQuestion classname) {
        this.classname = classname;
    }

    public void setApp(IStringOrQuestion app) {
        this.app = app;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }
}

