/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.Log;
import de.foellix.aql.helper.Helper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AsteriskMap
extends HashMap<String, Set<String>> {
    private static final long serialVersionUID = -3795387749726764473L;

    @Override
    public Set<String> get(Object statement) {
        Set value = (Set)super.get(statement);
        if (value != null) {
            return value;
        }
        if (statement instanceof String) {
            String statementStr = "<" + Helper.cutFromFirstToLast((String)statement, "<", ">") + ">";
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String originalPattern = key = (String)iterator.next();
                String pattern = originalPattern.replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)");
                pattern = pattern.replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]");
                if (!statementStr.matches(pattern = pattern.replace("?", ".?").replace("*", ".*"))) continue;
                return (Set)super.get(originalPattern);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void load(File file) {
        try {
            HashSet<String> all = new HashSet<String>();
            List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
            for (String string : lines) {
                void var5_6;
                if (string.startsWith("%") || !string.contains(" -> ")) continue;
                if (!string.contains("> -> ")) {
                    String string4 = string.replace(" -> ", " -### ");
                    string4 = string4.substring(0, string4.lastIndexOf(62) + 1) + string4.substring(string4.lastIndexOf(" -### "));
                    string4 = string4.replace(" -### ", " -> ");
                }
                String[] parts = var5_6.split(" -> ");
                String stm = parts[0];
                String features = parts[1];
                for (String feature : features.replace(" ", "").split(",")) {
                    all.add(feature);
                    if (this.get(stm) == null) {
                        this.put(stm, new HashSet());
                    }
                    this.get(stm).add(feature);
                }
            }
            Log.msg("Loaded " + this.keySet().size() + " statements for " + all.size() + " distinct categories from \"" + file.getAbsolutePath() + "\".", 6);
        }
        catch (IOException e) {
            Log.warning("Could not load features file: " + file.getAbsolutePath() + Log.getExceptionAppendix(e));
        }
    }
}

