/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.Log;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.helper.HashHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.transformations.RulesHandler;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javafx.stage.Stage;

public class CLIHelper {
    private static final String TIMEOUT_MODESTRING_MAX = "max";
    private static final String TIMEOUT_MODESTRING_MIN = "min";
    private static final String TIMEOUT_MODESTRING_OVERRIDE = "override";
    private static final String QUOTE_NEEDLE = "#QUOTE#";
    public static boolean initialConfigAvailable = false;
    public static String lastConfigFileHashLoaded = null;
    private static Stage stage = null;

    public static int evaluateLogLevel(String debug) {
        return CLIHelper.evaluateLogLevel(debug, true);
    }

    public static int evaluateLogLevel(String debug, boolean setImmediately) {
        int value = 4;
        if (debug != null) {
            if (debug.equalsIgnoreCase("none")) {
                value = -1;
            } else if (debug.equalsIgnoreCase("important")) {
                value = 0;
            } else if (debug.equalsIgnoreCase("error")) {
                value = 1;
            } else if (debug.equalsIgnoreCase("special")) {
                value = 2;
            } else if (debug.equalsIgnoreCase("warning")) {
                value = 3;
            } else if (debug.equalsIgnoreCase("normal")) {
                value = 4;
            } else if (debug.equalsIgnoreCase("short")) {
                Log.setShorten(true);
                value = 4;
            } else if (debug.equalsIgnoreCase("debug")) {
                value = 5;
            } else if (debug.equalsIgnoreCase("detailed")) {
                value = 6;
            } else if (debug.equalsIgnoreCase("verbose")) {
                value = 7;
            } else if (debug.equalsIgnoreCase("all")) {
                value = 7;
            } else {
                try {
                    value = Integer.parseInt(debug);
                }
                catch (NumberFormatException e) {
                    Log.warning("Unknown logging level: " + debug);
                }
            }
        }
        if (setImmediately) {
            Log.setLogLevel(value);
        }
        return value;
    }

    public static boolean evaluateConfig(String config) {
        if (config != null && !config.isEmpty()) {
            URL url = null;
            String username = null;
            boolean isWebConfig = false;
            File configFile = FileHelper.getTempFile(".xml");
            if (config.toLowerCase().startsWith("http") && !config.contains(",")) {
                if (FileHelper.downloadFile(config, configFile, config.substring(config.lastIndexOf(47) + 1))) {
                    isWebConfig = true;
                } else {
                    configFile = null;
                }
            } else if (config.toLowerCase().startsWith("http") && config.contains(",")) {
                String password;
                String[] parts = config.replace(", ", ",").split(",");
                String urlStr = parts[0];
                url = Helper.getURL(urlStr);
                username = parts.length > 1 ? parts[1] : "free";
                if (FileHelper.getConfigFromWebService(urlStr, username, password = parts.length > 2 ? parts[2] : "", configFile) && configFile.exists()) {
                    isWebConfig = true;
                } else {
                    config = urlStr;
                    configFile = null;
                }
            } else {
                configFile = null;
            }
            if (configFile == null) {
                configFile = new File(config);
            }
            if (configFile.exists()) {
                String hash = HashHelper.hash(configFile, "MD5");
                if (lastConfigFileHashLoaded == null || !lastConfigFileHashLoaded.equals(hash)) {
                    initialConfigAvailable = true;
                    lastConfigFileHashLoaded = hash;
                    Log.msg("Continuing with configuration: " + configFile.getAbsolutePath() + (String)(Log.logIt(6) ? " (" + hash + ")" : ""), 5);
                    if (url != null) {
                        String feedback = Helper.getFeedbackFromFile(configFile);
                        if (feedback == null) {
                            ConfigHandler.getInstance().setConfig(configFile, isWebConfig, url, username);
                        } else {
                            Log.warning("Configuration is invalid:\n" + feedback);
                        }
                    } else {
                        ConfigHandler.getInstance().setConfig(configFile, isWebConfig);
                    }
                }
                return true;
            }
            if (config.toLowerCase().startsWith("http")) {
                Log.warning("Configuration not available: " + config);
            } else {
                Log.warning("Configuration file does not exist: " + configFile.getAbsolutePath());
            }
        } else {
            Log.warning("No configuration file provided.");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean evaluateRules(String rules) {
        int n;
        String[] stringArray;
        ArrayList<File> rulesFiles;
        if (rules != null && !rules.isEmpty()) {
            while (rules.contains(", ")) {
                rules = rules.replace(", ", ",");
            }
            rulesFiles = new ArrayList<File>();
            stringArray = rules.split(",");
            n = stringArray.length;
        } else {
            Log.warning("No rules file provided.");
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String rulesSplitted = stringArray[i];
            File rulesFile = new File(rulesSplitted);
            if (rulesFile.exists()) {
                rulesFiles.add(rulesFile);
                continue;
            }
            Log.warning("Rules file does not exist: " + rulesFile.getAbsolutePath());
        }
        if (rulesFiles.isEmpty()) {
            Log.warning("None of the given rules-files exist!");
            return false;
        }
        RulesHandler.getInstance().setRulesFiles(rulesFiles);
        return true;
    }

    public static long evaluateTimeout(String readTimeout) {
        if (readTimeout.contains("h")) {
            return Long.parseLong(readTimeout.replace("h", "")) * 3600L;
        }
        if (readTimeout.contains("m")) {
            return Long.parseLong(readTimeout.replace("m", "")) * 60L;
        }
        return Long.parseLong(readTimeout.replace("s", ""));
    }

    public static int evaluateTimeoutMode(String readTimeoutMode) {
        if (readTimeoutMode.equalsIgnoreCase(TIMEOUT_MODESTRING_MAX)) {
            return 1;
        }
        if (readTimeoutMode.equalsIgnoreCase(TIMEOUT_MODESTRING_MIN)) {
            return 2;
        }
        if (readTimeoutMode.equalsIgnoreCase(TIMEOUT_MODESTRING_OVERRIDE)) {
            return 3;
        }
        return -1;
    }

    public static void checkResources() {
        File data = new File("data");
        if (!data.exists()) {
            Log.error("The AQL-System's \"data\" directory could not be found. Please execute from correct location!");
            System.exit(1);
        }
    }

    public static Stage getStage() {
        return stage;
    }

    public static void setStage(Stage stage) {
        CLIHelper.stage = stage;
    }

    public static String replaceQuotesWithNeedles(String arg) {
        return arg.replace("\"", QUOTE_NEEDLE);
    }

    public static String replaceNeedlesWithQuotes(String arg) {
        return arg.replace(QUOTE_NEEDLE, "\"");
    }

    public static String[] replaceNeedlesWithQuotes(String[] args) {
        String[] newArgs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            newArgs[i] = CLIHelper.replaceNeedlesWithQuotes(args[i]);
        }
        return newArgs;
    }

    public static String removeQuotesFromFileString(String fileString) {
        if (fileString != null && !fileString.isBlank() && fileString.startsWith("\"") && fileString.endsWith("\"")) {
            fileString = fileString.substring(1, fileString.length() - 1);
        }
        return fileString;
    }

    public static String escapeChars(String str) {
        return str.replace("$", "\\$");
    }
}

