/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.EqualsOptions;
import java.util.ArrayList;

public class ConnectHelper {
    public static void computeTransitiveHull(Flows flows, EqualsOptions equalsOptions) {
        boolean fixpoint = false;
        while (!fixpoint) {
            fixpoint = true;
            ArrayList<Flow> addPaths = new ArrayList<Flow>();
            for (Flow path1 : flows.getFlow()) {
                for (Flow path2 : flows.getFlow()) {
                    if (path1 == path2) continue;
                    Reference path1From = null;
                    Reference path1To = null;
                    Reference path2From = null;
                    Reference path2To = null;
                    for (Reference refPath1 : path1.getReference()) {
                        if (refPath1.getType().equals("from")) {
                            path1From = refPath1;
                            continue;
                        }
                        if (!refPath1.getType().equals("to")) continue;
                        path1To = refPath1;
                    }
                    for (Reference refPath2 : path2.getReference()) {
                        if (refPath2.getType().equals("from")) {
                            path2From = refPath2;
                            continue;
                        }
                        if (!refPath2.getType().equals("to")) continue;
                        path2To = refPath2;
                    }
                    if (path1From == null || path1To == null || path2From == null || path2To == null || !EqualsHelper.equals(path1To, path2From, equalsOptions)) continue;
                    boolean exists = false;
                    for (Flow checkPath : flows.getFlow()) {
                        Reference checkFrom = null;
                        Reference checkTo = null;
                        for (Reference checkRef : checkPath.getReference()) {
                            if (checkRef.getType().equals("from")) {
                                checkFrom = checkRef;
                                continue;
                            }
                            if (!checkRef.getType().equals("to")) continue;
                            checkTo = checkRef;
                        }
                        if (checkFrom != null && checkTo != null) {
                            if (!EqualsHelper.equals(path1From, checkFrom, equalsOptions) || !EqualsHelper.equals(path2To, checkTo, equalsOptions)) continue;
                            exists = true;
                            continue;
                        }
                        exists = true;
                    }
                    if (exists) continue;
                    fixpoint = false;
                    addPaths.add(ConnectHelper.connect(path1From, path2To));
                }
            }
            flows.getFlow().addAll(addPaths);
        }
    }

    public static Flow connect(Reference from, Reference to) {
        Flow newPath = new Flow();
        Reference newFrom = new Reference();
        newFrom.setType("from");
        newFrom.setApp(from.getApp());
        newFrom.setClassname(from.getClassname());
        newFrom.setMethod(from.getMethod());
        newFrom.setStatement(from.getStatement());
        Reference newTo = new Reference();
        newTo.setType("to");
        newTo.setApp(to.getApp());
        newTo.setClassname(to.getClassname());
        newTo.setMethod(to.getMethod());
        newTo.setStatement(to.getStatement());
        newPath.getReference().add(newFrom);
        newPath.getReference().add(newTo);
        return newPath;
    }

    public static Flow connect(Intentsink from, Intentsource to) {
        Flow newPath = new Flow();
        Reference newFrom = new Reference();
        newFrom.setType("from");
        newFrom.setApp(from.getReference().getApp());
        newFrom.setClassname(from.getReference().getClassname());
        newFrom.setMethod(from.getReference().getMethod());
        newFrom.setStatement(from.getReference().getStatement());
        Reference newTo = new Reference();
        newTo.setType("to");
        newTo.setApp(to.getReference().getApp());
        newTo.setClassname(to.getReference().getClassname());
        newTo.setMethod(to.getReference().getMethod());
        newTo.setStatement(to.getReference().getStatement());
        newPath.getReference().add(newFrom);
        newPath.getReference().add(newTo);
        return newPath;
    }
}

