/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.Log;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.task.Task;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;

public class FileHelper {
    public static final String FILE_ENDING_TXT = ".txt";
    public static final String FILE_ENDING_XML = ".xml";
    public static final String FILE_ENDING_AQL = ".xml";
    public static final String FILE_ENDING_APK = ".apk";
    private static final String FILE_ENDING_NULL = "###null###";
    private static final String CLASSES_DEX_FILENAME = "classes.dex";
    private static final String ANDROID_MANIFEST_FILENAME = "AndroidManifest.xml";
    private static final int TEMP_FILE_ID_LENGTH = 5;
    private static final int UNIQUE_FILE_ID_LENGTH = 3;
    private static Map<String, Integer> tempFileID = new HashMap<String, Integer>();
    private static Lock lock = new ReentrantLock();
    private static File tempDirectory = new File("data", "temp");
    private static File converterDirectory = new File("data", "converter");
    private static File answersDirectory = new File("answers");
    private static final File queriesDirectory = new File("queries");

    public static void initializeFileSystem() {
        FileHelper.setTempDirectory(tempDirectory);
        FileHelper.setConverterDirectory(converterDirectory);
        FileHelper.setAnswersDirectory(answersDirectory);
    }

    public static File getTempDirectory() {
        return tempDirectory;
    }

    public static File getConverterDirectory() {
        return converterDirectory;
    }

    public static File getAnswersDirectory() {
        return answersDirectory;
    }

    public static void setTempDirectory(File tempDirectory) {
        FileHelper.tempDirectory = tempDirectory;
        if (!tempDirectory.exists()) {
            tempDirectory.mkdirs();
        }
    }

    public static void setConverterDirectory(File converterDirectory) {
        FileHelper.converterDirectory = converterDirectory;
        if (!converterDirectory.exists()) {
            converterDirectory.mkdirs();
        }
    }

    public static void setAnswersDirectory(File answersDirectory) {
        FileHelper.answersDirectory = answersDirectory;
        if (!answersDirectory.exists()) {
            answersDirectory.mkdirs();
        }
        if (!queriesDirectory.exists()) {
            queriesDirectory.mkdirs();
        }
    }

    public static boolean deleteDir(File directory) {
        if (!directory.exists()) {
            return true;
        }
        if (directory.isDirectory()) {
            for (File temp : directory.listFiles()) {
                if (FileHelper.deleteDir(temp)) continue;
                Log.warning("Failed to delete \"" + temp.getAbsolutePath() + "\"!");
            }
        }
        return directory.delete();
    }

    public static File getTempFile() {
        return FileHelper.getTempFile(null);
    }

    public static File getTempFile(String fileEnding) {
        File uniqueFile;
        FileHelper.setTempDirectory(tempDirectory);
        if (fileEnding == null) {
            fileEnding = FILE_ENDING_NULL;
        }
        lock.lock();
        int id = tempFileID.containsKey(fileEnding) ? tempFileID.get(fileEnding) + 1 : 0;
        while ((uniqueFile = new File(tempDirectory, "temp_" + Helper.addZeroDigits(++id, 5) + (fileEnding != FILE_ENDING_NULL ? fileEnding : ""))).exists()) {
        }
        tempFileID.put(fileEnding, id);
        lock.unlock();
        return uniqueFile;
    }

    public static File makeUnique(File file) {
        String extension = "";
        if (file.getName().contains(".")) {
            extension = file.getName().substring(file.getName().lastIndexOf("."));
        }
        String filename = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - (extension.length() + 1));
        int id = 0;
        while ((file = new File(filename + Helper.addZeroDigits(++id, 3) + extension)).exists()) {
        }
        return file;
    }

    public static File waitForResult(File resultWithAsteriskFile, Task task) {
        for (int i = 0; i <= 10; ++i) {
            File result = FileHelper.findFileWithAsterisk(resultWithAsteriskFile);
            if (result.exists()) {
                Log.msg("Result available: " + result.getAbsolutePath(), 6);
                return result;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Log.warning("Interrupted while waiting for result. Trying to continue.");
            }
        }
        return null;
    }

    public static File findFileWithAsterisk(File file) {
        if (!file.getAbsolutePath().contains("*")) {
            return file;
        }
        String[] needles = file.getName().split("\\*");
        file = new File(file.getAbsolutePath().replace("*", "_"));
        boolean didNotExist = false;
        if (!file.exists()) {
            didNotExist = true;
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Log.error("Analysis result could not be found or written: " + file.getAbsolutePath());
            }
        }
        if (file.getParentFile().listFiles() != null) {
            for (File candidate : file.getParentFile().listFiles()) {
                if (didNotExist && candidate.equals(file)) continue;
                boolean valid = true;
                for (String needle : needles) {
                    if (candidate.getName().contains(needle)) continue;
                    valid = false;
                }
                if (!valid) continue;
                if (didNotExist) {
                    file.delete();
                }
                return candidate;
            }
        }
        if (didNotExist) {
            file.delete();
        }
        return file;
    }

    public static List<File> findFilesWithAsteriskInParent(File directory) {
        ArrayList<File> filesFound = new ArrayList<File>();
        File parent = directory.getParentFile();
        if (parent == null) {
            parent = new File(".");
            parent = new File(parent.getAbsolutePath().substring(0, parent.getAbsolutePath().length() - 1));
        }
        String needle = directory.getName().replace("*", ".*");
        for (File file : parent.listFiles()) {
            if (!file.getName().matches(needle)) continue;
            filesFound.add(file);
        }
        if (filesFound.isEmpty()) {
            Log.warning("No files found when replacing asterisk in: " + directory.getAbsolutePath());
        }
        return filesFound;
    }

    public static List<File> searchRecursively(File resultFolder, String extension) {
        ArrayList<File> returnList = new ArrayList<File>();
        for (File file : resultFolder.listFiles()) {
            if (file.isDirectory()) {
                returnList.addAll(FileHelper.searchRecursively(file, extension));
                continue;
            }
            if (!file.getAbsolutePath().endsWith(extension)) continue;
            returnList.add(file);
        }
        return returnList;
    }

    public static String getRawContent(File answerFile) throws IOException {
        return Helper.replaceAllWhiteSpaceChars(new String(Files.readAllBytes(answerFile.toPath())));
    }

    public static String getApkFileName(File apkFile) {
        String name = apkFile.getName();
        String ending = "." + Helper.cut(name, ".", -1);
        if (ending.equalsIgnoreCase(FILE_ENDING_APK)) {
            return Helper.cutFromStart(name, ".", -1);
        }
        return name;
    }

    public static boolean downloadFile(String URL2, File destination) {
        return FileHelper.downloadFile(URL2, destination, null);
    }

    public static boolean downloadFile(String url, File destination, String filename) {
        if (filename == null) {
            filename = destination.getName();
        }
        try {
            Log.msg("Downloading " + filename + " from \"" + url + "\".", 4);
            InputStream is = new URL(url).openStream();
            Files.copy(is, destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            Log.msg("Downloaded " + filename + " saved as \"" + destination.getAbsolutePath() + "\".", 4);
            return true;
        }
        catch (IOException e) {
            Log.warning("Could not download " + filename + " from \"" + url + "\" to \"" + destination + "\"." + Log.getExceptionAppendix(e));
            return false;
        }
    }

    public static final boolean getConfigFromWebService(String url, String username, String password, File destination) {
        try {
            Log.msg("Getting config from: " + url, 4);
            Unirest.config().connectTimeout(10000).socketTimeout(30000);
            HttpRequestWithBody request = (HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)url).header("Accept", "text/xml")).queryString("username", (Object)username)).queryString("password", (Object)password);
            HttpResponse responseString = request.asString();
            try (FileWriter writer = new FileWriter(destination);){
                String body = (String)responseString.getBody();
                if (body.contains("<config />") || body.contains("<config/>")) {
                    Log.warning("Configuration accuired is empty! Please check \"" + destination.getAbsolutePath() + "\" for more information.");
                }
                writer.append(body);
            }
            Unirest.shutDown();
            return true;
        }
        catch (IOException | UnirestException e) {
            Log.warning("Could not download configuration from \"" + url + "\"." + Log.getExceptionAppendix(e));
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAPK(File file) {
        try (ZipInputStream zipStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));){
            boolean dexFound = false;
            boolean manifestFound = false;
            do {
                ZipEntry zipItem;
                if ((zipItem = zipStream.getNextEntry()) == null) return false;
                if (!dexFound && zipItem.getName().equalsIgnoreCase(CLASSES_DEX_FILENAME)) {
                    dexFound = true;
                    continue;
                }
                if (manifestFound || !zipItem.getName().equalsIgnoreCase(ANDROID_MANIFEST_FILENAME)) continue;
                manifestFound = true;
            } while (!dexFound || !manifestFound);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Log.warning("Could not check if \"" + file + "\" is a valid APK file." + Log.getExceptionAppendix(e));
        }
        return false;
    }

    public static BasicFileAttributes getFileProperties(File file) {
        if (file.exists()) {
            try {
                return Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException e) {
                Log.error("Could not get file properties: " + file.getAbsolutePath() + Log.getExceptionAppendix(e));
            }
        }
        return null;
    }
}

