/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.Log;
import java.io.File;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class FileRelocator {
    private final Stage stage;
    private final FileChooser loadFileDialog;
    private final DirectoryChooser loadFolderDialog;
    private final Alert alert;
    private final ButtonType buttonTypeFolderIgnoreParent;
    private final ButtonType buttonTypeFolder;
    private final ButtonType buttonTypeFile;
    private final ButtonType buttonTypeCancel;
    private boolean ignoreParent = false;
    private File relocateFolder = null;

    public FileRelocator(Stage stage) {
        this.stage = stage;
        this.loadFolderDialog = new DirectoryChooser();
        this.loadFileDialog = new FileChooser();
        FileChooser.ExtensionFilter allFilter = new FileChooser.ExtensionFilter("*.* All files", new String[]{"*.*"});
        FileChooser.ExtensionFilter apkFilter = new FileChooser.ExtensionFilter("*.apk Android Application Package", new String[]{"*.apk"});
        this.loadFileDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{allFilter, apkFilter});
        this.loadFileDialog.setSelectedExtensionFilter(apkFilter);
        this.alert = new Alert(Alert.AlertType.CONFIRMATION);
        Stage alertStage = (Stage)this.alert.getDialogPane().getScene().getWindow();
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_16.png").toURI().toString(), 16.0, 16.0, false, true));
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_32.png").toURI().toString(), 32.0, 32.0, false, true));
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_64.png").toURI().toString(), 64.0, 64.0, false, true));
        this.alert.setTitle("File not found");
        this.alert.setContentText("Relocate it now by selecting a parent directory or choosing the file precisely.");
        this.buttonTypeFolderIgnoreParent = new ButtonType("Directory (Ignore parent directory)");
        this.buttonTypeFolder = new ButtonType("Directory");
        this.buttonTypeFile = new ButtonType("File");
        this.buttonTypeCancel = new ButtonType("Cancel (Skip)", ButtonBar.ButtonData.CANCEL_CLOSE);
        this.alert.getButtonTypes().setAll((Object[])new ButtonType[]{this.buttonTypeFolderIgnoreParent, this.buttonTypeFolder, this.buttonTypeFile, this.buttonTypeCancel});
        this.relocateFolder = null;
    }

    public File relocateFile(File file) {
        File relocateFile = FileRelocator.recursivelySearchFile(file, this.relocateFolder, this.ignoreParent);
        if (this.relocateFolder != null) {
            this.loadFileDialog.setInitialDirectory(this.relocateFolder);
            this.loadFolderDialog.setInitialDirectory(this.relocateFolder);
        }
        boolean skip = false;
        while (!(skip || relocateFile != null && relocateFile.exists())) {
            this.alert.setHeaderText("The following file could not be found:\n" + file.getAbsolutePath());
            this.loadFileDialog.setTitle("Relocate: " + file.getAbsolutePath());
            this.loadFolderDialog.setTitle("Relocate: " + file.getAbsolutePath());
            Optional result = this.alert.showAndWait();
            if (result.get() == this.buttonTypeFile) {
                relocateFile = this.loadFileDialog.showOpenDialog((Window)this.stage);
                if (relocateFile == null || !relocateFile.exists() || !relocateFile.getParentFile().exists()) continue;
                this.relocateFolder = relocateFile.getParentFile();
                continue;
            }
            if (result.get() == this.buttonTypeFolder) {
                this.ignoreParent = false;
                this.relocateFolder = this.loadFolderDialog.showDialog((Window)this.stage);
                relocateFile = FileRelocator.recursivelySearchFile(file, this.relocateFolder, this.ignoreParent);
                continue;
            }
            if (result.get() == this.buttonTypeFolderIgnoreParent) {
                this.ignoreParent = true;
                this.relocateFolder = this.loadFolderDialog.showDialog((Window)this.stage);
                relocateFile = FileRelocator.recursivelySearchFile(file, this.relocateFolder, this.ignoreParent);
                continue;
            }
            if (result.get() != this.buttonTypeCancel) continue;
            skip = true;
        }
        if (skip) {
            Log.warning(file.getAbsolutePath() + " does not exist and was not relocated!");
            return null;
        }
        Log.msg(file.getAbsolutePath() + "\nrelocated at\n" + relocateFile.getAbsolutePath(), 4);
        return relocateFile;
    }

    public static File recursivelySearchFile(File file, File folder) {
        return FileRelocator.recursivelySearchFile(file, folder, false);
    }

    public static File recursivelySearchFile(File file, File folder, boolean ignoreParent) {
        if (folder == null) {
            return null;
        }
        for (File child : folder.listFiles()) {
            File recursiveFile;
            if (file.getName().equals(child.getName()) && (ignoreParent || file.getParentFile().getName().equals(child.getParentFile().getName()))) {
                return child;
            }
            if (!child.isDirectory() || (recursiveFile = FileRelocator.recursivelySearchFile(file, child, ignoreParent)) == null) continue;
            return recursiveFile;
        }
        return null;
    }
}

