/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.datastructure.Hash;
import de.foellix.aql.helper.HashHelper;
import java.io.File;

public class FileWithHash {
    private File file;
    private Hash hash;

    public FileWithHash(String file) {
        this(new File(file));
    }

    public FileWithHash(File file) {
        this(file, "SHA-256");
    }

    public FileWithHash(File file, String hashAlgorithm) {
        this.file = file;
        this.hash = new Hash();
        this.hash.setType(hashAlgorithm);
        if (file.exists()) {
            this.hash.setValue(HashHelper.hash(file, hashAlgorithm));
        } else {
            this.hash.setValue(HashHelper.hash(file.getAbsolutePath(), hashAlgorithm));
        }
    }

    public FileWithHash(File file, Hash hash) {
        this.file = file;
        this.hash = hash;
    }

    public File getFile() {
        return this.file;
    }

    public Hash getHash() {
        return this.hash;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setHash(Hash hash) {
        this.hash = hash;
    }

    public String toString() {
        return this.file.toString() + " (" + this.hash.getType() + ": " + this.hash.getValue() + ")";
    }
}

