/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.SearchAndReplaceBox;
import java.util.Map;
import java.util.Objects;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import org.fxmisc.richtext.CodeArea;

public class GUIHelper {
    private static final GUIHelper INSTANCE = new GUIHelper();

    public static void addFinder(CodeArea ta, SearchAndReplaceBox searchAndReplaceBox) {
        ta.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.isControlDown() && !e.isShiftDown() && !e.isAltDown() && e.getCode() == KeyCode.F) {
                searchAndReplaceBox.show();
            } else if (e.getCode() == KeyCode.F3) {
                searchAndReplaceBox.search();
            }
        });
    }

    public static void copyToClipboard(String string) {
        if (Platform.isFxApplicationThread()) {
            GUIHelper.copyToClipboardOnFXthread(string);
        } else {
            Platform.runLater(() -> GUIHelper.copyToClipboardOnFXthread(string));
        }
    }

    private static void copyToClipboardOnFXthread(String string) {
        ClipboardContent content = new ClipboardContent();
        content.putString(string);
        Clipboard.getSystemClipboard().setContent((Map)content);
        GUIHelper.notifyUser("Copied to clipboard!");
    }

    public static void notifyUser(String toastMsg) {
        GUIHelper.notifyUser(toastMsg, 1000, 500, 500);
    }

    public static void notifyUser(String msg, int delay, int fadeInDelay, int fadeOutDelay) {
        Stage toastStage = new Stage();
        toastStage.initOwner((Window)GUI.stage);
        toastStage.setResizable(false);
        toastStage.initStyle(StageStyle.TRANSPARENT);
        Text text = new Text(msg);
        text.setFill((Paint)Color.WHITE);
        StackPane root = new StackPane(new Node[]{text});
        root.setStyle("-fx-background-radius: 10; -fx-background-color: rgba(0, 0, 0, 0.75); -fx-padding: 10px;");
        root.setOpacity(0.0);
        Scene scene = new Scene((Parent)root);
        scene.setFill((Paint)Color.TRANSPARENT);
        toastStage.setScene(scene);
        toastStage.show();
        toastStage.setY(GUI.stage.getY() + GUI.stage.getHeight() - 100.0);
        Timeline fadeInTimeline = new Timeline();
        KeyFrame fadeInKey1 = new KeyFrame(Duration.millis((double)fadeInDelay), new KeyValue[]{new KeyValue((WritableValue)toastStage.getScene().getRoot().opacityProperty(), (Object)1)});
        fadeInTimeline.getKeyFrames().add((Object)fadeInKey1);
        fadeInTimeline.setOnFinished(ae -> new Thread(() -> {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Timeline fadeOutTimeline = new Timeline();
            KeyFrame fadeOutKey1 = new KeyFrame(Duration.millis((double)fadeOutDelay), new KeyValue[]{new KeyValue((WritableValue)toastStage.getScene().getRoot().opacityProperty(), (Object)0)});
            fadeOutTimeline.getKeyFrames().add((Object)fadeOutKey1);
            fadeOutTimeline.setOnFinished(aeb -> toastStage.close());
            fadeOutTimeline.play();
        }).start());
        fadeInTimeline.play();
        GUI.stage.requestFocus();
    }

    public static void makeResizableInHeight(Region region, int initialHeight) {
        GUIHelper gUIHelper = INSTANCE;
        Objects.requireNonNull(gUIHelper);
        final HeightDragResizer resizer = gUIHelper.new HeightDragResizer(region);
        region.setMinHeight((double)initialHeight);
        region.setPrefHeight((double)initialHeight);
        region.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                resizer.mousePressed(event);
            }
        });
        region.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                resizer.mouseDragged(event);
            }
        });
        region.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                resizer.mouseOver(event);
            }
        });
        region.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                resizer.mouseReleased(event);
            }
        });
    }

    private class HeightDragResizer {
        private static final int RESIZE_MARGIN = 5;
        private final Region region;
        private boolean dragging;

        private HeightDragResizer(Region region) {
            this.region = region;
        }

        protected void mouseReleased(MouseEvent event) {
            this.dragging = false;
            this.region.setCursor(Cursor.DEFAULT);
        }

        protected void mouseOver(MouseEvent event) {
            if (this.isInDraggableZone(event) || this.dragging) {
                this.region.setCursor(Cursor.S_RESIZE);
            } else {
                this.region.setCursor(Cursor.DEFAULT);
            }
        }

        protected boolean isInDraggableZone(MouseEvent event) {
            return event.getY() > 0.0 && event.getY() < 5.0;
        }

        protected void mouseDragged(MouseEvent event) {
            if (!this.dragging) {
                return;
            }
            double newHeight = this.region.getMinHeight() - event.getY();
            new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1.0), new KeyValue[]{new KeyValue((WritableValue)this.region.minHeightProperty(), (Object)newHeight, Interpolator.EASE_BOTH)})}).play();
        }

        protected void mousePressed(MouseEvent event) {
            if (!this.isInDraggableZone(event)) {
                return;
            }
            this.dragging = true;
        }
    }
}

