/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.Hash;
import de.foellix.aql.datastructure.Hashes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashHelper {
    public static final String HASH_TYPE_MD5 = "MD5";
    public static final String HASH_TYPE_SHA1 = "SHA-1";
    public static final String HASH_TYPE_SHA256 = "SHA-256";

    public static String md5Hash(File file) {
        return HashHelper.hash(file, HASH_TYPE_MD5);
    }

    public static String md5Hash(String string) {
        return HashHelper.md5Hash(string, false);
    }

    public static String md5Hash(String string, boolean replaceSlashes) {
        return HashHelper.hash(string, HASH_TYPE_MD5, replaceSlashes);
    }

    public static String sha1Hash(File file) {
        return HashHelper.hash(file, HASH_TYPE_SHA1);
    }

    public static String sha1Hash(String string) {
        return HashHelper.sha1Hash(string, false);
    }

    public static String sha1Hash(String string, boolean replaceSlashes) {
        return HashHelper.hash(string, HASH_TYPE_SHA1, replaceSlashes);
    }

    public static String sha256Hash(File file) {
        return HashHelper.hash(file, HASH_TYPE_SHA256);
    }

    public static String sha256Hash(String string) {
        return HashHelper.sha256Hash(string, false);
    }

    public static String sha256Hash(String string, boolean replaceSlashes) {
        return HashHelper.hash(string, HASH_TYPE_SHA256, replaceSlashes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String hash(File file, String algorithm) {
        if (file.isDirectory()) {
            Log.warning("File for hash creation is a directory (" + file.getAbsolutePath() + "). Using only its name (\"" + file.getName() + "\") for hash creation.");
            return HashHelper.hash(file.getName(), algorithm);
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            FileInputStream is = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            try {
                int read;
                while ((read = ((InputStream)is).read(buffer)) > 0) {
                    digest.update(buffer, 0, read);
                }
                byte[] hash = digest.digest();
                String string = HashHelper.makeOutput(hash);
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to process file.", e);
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e2) {
                    Log.warning("Could not close a file's input stream: " + file.getAbsolutePath());
                    return null;
                }
            }
        }
        catch (FileNotFoundException | NoSuchAlgorithmException e3) {
            Log.error("Could not find file for hash creation: " + file.getAbsolutePath());
            return null;
        }
    }

    public static String hash(String string, String algorithm) {
        return HashHelper.hash(string, algorithm, false);
    }

    public static String hash(String string, String algorithm, boolean replaceSlashes) {
        if (replaceSlashes) {
            string = string.replace("\\", "/");
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hash = digest.digest(string.getBytes());
            return HashHelper.makeOutput(hash);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static String makeOutput(byte[] byteStr) {
        BigInteger bigInt = new BigInteger(1, byteStr);
        String output = bigInt.toString(16);
        output = String.format("%32s", output).replace(' ', '0');
        return output;
    }

    public static String getHash(Hashes hashes, String type) {
        for (Hash hash : hashes.getHash()) {
            if (!hash.getType().equals(type)) continue;
            return hash.getValue();
        }
        return null;
    }
}

