/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.Log;
import de.foellix.aql.config.Priority;
import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Attribute;
import de.foellix.aql.datastructure.Attributes;
import de.foellix.aql.datastructure.Data;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Hash;
import de.foellix.aql.datastructure.Hashes;
import de.foellix.aql.datastructure.Intent;
import de.foellix.aql.datastructure.Intentfilter;
import de.foellix.aql.datastructure.Intentfilters;
import de.foellix.aql.datastructure.Intents;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsinks;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Intentsources;
import de.foellix.aql.datastructure.Parameter;
import de.foellix.aql.datastructure.Parameters;
import de.foellix.aql.datastructure.Permission;
import de.foellix.aql.datastructure.Permissions;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.Sink;
import de.foellix.aql.datastructure.Sinks;
import de.foellix.aql.datastructure.Source;
import de.foellix.aql.datastructure.Sources;
import de.foellix.aql.datastructure.Statement;
import de.foellix.aql.datastructure.Target;
import de.foellix.aql.datastructure.query.IStringOrQuestion;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.faketool.FakeToolHelper;
import de.foellix.aql.helper.CLIHelper;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.EqualsOptions;
import de.foellix.aql.helper.FileWithHash;
import de.foellix.aql.helper.HashHelper;
import de.foellix.aql.helper.RAWIdentifier;
import de.foellix.aql.system.defaulttools.analysistools.DefaultAnalysisTool;
import de.foellix.aql.system.defaulttools.operators.DefaultOperator;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.ConverterTask;
import de.foellix.aql.system.task.FilterOperatorTaskInfo;
import de.foellix.aql.system.task.PreprocessorTask;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskInfo;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Helper {
    public static final int OCCURENCE_LAST = -1;
    private static final String SPACER = "###SPACE###";
    private static final RAWIdentifier RAW = new RAWIdentifier();

    public static String cut(String input, String from, String to) {
        return Helper.cut(input, from, to, 1);
    }

    public static String cutFromFirstToLast(String input, String fromFirst, String toLast) {
        try {
            return input.substring(input.indexOf(fromFirst) + fromFirst.length(), input.lastIndexOf(toLast));
        }
        catch (StringIndexOutOfBoundsException e) {
            Log.msg("Input not valid! Input: \"" + input + "\", From: \"" + fromFirst + "\", To: \"" + toLast + "\"" + Log.getExceptionAppendix(e), 6);
            return input;
        }
    }

    public static String cut(String input, String from) {
        return Helper.cut(input, from, 1);
    }

    public static String cut(String input, String from, String to, int fromOccurence) {
        try {
            int pos1 = 0;
            int pos2 = 0;
            if (fromOccurence == -1) {
                fromOccurence = (input.length() - input.replace(from, "").length()) / from.length();
            }
            for (int i = 0; i < fromOccurence; ++i) {
                if (from != null) {
                    pos1 = input.indexOf(from, pos1) + from.length();
                    if (to == null) continue;
                    pos2 = input.indexOf(to, pos1);
                    continue;
                }
                if (to == null) continue;
                pos2 = input.indexOf(to, pos2);
            }
            if (to != null) {
                return input.substring(pos1, pos2);
            }
            return input.substring(pos1);
        }
        catch (StringIndexOutOfBoundsException e) {
            Log.msg("Input not valid! Input: \"" + input + "\", From: \"" + from + "\", To: \"" + to + "\", Occurence: " + (Serializable)(fromOccurence == -1 ? "last" : Integer.valueOf(fromOccurence)) + Log.getExceptionAppendix(e), 6);
            return input;
        }
    }

    public static String cut(String input, String from, int fromOccurence) {
        return Helper.cut(input, from, null, fromOccurence);
    }

    public static String cutFromStart(String input, String to) {
        return Helper.cutFromStart(input, to, 1);
    }

    public static String cutFromStart(String input, String to, int toOccurence) {
        try {
            int pos1 = 0;
            if (toOccurence == -1) {
                toOccurence = (input.length() - input.replace(to, "").length()) / to.length();
            }
            for (int i = 0; i < toOccurence; ++i) {
                if (to == null) continue;
                pos1 = input.indexOf(to, pos1);
            }
            return input.substring(0, pos1);
        }
        catch (StringIndexOutOfBoundsException e) {
            Log.msg("Input not valid! Input: \"" + input + "\", To: \"" + to + "\", Occurence: " + (Serializable)(toOccurence == -1 ? "last" : Integer.valueOf(toOccurence)) + Log.getExceptionAppendix(e), 6);
            return input;
        }
    }

    public static int countStringOccurences(String haystack, String needle) {
        return (haystack.length() - haystack.replace(needle, "").length()) / needle.length();
    }

    public static String replaceFirst(String input, String needle, String replacement) {
        if (((String)input).contains(needle)) {
            int start = ((String)input).indexOf(needle);
            int end = start + needle.length();
            input = ((String)input).substring(0, start) + replacement + ((String)input).substring(end);
        }
        return input;
    }

    public static String replaceAll(String input, String needle, String replacement) {
        while (input.contains(needle)) {
            input = Helper.replaceFirst(input, needle, replacement);
        }
        return input;
    }

    public static int soiToType(String soi) {
        switch (soi) {
            case "Flows": {
                return 0;
            }
            case "IntentFilters": {
                return 3;
            }
            case "Intents": {
                return 2;
            }
            case "IntentSinks": {
                return 5;
            }
            case "IntentSources": {
                return 4;
            }
            case "Permissions": {
                return 1;
            }
            case "Slice": {
                return 6;
            }
            case "Sources": {
                return 7;
            }
            case "Sinks": {
                return 8;
            }
            case "Arguments": {
                return 9;
            }
        }
        return -1;
    }

    public static String typeToSoi(int type) {
        switch (type) {
            case 0: {
                return "Flows";
            }
            case 3: {
                return "IntentFilters";
            }
            case 2: {
                return "Intents";
            }
            case 5: {
                return "IntentSinks";
            }
            case 4: {
                return "IntentSources";
            }
            case 1: {
                return "Permissions";
            }
            case 6: {
                return "Slice";
            }
            case 7: {
                return "Sources";
            }
            case 8: {
                return "Sinks";
            }
            case 9: {
                return "Arguments";
            }
        }
        return "Unknown";
    }

    public static Answer copy(Answer answer) {
        Answer returnAnswer = new Answer();
        if (answer.getFlows() != null) {
            returnAnswer.setFlows(new Flows());
            if (!answer.getFlows().getFlow().isEmpty()) {
                returnAnswer.getFlows().getFlow().addAll(answer.getFlows().getFlow());
            }
        }
        if (answer.getIntentfilters() != null) {
            returnAnswer.setIntentfilters(new Intentfilters());
            if (!answer.getIntentfilters().getIntentfilter().isEmpty()) {
                returnAnswer.getIntentfilters().getIntentfilter().addAll(answer.getIntentfilters().getIntentfilter());
            }
        }
        if (answer.getIntents() != null) {
            returnAnswer.setIntents(new Intents());
            if (!answer.getIntents().getIntent().isEmpty()) {
                returnAnswer.getIntents().getIntent().addAll(answer.getIntents().getIntent());
            }
        }
        if (answer.getIntentsinks() != null) {
            returnAnswer.setIntentsinks(new Intentsinks());
            if (!answer.getIntentsinks().getIntentsink().isEmpty()) {
                returnAnswer.getIntentsinks().getIntentsink().addAll(answer.getIntentsinks().getIntentsink());
            }
        }
        if (answer.getIntentsources() != null) {
            returnAnswer.setIntentsources(new Intentsources());
            if (!answer.getIntentsources().getIntentsource().isEmpty()) {
                returnAnswer.getIntentsources().getIntentsource().addAll(answer.getIntentsources().getIntentsource());
            }
        }
        if (answer.getPermissions() != null) {
            returnAnswer.setPermissions(new Permissions());
            if (!answer.getPermissions().getPermission().isEmpty()) {
                returnAnswer.getPermissions().getPermission().addAll(answer.getPermissions().getPermission());
            }
        }
        return returnAnswer;
    }

    public static Reference copy(Reference reference) {
        if (reference == null) {
            return null;
        }
        Reference newReference = new Reference();
        if (reference.getApp() != null) {
            newReference.setApp(reference.getApp());
        }
        if (reference.getClassname() != null) {
            newReference.setClassname(reference.getClassname());
        }
        if (reference.getMethod() != null) {
            newReference.setMethod(reference.getMethod());
        }
        if (reference.getStatement() != null) {
            newReference.setStatement(reference.getStatement());
        }
        return newReference;
    }

    public static Reference createReference(String aqlQueryReference) {
        Reference ref = new Reference();
        if (aqlQueryReference.contains("Statement('")) {
            if (aqlQueryReference.indexOf("')") > aqlQueryReference.indexOf("->")) {
                ref.setStatement(Helper.createStatement(Helper.cut(aqlQueryReference, "Statement('", "',")));
                ref.getStatement().setLinenumber(Integer.parseInt(Helper.cut(aqlQueryReference, "',", ")").replace(" ", "")));
            } else {
                ref.setStatement(Helper.createStatement(Helper.cut(aqlQueryReference, "Statement('", "')")));
            }
        }
        if (aqlQueryReference.contains("Method('")) {
            ref.setMethod(Helper.cut(aqlQueryReference, "Method('", "')"));
        }
        if (aqlQueryReference.contains("Class('")) {
            ref.setClassname(Helper.cut(aqlQueryReference, "Class('", "')"));
        }
        if (aqlQueryReference.contains("App('")) {
            File appFile = new File(Helper.cut(aqlQueryReference, "App('", "')"));
            ref.setApp(Helper.createApp(appFile));
        }
        return ref;
    }

    public static Statement createStatement(String jimpleString) {
        return Helper.createStatement(jimpleString, true, -1);
    }

    public static Statement createStatement(String jimpleString, int linenumber) {
        return Helper.createStatement(jimpleString, true, linenumber);
    }

    public static Statement createStatement(String jimpleString, boolean assignValues) {
        return Helper.createStatement(jimpleString, assignValues, -1);
    }

    public static Statement createStatement(String jimpleString, boolean assignValues, int linenumber) {
        Statement newstatement = new Statement();
        String statementfull = jimpleString;
        while (statementfull.startsWith("\t")) {
            statementfull = statementfull.substring(1);
        }
        newstatement.setStatementfull(statementfull);
        if (-1 < jimpleString.indexOf("<") && jimpleString.indexOf("<") < jimpleString.indexOf(">(")) {
            newstatement.setStatementgeneric(Helper.cutFromFirstToLast(jimpleString, "<", ">("));
        } else if (-1 < jimpleString.indexOf("<") && jimpleString.indexOf("<") < jimpleString.indexOf(">")) {
            newstatement.setStatementgeneric(Helper.cutFromFirstToLast(jimpleString, "<", ">"));
        } else {
            newstatement.setStatementgeneric(jimpleString);
        }
        if (linenumber > -1) {
            newstatement.setLinenumber(linenumber);
        }
        int openCount = Helper.countStringOccurences(jimpleString, "(");
        int closeCount = Helper.countStringOccurences(jimpleString, ")");
        if (openCount >= 1 && closeCount >= 1) {
            String values;
            String classes = Helper.cut(jimpleString, "(", ")", 1);
            if (!classes.equals("")) {
                newstatement.setParameters(new Parameters());
                String[] parameterClasses = classes.split(",");
                for (int i = 0; i < parameterClasses.length; ++i) {
                    Parameter parameter = new Parameter();
                    parameter.setType(parameterClasses[i]);
                    newstatement.getParameters().getParameter().add(parameter);
                }
            }
            if (assignValues && openCount >= 2 && closeCount >= 2 && !(values = Helper.cut(jimpleString, "(", ")", 2)).equals("")) {
                String[] parameterValues = values.split(", ");
                for (int i = 0; i < parameterValues.length && i < newstatement.getParameters().getParameter().size(); ++i) {
                    newstatement.getParameters().getParameter().get(i).setValue(parameterValues[i]);
                }
            }
        }
        return newstatement;
    }

    public static String getStatementfullSafe(Statement statement) {
        if (statement.getStatementfull() != null && !statement.getStatementfull().isEmpty()) {
            return statement.getStatementfull();
        }
        if (statement.getStatementgeneric() != null && !statement.getStatementgeneric().isEmpty()) {
            return statement.getStatementgeneric();
        }
        return null;
    }

    public static String getStatementgenericSafe(Statement statement) {
        if (statement.getStatementgeneric() != null && !statement.getStatementgeneric().isEmpty()) {
            return statement.getStatementgeneric();
        }
        if (statement.getStatementfull() != null && !statement.getStatementfull().isEmpty()) {
            if (statement.getStatementfull().contains("<") && statement.getStatementfull().indexOf("<") < statement.getStatementfull().indexOf("<")) {
                return Helper.cut(statement.getStatementfull(), "<", ">");
            }
            return statement.getStatementfull();
        }
        return null;
    }

    public static String toString(Object item) {
        if (item instanceof Answer) {
            return Helper.toString((Answer)item);
        }
        if (item instanceof Reference) {
            return Helper.toString((Reference)item);
        }
        if (item instanceof Permissions) {
            return Helper.toString((Permissions)item);
        }
        if (item instanceof Permission) {
            return Helper.toString((Permission)item);
        }
        if (item instanceof Flows) {
            return Helper.toString(item);
        }
        if (item instanceof Flow) {
            return Helper.toString((Flow)item);
        }
        if (item instanceof Intents) {
            return Helper.toString((Intents)item);
        }
        if (item instanceof Intent) {
            return Helper.toString((Intent)item);
        }
        if (item instanceof Intentfilters) {
            return Helper.toString((Intentfilters)item);
        }
        if (item instanceof Intentfilter) {
            return Helper.toString((Intentfilter)item);
        }
        if (item instanceof Intentsources) {
            return Helper.toString((Intentsources)item);
        }
        if (item instanceof Intentsource) {
            return Helper.toString((Intentsource)item);
        }
        if (item instanceof Intentsinks) {
            return Helper.toString((Intentsinks)item);
        }
        if (item instanceof Intentsink) {
            return Helper.toString((Intentsink)item);
        }
        if (item instanceof Target) {
            return Helper.toString((Target)item);
        }
        if (item instanceof Data) {
            return Helper.toString((Data)item);
        }
        if (item instanceof Tool) {
            return Helper.toString((Tool)item);
        }
        return item.toString();
    }

    public static String toString(Answer answer) {
        StringBuilder sb = new StringBuilder();
        if (answer.getPermissions() != null) {
            sb.append("*** Permissions ***\n" + Helper.toString(answer.getPermissions()) + "\n");
        }
        if (answer.getFlows() != null) {
            sb.append("*** Flows ***\n" + Helper.toString(answer.getFlows()) + "\n");
        }
        if (answer.getSources() != null) {
            sb.append("*** Sources ***\n" + Helper.toString(answer.getSources()) + "\n");
        }
        if (answer.getSinks() != null) {
            sb.append("*** Sinks ***\n" + Helper.toString(answer.getSinks()) + "\n");
        }
        if (answer.getIntents() != null) {
            sb.append("*** Intents ***\n" + Helper.toString(answer.getIntents()) + "\n");
        }
        if (answer.getIntentfilters() != null) {
            sb.append("*** IntentFilters ***\n" + Helper.toString(answer.getIntentfilters()) + "\n");
        }
        if (answer.getIntentsources() != null) {
            sb.append("*** IntentSources ***\n" + Helper.toString(answer.getIntentsources()) + "\n");
        }
        if (answer.getIntentsinks() != null) {
            sb.append("*** IntentSinks ***\n" + Helper.toString(answer.getIntentsinks()) + "\n");
        }
        return sb.toString();
    }

    public static String toString(Reference reference) {
        return Helper.toString(reference, "->", false);
    }

    public static String toString(Reference reference, String separator) {
        return Helper.toString(reference, separator, false);
    }

    public static String toString(Reference reference, boolean replaceQuotes) {
        return Helper.toString(reference, "->", replaceQuotes);
    }

    public static String toString(Reference reference, String separator, boolean replaceQuotes) {
        StringBuilder sb = new StringBuilder();
        if (reference != null) {
            if (reference.getStatement() != null && reference.getStatement().getStatementfull() != null) {
                sb.append(Helper.toStringStatement(reference.getStatement(), replaceQuotes) + separator);
            }
            if (reference.getMethod() != null) {
                sb.append(Helper.toStringMethod(reference.getMethod()) + separator);
            }
            if (reference.getClassname() != null) {
                sb.append(Helper.toStringClass(reference.getClassname()) + separator);
            }
            if (reference.getApp() != null && reference.getApp().getFile() != null) {
                sb.append(Helper.toStringApp(reference.getApp()));
            } else {
                sb.append("No .apk defined (Not App specific)");
            }
        } else {
            sb.append("No Reference");
        }
        return sb.toString();
    }

    public static String toString(Statement statement) {
        return Helper.toString(statement, false);
    }

    public static String toString(Statement statement, boolean replaceQuotes) {
        return Helper.toStringStatement(statement, replaceQuotes);
    }

    public static String toStringStatement(Statement statement) {
        return Helper.toStringStatement(statement, false);
    }

    public static String toStringStatement(Statement statement, boolean replaceQuotes) {
        return "Statement('" + (replaceQuotes ? CLIHelper.replaceQuotesWithNeedles(statement.getStatementfull()) : statement.getStatementfull()) + "'" + (String)(statement.getLinenumber() != null ? ", " + statement.getLinenumber() : "") + ")";
    }

    public static String toStringMethod(String method) {
        return "Method('" + method + "')";
    }

    public static String toStringClass(String classname) {
        return "Class('" + classname + "')";
    }

    public static String toStringApp(App app) {
        return "App('" + app.getFile() + "')";
    }

    public static String toRAW(Object item) {
        return RAW.toRAW(item);
    }

    public static String toRAW(Tool tool) {
        return RAW.toRAW(tool);
    }

    public static String toRAW(Flow flow) {
        return RAW.toRAW(flow);
    }

    public static String toRAW(Permission permission) {
        return RAW.toRAW(permission);
    }

    public static String toRAW(Intentsink intentsink) {
        return RAW.toRAW(intentsink);
    }

    public static String toRAW(Intentsource intentsource) {
        return RAW.toRAW(intentsource);
    }

    public static String toRAW(Reference from, Reference to) {
        return RAW.toRAW(from, to);
    }

    public static String toRAW(Reference reference) {
        return RAW.toRAW(reference);
    }

    public static String toRAW(App app) {
        return RAW.toRAW(app);
    }

    public static String toString(Permissions permissions) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < permissions.getPermission().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n" + Helper.toString(permissions.getPermission().get(i)));
            if (i >= permissions.getPermission().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Permission permission) {
        return "Name: " + permission.getName() + "\nReference: " + Helper.toString(permission.getReference()) + Helper.toString(permission.getAttributes());
    }

    public static String toString(Flows flows) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < flows.getFlow().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            sb.append(Helper.toString(flows.getFlow().get(i)));
            if (i >= flows.getFlow().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Flow flow) {
        return "From:\n" + Helper.toString(Helper.getFrom(flow.getReference())) + "\nTo:\n" + Helper.toString(Helper.getTo(flow.getReference())) + Helper.toString(flow.getAttributes());
    }

    public static String toString(Sources sources) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sources.getSource().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            sb.append(Helper.toString(sources.getSource().get(i)));
            if (i >= sources.getSource().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Source source) {
        StringBuilder sb = new StringBuilder();
        sb.append("Reference:\n" + Helper.toString(source.getReference()));
        return sb.toString() + Helper.toString(source.getAttributes());
    }

    public static String toString(Sinks sinks) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sinks.getSink().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            sb.append(Helper.toString(sinks.getSink().get(i)));
            if (i >= sinks.getSink().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Sink sink) {
        StringBuilder sb = new StringBuilder();
        sb.append("Reference:\n" + Helper.toString(sink.getReference()));
        return sb.toString() + Helper.toString(sink.getAttributes());
    }

    public static String toString(Intents intents) {
        return Helper.toString(intents, false);
    }

    public static String toString(Intents intents, boolean detailData) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < intents.getIntent().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            sb.append(Helper.toString(intents.getIntent().get(i), detailData));
            if (i >= intents.getIntent().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Intent intent) {
        return Helper.toString(intent, false);
    }

    public static String toString(Intent intent, boolean detailData) {
        StringBuilder sb = new StringBuilder();
        sb.append(Helper.toString(intent.getTarget(), detailData));
        sb.append("Reference:\n" + Helper.toString(intent.getReference()));
        return sb.toString() + Helper.toString(intent.getAttributes());
    }

    public static String toString(Intentfilters intentfilters) {
        return Helper.toString(intentfilters, false);
    }

    public static String toString(Intentfilters intentfilters, boolean detailData) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < intentfilters.getIntentfilter().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            sb.append(Helper.toString(intentfilters.getIntentfilter().get(i), detailData));
            if (i >= intentfilters.getIntentfilter().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Intentfilter intentfilter) {
        return Helper.toString(intentfilter, false);
    }

    public static String toString(Intentfilter intentfilter, boolean detailData) {
        StringBuilder sb = new StringBuilder();
        if (intentfilter.getAction() != null && !intentfilter.getAction().isEmpty()) {
            for (String action : intentfilter.getAction()) {
                sb.append("Action: " + action + "\n");
            }
        }
        if (intentfilter.getCategory() != null) {
            for (String category : intentfilter.getCategory()) {
                sb.append("Category: " + category + "\n");
            }
        }
        if (intentfilter.getData() != null) {
            for (Data data : intentfilter.getData()) {
                if (detailData) {
                    sb.append("Data: {\n" + Helper.toString(data) + "}\n");
                    continue;
                }
                sb.append("Data: is set" + (String)(data.getType() != null ? " (Type: " + data.getType() + ")" : "") + "\n");
            }
        }
        sb.append("Reference:\n" + Helper.toString(intentfilter.getReference()));
        return sb.toString() + Helper.toString(intentfilter.getAttributes());
    }

    public static String toString(Intentsinks intentsinks) {
        return Helper.toString(intentsinks, false);
    }

    public static String toString(Intentsinks intentsinks, boolean detailData) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < intentsinks.getIntentsink().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            sb.append(Helper.toString(intentsinks.getIntentsink().get(i), detailData));
            if (i >= intentsinks.getIntentsink().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Intentsink intentsink) {
        return Helper.toString(intentsink, false);
    }

    public static String toString(Intentsink intentsink, boolean detailData) {
        StringBuilder sb = new StringBuilder();
        sb.append(Helper.toString(intentsink.getTarget(), detailData));
        sb.append("Reference:\n" + Helper.toString(intentsink.getReference()));
        return sb.toString() + Helper.toString(intentsink.getAttributes());
    }

    public static String toString(Intentsources intentsources) {
        return Helper.toString(intentsources, false);
    }

    public static String toString(Intentsources intentsources, boolean detailData) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < intentsources.getIntentsource().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            sb.append(Helper.toString(intentsources.getIntentsource().get(i), detailData));
            if (i >= intentsources.getIntentsource().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Intentsource intentsource) {
        return Helper.toString(intentsource, false);
    }

    public static String toString(Intentsource intentsource, boolean detailData) {
        StringBuilder sb = new StringBuilder();
        sb.append(Helper.toString(intentsource.getTarget(), detailData));
        sb.append("Reference:\n" + Helper.toString(intentsource.getReference()));
        return sb.toString() + Helper.toString(intentsource.getAttributes());
    }

    public static String toString(Attributes attributes) {
        if (attributes != null && !attributes.getAttribute().isEmpty()) {
            StringBuilder sb = new StringBuilder("\nAttributes:");
            for (Attribute attribute : attributes.getAttribute()) {
                sb.append("\n- " + attribute.getName() + " = " + attribute.getValue());
            }
            return sb.toString();
        }
        return "";
    }

    public static String toString(Target target) {
        return Helper.toString(target, false);
    }

    public static String toString(Target target, boolean detailData) {
        if (target != null) {
            StringBuilder sb = new StringBuilder();
            if (target.getAction() != null && !target.getAction().isEmpty()) {
                for (String action : target.getAction()) {
                    sb.append("Action: " + action + "\n");
                }
            }
            if (target.getCategory() != null) {
                for (String category : target.getCategory()) {
                    sb.append("Category: " + category + "\n");
                }
            }
            if (target.getData() != null) {
                for (Data data : target.getData()) {
                    if (detailData) {
                        sb.append("Data: {\n" + Helper.toString(data) + "}\n");
                        continue;
                    }
                    sb.append("Data: is set" + (String)(data.getType() != null ? " (Type: " + data.getType() + ")" : "") + "\n");
                }
            }
            if (target.getReference() != null) {
                sb.append("Class: " + target.getReference().getClassname() + "\n");
            }
            if (!sb.isEmpty()) {
                return sb.toString();
            }
        }
        return "No target specified (Action/Category/Data Information missing)\n";
    }

    public static String toString(Data data) {
        StringBuilder sb = new StringBuilder();
        if (data.getHost() != null && data.getPort() != null) {
            sb.append("\tHost+Port: " + data.getHost() + ":" + data.getPort() + "\n");
        } else if (data.getHost() != null) {
            sb.append("\tHost: " + data.getHost() + "\n");
        } else if (data.getPort() != null) {
            sb.append("\tPort: " + data.getPort() + "\n");
        }
        if (data.getPath() != null) {
            sb.append("\tPath: " + data.getPath() + "\n");
        }
        if (data.getPathPattern() != null) {
            sb.append("\tPathPattern: " + data.getPathPattern() + "\n");
        }
        if (data.getPathPrefix() != null) {
            sb.append("\tPathPrefix: " + data.getPathPrefix() + "\n");
        }
        if (data.getScheme() != null) {
            sb.append("\tScheme: " + data.getScheme() + "\n");
        }
        if (data.getSsp() != null) {
            sb.append("\tSsp: " + data.getSsp() + "\n");
        }
        if (data.getSspPattern() != null) {
            sb.append("\tSspPattern: " + data.getSspPattern() + "\n");
        }
        if (data.getSspPrefix() != null) {
            sb.append("\tSspPrefix: " + data.getSspPrefix() + "\n");
        }
        if (data.getType() != null) {
            sb.append("\tType: " + data.getType() + "\n");
        }
        return sb.toString();
    }

    public static String toString(List<Tool> tools) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tools.size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            sb.append(Helper.toString(tools.get(i)));
            if (i >= tools.size() - 1) continue;
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public static String toString(Tool tool) {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: " + Helper.getQualifiedName(tool) + "\n");
        if (tool.getPriority().size() <= 1) {
            sb.append("Priority: " + tool.getPriority().get(0).getValue() + (String)(tool.getPriority().get(0).getFeature() != null && !tool.getPriority().get(0).getFeature().equals("") ? " (" + tool.getPriority().get(0).getFeature() + ")" : "") + "\n");
        } else {
            sb.append("Priorities:\n");
            for (Priority priority : tool.getPriority()) {
                sb.append(priority.getValue() + (String)(priority.getFeature() != null && !priority.getFeature().equals("") ? " (" + priority.getFeature() + ")" : "") + "\n");
            }
        }
        sb.append("Questions: " + tool.getQuestions() + "\n");
        sb.append("Path: " + tool.getPath() + "\n");
        if (tool.isExternal()) {
            sb.append("URL: " + tool.getExecute().getUrl() + "\n");
            sb.append("Username: " + tool.getExecute().getUsername() + "\n");
            sb.append("Password: " + tool.getExecute().getPassword() + "\n");
        } else {
            sb.append("Run: " + tool.getExecute().getRun() + "\n");
            sb.append("Result: " + tool.getExecute().getResult() + "\n");
            sb.append("Instances: " + tool.getExecute().getInstances() + "\n");
            sb.append("MemoryPerInstance: " + tool.getExecute().getMemoryPerInstance() + "\n");
        }
        sb.append("\nRun on Event:\n\t- Entry: " + Helper.replaceNull(tool.getRunOnEntry(), "-") + "\n\t- Success: " + Helper.replaceNull(tool.getRunOnSuccess(), "-") + "\n\t- Fail: " + Helper.replaceNull(tool.getRunOnFail(), "-") + "\n\t- Abort: " + Helper.replaceNull(tool.getRunOnAbort(), "-") + "\n\t- Exit: " + Helper.replaceNull(tool.getRunOnExit(), "-"));
        return sb.toString();
    }

    public static String getQualifiedName(Tool tool) {
        return tool.getName() + " (" + tool.getVersion() + ")";
    }

    public static List<File> getExternalAppFiles(Task task) {
        ArrayList<File> files = new ArrayList<File>();
        Question query = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task);
        String extQuery = Helper.getExternalQuery(task);
        for (App app : query.getAllApps(false, false)) {
            String allFiles = app.getFile();
            for (String fileStr : allFiles.replace(", ", ",").split(",")) {
                File file = new File(fileStr);
                if (!extQuery.contains(file.getAbsolutePath())) continue;
                files.add(file);
            }
        }
        return files;
    }

    public static String[] getRunCommandAsArray(String runCmd) {
        if (runCmd != null && !runCmd.isEmpty() && runCmd.contains(" ") && runCmd.contains("\"")) {
            String runCmdCopy = new String(runCmd);
            Matcher m = Pattern.compile("\"(.*?)\"").matcher(runCmd);
            while (m.find()) {
                runCmdCopy = runCmdCopy.replace(m.group(0), m.group(0).replace(" ", SPACER));
            }
            String[] runCmdAsArray = runCmdCopy.split(" ");
            for (int i = 0; i < runCmdAsArray.length; ++i) {
                runCmdAsArray[i] = runCmdAsArray[i].replace(SPACER, " ");
            }
            return runCmdAsArray;
        }
        return runCmd.split(" ");
    }

    public static String getExternalQuery(Task task) {
        HashMap<String, Object> replacementsSoFar = new HashMap<String, Object>();
        String query = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task).toString();
        for (Task child : task.getChildren()) {
            Object replacement;
            String needle;
            if (!child.getTaskAnswer().isAnswered()) continue;
            if (child instanceof PreprocessorTask) {
                needle = ((PreprocessorTask)child).getQuestionReference().toString();
                replacement = "App(" + child.getTaskAnswer().getAnswerForQuery(true) + ")";
            } else {
                needle = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(child).toString();
                replacement = child.getTaskAnswer().getAnswerForQuery(true);
            }
            for (String key : replacementsSoFar.keySet()) {
                needle = needle.replace(key, (CharSequence)replacementsSoFar.get(key));
            }
            query = query.replace(needle, (CharSequence)replacement);
            replacementsSoFar.put(needle, replacement);
        }
        return query;
    }

    public static List<File> getExternalQueryFiles(Task task) {
        ArrayList<File> files = new ArrayList<File>();
        for (Task child : task.getChildren()) {
            if (!child.getTaskAnswer().isAnswered() || child.getTaskAnswer().getType() != 0 && child.getTaskAnswer().getType() != 1) continue;
            files.add(child.getTaskAnswer().getAnswerFile());
        }
        return files;
    }

    public static List<File> getPreprocessorFiles(Task task) {
        ArrayList<File> apps = new ArrayList<File>();
        String appsStr = task.getTaskInfo().getData("%APP_APK%");
        for (String appStr : appsStr.replace(", ", ",").split(",")) {
            apps.add(new File(appStr));
        }
        Log.msg("Files given to external preprocessor: " + apps, 6);
        return apps;
    }

    public static String replaceVariables(String string, Task task) {
        return Helper.replaceVariables(string, task, null);
    }

    public static String replaceVariables(String string, Task task, Map<String, String> customVariables) {
        return Helper.replaceVariables(string, task, customVariables, false);
    }

    public static String replaceVariables(String string, Task task, Map<String, String> customVariables, boolean useHashesAndNoDate) {
        return Helper.replaceVariables(string, task, customVariables, useHashesAndNoDate, useHashesAndNoDate);
    }

    public static String replaceVariables(String string, Task task, Map<String, String> customVariables, boolean useHashes, boolean noDate) {
        Set<String> fileVariableNames = task.getTaskInfo().getAllFileVariableNames();
        for (String variableName : task.getTaskInfo().getAllSetVariableNames()) {
            String replacement = task.getTaskInfo().getData(variableName);
            if (replacement == null) continue;
            if (useHashes) {
                boolean isFileVariable = fileVariableNames.contains(variableName);
                if (!isFileVariable) {
                    boolean bl = isFileVariable = variableName.startsWith("%FILE_") && variableName.endsWith("%");
                }
                if (!isFileVariable && new File(replacement).exists() && replacement.contains(".")) {
                    String[] arr = replacement.split("\\.");
                    boolean bl = isFileVariable = arr.length == 2 && arr[0].replaceFirst(":", "").matches("[a-zA-Z0-9/\\\\\\-_]+") && arr[1].length() < 5 && arr[1].matches("[a-zA-Z0-9]+");
                }
                if (isFileVariable) {
                    LinkedList<FileWithHash> files = new LinkedList<FileWithHash>();
                    String[] parts = replacement.split(",");
                    for (int i = 0; i < parts.length; ++i) {
                        while (parts[i].startsWith(" ")) {
                            parts[i] = parts[i].substring(1);
                        }
                        files.add(new FileWithHash(parts[i]));
                    }
                    string = string.replace(variableName, Helper.getAnswerFilesAsHash(files));
                    continue;
                }
            }
            if (variableName.equals("%DATE%")) {
                if (noDate) {
                    string = string.replace(variableName, "DATE-SKIPPED");
                    continue;
                }
                string = string.replace(variableName, replacement);
                continue;
            }
            if (variableName.equals("%STATEMENT_IN%") || variableName.equals("%STATEMENT_FROM%") || variableName.equals("%STATEMENT_TO%")) {
                string = string.replace(variableName, CLIHelper.replaceQuotesWithNeedles(replacement));
                continue;
            }
            string = string.replace(variableName, replacement);
        }
        if (string.contains(FakeToolHelper.FAKETOOL_VARIABLE)) {
            string = FakeToolHelper.replaceFakeToolVariable(string);
        }
        if (customVariables == null) {
            return string;
        }
        return Helper.replaceCustomVariables(string, customVariables);
    }

    public static String replaceCustomVariables(String string, Map<String, String> customVariables) {
        for (String variableName : customVariables.keySet()) {
            String replacement = customVariables.get(variableName);
            if (replacement == null) continue;
            variableName = Helper.toVariableName(variableName);
            string = string.replace(variableName, replacement);
        }
        return string;
    }

    public static String toVariableName(String variableName) {
        if (!((String)variableName).startsWith("%")) {
            variableName = "%" + (String)variableName;
        }
        if (!((String)variableName).endsWith("%")) {
            variableName = (String)variableName + "%";
        }
        return variableName;
    }

    public static String reportMissingVariables(String runCmd, Task task) {
        String unVars = Helper.reportMissingVariables(runCmd);
        if (unVars != null && !(task.getTool() instanceof DefaultAnalysisTool)) {
            Log.warning("Run command of tool " + Helper.getQualifiedName(task.getTool()) + " contains " + (unVars.contains(",") ? "unresolved variables" : "an unresolved variable") + ": " + unVars);
        }
        return unVars;
    }

    public static String reportMissingVariables(String string) {
        StringBuilder sb = new StringBuilder();
        Matcher m = Pattern.compile("%(.*?)%").matcher(string);
        while (m.find()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(m.group(0));
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public static List<FileWithHash> getAnswerChildrenAsString(Task task) {
        ArrayList<FileWithHash> answerFiles = new ArrayList<FileWithHash>();
        for (Task taskChild : task.getChildren()) {
            if (!taskChild.getTaskAnswer().isAnswered()) continue;
            answerFiles.add(new FileWithHash(taskChild.getTaskAnswer().getAnswerFile()));
        }
        return answerFiles;
    }

    public static String getAnswerFilesAsString(List<FileWithHash> answerFiles) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < answerFiles.size(); ++i) {
            sb.append(answerFiles.get(i).getFile().getAbsolutePath().replace("\\", "/")).append(i != answerFiles.size() - 1 ? ", " : "");
        }
        return sb.toString();
    }

    public static String getAnswerFilesAsHash(FileWithHash answerFile) {
        return Helper.getAnswerFilesAsHash(answerFile, "SHA-256");
    }

    public static String getAnswerFilesAsHash(FileWithHash answerFile, String hashAlgorithm) {
        return Helper.getAnswerFilesAsHash(Collections.singletonList(answerFile), hashAlgorithm);
    }

    public static String getAnswerFilesAsHash(List<FileWithHash> answerFiles) {
        return Helper.getAnswerFilesAsHash(answerFiles, "SHA-256");
    }

    public static String getAnswerFilesAsHash(List<FileWithHash> answerFiles, String hashAlgorithm) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < answerFiles.size(); ++i) {
            sb.append(answerFiles.get(i).getHash().getValue() + (i != answerFiles.size() - 1 ? ", " : ""));
        }
        return HashHelper.hash(sb.toString(), hashAlgorithm);
    }

    public static List<FileWithHash> toHashedFileList(List<File> answerFiles) {
        return Helper.toHashedFileList(answerFiles, "SHA-256");
    }

    public static List<FileWithHash> toHashedFileList(List<File> answerFiles, String hashAlgorithm) {
        ArrayList<FileWithHash> answerFilesHashed = new ArrayList<FileWithHash>();
        for (File answerFile : answerFiles) {
            answerFilesHashed.add(new FileWithHash(answerFile, hashAlgorithm));
        }
        return answerFilesHashed;
    }

    public static String getMultipleApkName(String name) {
        StringBuilder full = new StringBuilder("");
        for (String onePart : name.split(" ")) {
            if (!(onePart = onePart.replace("\\", "/")).contains("/")) continue;
            if (full.length() != 0) {
                full.append(" ");
            }
            full.append(Helper.cut(onePart, "/", -1));
        }
        return full.toString().replace(",", "").replace(" ", "_").replace(".apk", "");
    }

    public static String getDate() {
        return Helper.getDate(System.currentTimeMillis());
    }

    public static String getDate(long timestamp) {
        return Helper.getDate(timestamp, "dd_MM_yyyy-HH_mm_ss");
    }

    public static String getDate(long timestamp, String format) {
        Date date = new Date(timestamp);
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static long getTimestamp(String dateStr, String format) {
        try {
            return new SimpleDateFormat(format).parse(dateStr).getTime();
        }
        catch (ParseException e) {
            return -1L;
        }
    }

    public static App createApp(File file) {
        return Helper.createApp(file.toString());
    }

    public static App createApp(String value) {
        App app = new App();
        File file = new File(value);
        app.setFile(Helper.getAppFileString(file));
        Hashes hashes = new Hashes();
        Hash hashMD5 = new Hash();
        hashMD5.setType("MD5");
        Hash hashSHA1 = new Hash();
        hashSHA1.setType("SHA-1");
        Hash hashSHA256 = new Hash();
        hashSHA256.setType("SHA-256");
        if (file.exists()) {
            hashMD5.setValue(HashHelper.md5Hash(file));
            hashSHA1.setValue(HashHelper.sha1Hash(file));
            hashSHA256.setValue(HashHelper.sha256Hash(file));
        } else {
            Log.msg("Could not find file for hash creation (may not be necesarry at this point): " + file.getAbsolutePath(), 5);
            hashMD5.setValue(HashHelper.md5Hash(value));
            hashSHA1.setValue(HashHelper.sha1Hash(value));
            hashSHA256.setValue(HashHelper.sha256Hash(value));
        }
        hashes.getHash().add(hashMD5);
        hashes.getHash().add(hashSHA1);
        hashes.getHash().add(hashSHA256);
        app.setHashes(hashes);
        return app;
    }

    public static String getAppFileString(File appFile) {
        return appFile.getAbsolutePath().replace("\\", "/");
    }

    public static long getPid(Process p) {
        return p.toHandle().pid();
    }

    public static Reference getFrom(Flow flow) {
        return Helper.getFrom(flow.getReference());
    }

    public static Reference getFrom(List<Reference> references) {
        for (Reference ref : references) {
            if (!ref.getType().equals("from")) continue;
            return ref;
        }
        return null;
    }

    public static Reference getTo(Flow flow) {
        return Helper.getTo(flow.getReference());
    }

    public static Reference getTo(List<Reference> references) {
        for (Reference ref : references) {
            if (!ref.getType().equals("to")) continue;
            return ref;
        }
        return null;
    }

    public static Answer removeRedundant(Answer answer, EqualsOptions options) {
        Serializable obj2;
        int j;
        Serializable obj1;
        int i;
        Helper.maximizeInformation(answer, options, false);
        EqualsOptions localEqualsOptions = options.copy().setOption(2, true);
        if (answer.getPermissions() != null) {
            for (i = 0; i < answer.getPermissions().getPermission().size() - 1; ++i) {
                obj1 = answer.getPermissions().getPermission().get(i);
                for (j = i + 1; j < answer.getPermissions().getPermission().size(); ++j) {
                    obj2 = answer.getPermissions().getPermission().get(j);
                    if (!EqualsHelper.equals(obj1, obj2, localEqualsOptions)) continue;
                    answer.getPermissions().getPermission().remove(j);
                    --j;
                }
            }
        }
        if (answer.getIntents() != null) {
            for (i = 0; i < answer.getIntents().getIntent().size() - 1; ++i) {
                obj1 = answer.getIntents().getIntent().get(i);
                for (j = i + 1; j < answer.getIntents().getIntent().size(); ++j) {
                    obj2 = answer.getIntents().getIntent().get(j);
                    if (!EqualsHelper.equals((Intent)obj1, (Intent)obj2, localEqualsOptions)) continue;
                    answer.getIntents().getIntent().remove(j);
                    --j;
                }
            }
        }
        if (answer.getIntentfilters() != null) {
            for (i = 0; i < answer.getIntentfilters().getIntentfilter().size() - 1; ++i) {
                obj1 = answer.getIntentfilters().getIntentfilter().get(i);
                for (j = i + 1; j < answer.getIntentfilters().getIntentfilter().size(); ++j) {
                    obj2 = answer.getIntentfilters().getIntentfilter().get(j);
                    if (!EqualsHelper.equals((Intentfilter)obj1, (Intentfilter)obj2, localEqualsOptions)) continue;
                    answer.getIntentfilters().getIntentfilter().remove(j);
                    --j;
                }
            }
        }
        if (answer.getSources() != null) {
            for (i = 0; i < answer.getSources().getSource().size() - 1; ++i) {
                obj1 = answer.getSources().getSource().get(i);
                for (j = i + 1; j < answer.getSources().getSource().size(); ++j) {
                    obj2 = answer.getSources().getSource().get(j);
                    if (!EqualsHelper.equals((Source)obj1, (Source)obj2, localEqualsOptions)) continue;
                    answer.getSources().getSource().remove(j);
                    --j;
                }
            }
        }
        if (answer.getSinks() != null) {
            for (i = 0; i < answer.getSinks().getSink().size() - 1; ++i) {
                obj1 = answer.getSinks().getSink().get(i);
                for (j = i + 1; j < answer.getSinks().getSink().size(); ++j) {
                    obj2 = answer.getSinks().getSink().get(j);
                    if (!EqualsHelper.equals((Sink)obj1, (Sink)obj2, localEqualsOptions)) continue;
                    answer.getSinks().getSink().remove(j);
                    --j;
                }
            }
        }
        if (answer.getIntentsinks() != null) {
            for (i = 0; i < answer.getIntentsinks().getIntentsink().size() - 1; ++i) {
                obj1 = answer.getIntentsinks().getIntentsink().get(i);
                for (j = i + 1; j < answer.getIntentsinks().getIntentsink().size(); ++j) {
                    obj2 = answer.getIntentsinks().getIntentsink().get(j);
                    if (!EqualsHelper.equals((Intentsink)obj1, (Intentsink)obj2, localEqualsOptions)) continue;
                    answer.getIntentsinks().getIntentsink().remove(j);
                    --j;
                }
            }
        }
        if (answer.getIntentsources() != null) {
            for (i = 0; i < answer.getIntentsources().getIntentsource().size() - 1; ++i) {
                obj1 = answer.getIntentsources().getIntentsource().get(i);
                for (j = i + 1; j < answer.getIntentsources().getIntentsource().size(); ++j) {
                    obj2 = answer.getIntentsources().getIntentsource().get(j);
                    if (!EqualsHelper.equals((Intentsource)obj1, (Intentsource)obj2, localEqualsOptions)) continue;
                    answer.getIntentsources().getIntentsource().remove(j);
                    --j;
                }
            }
        }
        if (answer.getFlows() != null) {
            for (i = 0; i < answer.getFlows().getFlow().size() - 1; ++i) {
                obj1 = answer.getFlows().getFlow().get(i);
                for (j = i + 1; j < answer.getFlows().getFlow().size(); ++j) {
                    obj2 = answer.getFlows().getFlow().get(j);
                    if (!EqualsHelper.equals((Flow)obj1, (Flow)obj2, localEqualsOptions)) continue;
                    answer.getFlows().getFlow().remove(j);
                    --j;
                }
            }
        }
        return answer;
    }

    public static void maximizeInformation(Answer answer, EqualsOptions options, boolean parametersAndLinenumbersOnly) {
        LinkedList<Reference> collection2;
        Collection<Reference> collection1 = Helper.getAllReferences(answer, true);
        if (parametersAndLinenumbersOnly) {
            collection2 = new LinkedList();
            LinkedList<Reference> toRemove = new LinkedList<Reference>();
            for (Reference ref : collection1) {
                if (ref.getStatement() == null) {
                    toRemove.add(ref);
                    continue;
                }
                if ((ref.getStatement().getParameters() == null || ref.getStatement().getParameters().getParameter().isEmpty()) && (ref.getStatement().getLinenumber() == null || ref.getStatement().getLinenumber() == -1)) continue;
                toRemove.add(ref);
                collection2.add(ref);
            }
            collection1.removeAll(toRemove);
        } else {
            collection2 = Helper.getAllReferences(answer, true);
        }
        Helper.keepAllInformation(collection1, collection2, options);
    }

    private static void keepAllInformation(Collection<Reference> collection1, Collection<Reference> collection2, EqualsOptions options) {
        if (!collection1.isEmpty() && !collection2.isEmpty()) {
            for (Reference ref1 : collection1) {
                for (Reference ref2 : collection2) {
                    if (ref1 == ref2 || !EqualsHelper.equals(ref1, ref2, options)) continue;
                    Helper.keepAllInformation(ref1, ref2, options);
                }
            }
        }
    }

    private static void keepAllInformation(Reference ref1, Reference ref2, EqualsOptions options) {
        if (ref1.getStatement() != null && ref2.getStatement() != null) {
            if (ref1.getStatement().getStatementfull() != null && ref2.getStatement().getStatementfull() != null && ref1.getStatement().getStatementfull().length() < ref2.getStatement().getStatementfull().length()) {
                ref1.getStatement().setStatementfull(ref2.getStatement().getStatementfull());
            }
            if (ref1.getStatement().getStatementgeneric() != null && ref2.getStatement().getStatementgeneric() != null && ref1.getStatement().getStatementgeneric().length() < ref2.getStatement().getStatementgeneric().length()) {
                ref1.getStatement().setStatementgeneric(ref2.getStatement().getStatementgeneric());
            }
            if ((ref1.getStatement().getLinenumber() == null || ref1.getStatement().getLinenumber() == -1) && ref2.getStatement().getLinenumber() != null && ref2.getStatement().getLinenumber() > -1) {
                ref1.getStatement().setLinenumber(ref2.getStatement().getLinenumber());
            }
            if (ref1.getStatement().getParameters() == null && ref2.getStatement().getParameters() != null) {
                ref1.getStatement().setParameters(ref2.getStatement().getParameters());
            } else if (ref1.getStatement().getParameters() != null && ref2.getStatement().getParameters() != null) {
                Helper.keepAllParameterInformation(ref1.getStatement().getParameters().getParameter(), ref2.getStatement().getParameters().getParameter());
            }
        }
        if (ref1.getMethod() != null && ref2.getMethod() != null && ref1.getMethod().length() < ref2.getMethod().length()) {
            ref1.setMethod(ref2.getMethod());
        }
        if (ref1.getClassname() != null && ref2.getClassname() != null && ref1.getClassname().length() < ref2.getClassname().length()) {
            ref1.setClassname(ref2.getClassname());
        }
    }

    private static void keepAllParameterInformation(List<Parameter> params1, List<Parameter> params2) {
        if (params1.isEmpty() && !params2.isEmpty()) {
            params1.addAll(params2);
        } else if (!params1.isEmpty() && !params2.isEmpty()) {
            for (Parameter param1 : params1) {
                for (Parameter param2 : params2) {
                    if (param1 == param2 || !EqualsHelper.equals(param1, param2)) continue;
                    Helper.keepAllParameterInformation(param1, param2);
                }
            }
        }
    }

    private static void keepAllParameterInformation(Parameter param1, Parameter param2) {
        if (param1.getValue() == null || param1.getValue().length() < param2.getValue().length()) {
            param1.setValue(param2.getValue());
        }
    }

    public static int getCardinality(Tool tool, String operator) {
        if (tool == null || operator == null) {
            return 2;
        }
        if (tool instanceof DefaultOperator) {
            if (operator.equals("FILTER")) {
                return 1;
            }
            return 2;
        }
        for (String splitStr : tool.getQuestions().replace(" ", "").split(",")) {
            if (splitStr.equals(operator)) {
                return 0;
            }
            if (!splitStr.contains("(") || !splitStr.substring(0, splitStr.indexOf("(")).equals(operator)) continue;
            String cardinality = splitStr.substring(splitStr.indexOf("(") + 1, splitStr.indexOf(")"));
            if (cardinality.equals("*")) {
                return 0;
            }
            return Integer.parseInt(cardinality);
        }
        return -1;
    }

    public static File lastFileModified(File directory) {
        File fl = directory;
        File[] files = fl.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
        long lastMod = Long.MIN_VALUE;
        File choice = null;
        if (files != null) {
            for (File file : files) {
                if (file.lastModified() <= lastMod) continue;
                choice = file;
                lastMod = file.lastModified();
            }
        }
        return choice;
    }

    public static String replaceNull(String input, String replacement) {
        if (input == null) {
            return replacement;
        }
        return input;
    }

    public static void extractDataFromURI(String uri, Data data) {
        String temp = uri;
        data.setScheme(Helper.cutFromStart(temp, "://"));
        temp = Helper.cut(temp, "://");
        if (temp.contains(":")) {
            data.setHost(Helper.cutFromStart(temp, ":"));
            temp = Helper.cut(temp, ":");
            if (temp.contains("/")) {
                data.setPort(Helper.cutFromStart(temp, "/"));
                temp = Helper.cut(temp, "/");
            } else {
                data.setPort(temp);
                temp = "";
            }
        } else if (temp.contains("/")) {
            data.setHost(Helper.cutFromStart(temp, "/"));
        } else {
            data.setHost(temp);
            temp = "";
        }
        if (!temp.equals("")) {
            data.setPath(temp);
        }
    }

    public static void extractDataFromAuthority(String authority, Data data) {
        String temp = authority;
        if (temp.contains(":")) {
            data.setHost(Helper.cutFromStart(temp, ":"));
            data.setPort(Helper.cut(temp, ":"));
        } else {
            data.setHost(temp);
        }
    }

    public static boolean isEmpty(Answer answer) {
        return !(answer.getFlows() != null && !answer.getFlows().getFlow().isEmpty() || answer.getIntentfilters() != null && !answer.getIntentfilters().getIntentfilter().isEmpty() || answer.getIntents() != null && !answer.getIntents().getIntent().isEmpty() || answer.getIntentsinks() != null && !answer.getIntentsinks().getIntentsink().isEmpty() || answer.getIntentsources() != null && !answer.getIntentsources().getIntentsource().isEmpty() || answer.getPermissions() != null && !answer.getPermissions().getPermission().isEmpty());
    }

    public static boolean isEmpty(Target target) {
        if (target != null) {
            if (!Helper.isEmpty(target.getReference())) {
                return false;
            }
            if (target.getAction() != null && !target.getAction().isEmpty()) {
                return false;
            }
            if (target.getCategory() != null && !target.getCategory().isEmpty()) {
                return false;
            }
            if (target.getData() != null && !target.getData().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isEmpty(Reference reference) {
        if (reference != null) {
            if (reference.getStatement() != null) {
                return false;
            }
            if (reference.getMethod() != null) {
                return false;
            }
            if (reference.getClassname() != null) {
                return false;
            }
            if (reference.getApp() != null) {
                return false;
            }
        }
        return true;
    }

    public static Collection<Reference> getAllReferences(Answer answer) {
        return Helper.getAllReferences(answer, false);
    }

    public static Collection<Reference> getAllReferences(Answer answer, boolean doubleEntriesAllowed) {
        LinkedList<Reference> references = new LinkedList<Reference>();
        if (answer.getFlows() != null && !answer.getFlows().getFlow().isEmpty()) {
            for (Flow flow : answer.getFlows().getFlow()) {
                for (Reference ref : flow.getReference()) {
                    if (!doubleEntriesAllowed) {
                        boolean skip = false;
                        for (Reference temp : references) {
                            if (!EqualsHelper.equals(ref, temp)) continue;
                            skip = true;
                            break;
                        }
                        if (skip) continue;
                    }
                    references.add(ref);
                }
            }
        }
        if (answer.getSources() != null && !answer.getSources().getSource().isEmpty()) {
            for (Source source : answer.getSources().getSource()) {
                if (!doubleEntriesAllowed) {
                    boolean skip = false;
                    for (Reference temp : references) {
                        if (!EqualsHelper.equals(source.getReference(), temp)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                references.add(source.getReference());
            }
        }
        if (answer.getSinks() != null && !answer.getSinks().getSink().isEmpty()) {
            for (Sink sink : answer.getSinks().getSink()) {
                if (!doubleEntriesAllowed) {
                    boolean skip = false;
                    for (Reference temp : references) {
                        if (!EqualsHelper.equals(sink.getReference(), temp)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                references.add(sink.getReference());
            }
        }
        if (answer.getIntentfilters() != null && !answer.getIntentfilters().getIntentfilter().isEmpty()) {
            for (Intentfilter intentfilter : answer.getIntentfilters().getIntentfilter()) {
                if (!doubleEntriesAllowed) {
                    boolean skip = false;
                    for (Reference temp : references) {
                        if (!EqualsHelper.equals(intentfilter.getReference(), temp)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                references.add(intentfilter.getReference());
            }
        }
        if (answer.getIntents() != null && !answer.getIntents().getIntent().isEmpty()) {
            for (Intent intent : answer.getIntents().getIntent()) {
                if (!doubleEntriesAllowed) {
                    boolean skip = false;
                    for (Reference temp : references) {
                        if (!EqualsHelper.equals(intent.getReference(), temp)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                references.add(intent.getReference());
            }
        }
        if (answer.getIntentsinks() != null && !answer.getIntentsinks().getIntentsink().isEmpty()) {
            for (Intentsink intentsink : answer.getIntentsinks().getIntentsink()) {
                if (!doubleEntriesAllowed) {
                    boolean skip = false;
                    for (Reference temp : references) {
                        if (!EqualsHelper.equals(intentsink.getReference(), temp)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                references.add(intentsink.getReference());
            }
        }
        if (answer.getIntentsources() != null && !answer.getIntentsources().getIntentsource().isEmpty()) {
            for (Intentsource intentsource : answer.getIntentsources().getIntentsource()) {
                if (!doubleEntriesAllowed) {
                    boolean skip = false;
                    for (Reference temp : references) {
                        if (!EqualsHelper.equals(intentsource.getReference(), temp)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                references.add(intentsource.getReference());
            }
        }
        if (answer.getPermissions() != null && !answer.getPermissions().getPermission().isEmpty()) {
            for (Permission permission : answer.getPermissions().getPermission()) {
                if (!doubleEntriesAllowed) {
                    boolean skip = false;
                    for (Reference temp : references) {
                        if (!EqualsHelper.equals(permission.getReference(), temp)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                references.add(permission.getReference());
            }
        }
        return references;
    }

    public static String replaceAllWhiteSpaceChars(String string) {
        return Helper.replaceAllWhiteSpaceChars(string, false);
    }

    public static String replaceAllWhiteSpaceChars(String string, boolean removeTrailingWhiteSpace) {
        String s = string.replaceAll("\\s+", " ");
        if (removeTrailingWhiteSpace && s.endsWith(" ")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String replaceDoubleSpaces(String input) {
        while (input.contains("  ")) {
            input = input.replace("  ", " ");
        }
        return input;
    }

    public static ConverterTask getConverterParent(Task task) {
        Task parentTask;
        if (task.getParents().size() == 1 && (parentTask = task.getParents().iterator().next()) instanceof ConverterTask) {
            return (ConverterTask)parentTask;
        }
        return null;
    }

    public static String autoformat(String query) {
        return Helper.autoformat(query, true);
    }

    public static String autoformat(String query, boolean breaklines) {
        query = Helper.replaceAllWhiteSpaceChars(query);
        StringBuilder sb = new StringBuilder();
        int indent = 0;
        boolean inString = false;
        int len = query.length();
        String lastC = "";
        for (int i = 0; i < len; ++i) {
            String c = String.valueOf(query.charAt(i));
            if (!inString) {
                if (!(!lastC.equals(")") || c.equals(" ") || c.equals("-") || c.equals("?") || c.equals("!") || c.equals("."))) {
                    sb.append(" ");
                }
                if (c.equals("[") || c.equals("{")) {
                    sb.append(c + (breaklines ? "\n" : " "));
                    ++indent;
                    if (breaklines) {
                        for (o = 0; o < indent; ++o) {
                            sb.append("\t");
                        }
                    }
                } else if (c.equals("]") || c.equals("}")) {
                    sb.append(breaklines ? "\n" : " ");
                    --indent;
                    if (breaklines) {
                        for (o = 0; o < indent; ++o) {
                            sb.append("\t");
                        }
                    }
                    sb.append(c);
                } else if (c.equals("?") || c.equals("!") || c.equals(".")) {
                    if (!lastC.equals(" ")) {
                        sb.append(" ");
                    }
                    sb.append(c + (breaklines ? "\n" : " "));
                    if (breaklines) {
                        for (o = 0; o < indent; ++o) {
                            sb.append("\t");
                        }
                    }
                } else if (!lastC.equals("?") && !lastC.equals("!") && !lastC.equals(".") || !c.equals(" ")) {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            lastC = c;
            if (!c.equals("'")) continue;
            inString = !inString;
        }
        String newContent = sb.toString();
        if (breaklines) {
            Object tab = "\t";
            while (newContent.contains((CharSequence)tab)) {
                newContent = newContent.replace("\n" + (String)tab + ",", ",\n" + (String)tab);
                tab = (String)tab + "\t";
            }
            newContent = newContent.replace("\t ", "\t").replaceAll("\n(\t)*\n", "\n").replaceAll("\n(\t)*\\)", ")");
        }
        newContent = newContent.replace(" -> ", "->").replace(" ->", "->").replace("-> ", "->");
        while (newContent.endsWith(" ")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        return newContent;
    }

    public static String getAppFromData(TaskInfo taskInfo) {
        if (taskInfo.getData("%APP_APK_IN%") != null && !taskInfo.getData("%APP_APK_IN%").isEmpty()) {
            return taskInfo.getData("%APP_APK_IN%");
        }
        if (taskInfo.getData("%APP_APK_FROM%") != null && !taskInfo.getData("%APP_APK_FROM%").isEmpty()) {
            return taskInfo.getData("%APP_APK_FROM%");
        }
        if (taskInfo.getData("%APP_APK_TO%") != null && !taskInfo.getData("%APP_APK_TO%").isEmpty()) {
            return taskInfo.getData("%APP_APK_TO%");
        }
        if (taskInfo.getData("%APP_APK%") != null && !taskInfo.getData("%APP_APK%").isEmpty()) {
            return taskInfo.getData("%APP_APK%");
        }
        return null;
    }

    public static int getLineNumberSafe(Reference reference) {
        return reference == null || reference.getStatement() == null ? -1 : Helper.getLineNumberSafe(reference.getStatement());
    }

    public static int getLineNumberSafe(Statement statement) {
        return statement.getLinenumber() == null ? -1 : statement.getLinenumber();
    }

    public static boolean contains(List<IStringOrQuestion> list, String needle) {
        if (list != null) {
            for (IStringOrQuestion item : list) {
                if (!item.isComplete(true) || !item.toStringInAnswer(false).equals(needle)) continue;
                return true;
            }
        }
        return false;
    }

    public static Attribute getAttributeByName(Attributes attributes, String name) {
        if (attributes != null && !attributes.getAttribute().isEmpty()) {
            return Helper.getAttributeByName(attributes.getAttribute(), name);
        }
        return null;
    }

    public static Attribute getAttributeByName(List<Attribute> attributes, String name) {
        for (Attribute attr : attributes) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public static String cleanupParameters(String jimpleInvokeString) {
        String start = jimpleInvokeString.substring(0, jimpleInvokeString.indexOf(40));
        String parameters = jimpleInvokeString.substring(jimpleInvokeString.indexOf(40), jimpleInvokeString.indexOf(41));
        while (parameters.contains(", ")) {
            parameters = parameters.replace(", ", ",");
        }
        String end = jimpleInvokeString.substring(jimpleInvokeString.indexOf(41));
        return start + parameters + end;
    }

    public static URL getURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static Set<String> getAllDefaultVariableNames() {
        HashSet<String> allVars = new HashSet<String>();
        ToolTaskInfo tti = new ToolTaskInfo();
        allVars.addAll(tti.getAllVariableNames());
        FilterOperatorTaskInfo foti = new FilterOperatorTaskInfo();
        allVars.addAll(foti.getAllVariableNames());
        allVars.add("%ANDROID_PLATFORMS%");
        allVars.add("%ANDROID_BUILDTOOLS%");
        allVars.add("%MEMORY%");
        allVars.add("%PID%");
        allVars.add("%DATE%");
        return allVars;
    }

    public static String addZeroDigits(int id) {
        return Helper.addZeroDigits((long)id);
    }

    public static String addZeroDigits(long id) {
        if (id < 50000L) {
            return Helper.addZeroDigits(id, 5);
        }
        return Helper.addZeroDigits(id, 10);
    }

    public static String addZeroDigits(int id, int length) {
        return Helper.addZeroDigits((long)id, length);
    }

    public static String addZeroDigits(long id, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = String.valueOf(id).length(); i < length; ++i) {
            sb.append(0);
        }
        sb.append(id);
        return sb.toString();
    }

    public static String shorten(String string, int numberOrLines) {
        int index = 0;
        for (int i = 0; i < numberOrLines; ++i) {
            if ((index = string.indexOf("\n", index)) < 0 || index >= string.length()) {
                return string;
            }
            ++index;
        }
        return string.substring(0, index) + "...";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFeedbackFromFile(File file) {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            boolean isFeedback = false;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; (i < 3 || isFeedback) && (line = br.readLine()) != null; ++i) {
                if (!isFeedback && line.contains("Query not accepted due to one of the following reasons:")) {
                    isFeedback = true;
                }
                sb.append('\n').append(line);
            }
            if (!isFeedback) return null;
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            Log.msg("Could not check received file for feedback information: " + file.getAbsolutePath() + Log.getExceptionAppendix(e), 6);
        }
        return null;
    }
}

