/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.datastructure.Parameter;
import de.foellix.aql.datastructure.Statement;
import de.foellix.aql.helper.Helper;

public class JawaHelper {
    public static String toJawa(Statement statement) {
        if (statement.getStatementgeneric() == null || statement.getStatementgeneric().isBlank()) {
            statement.setStatementgeneric(Helper.getStatementgenericSafe(statement));
        }
        String className = statement.getStatementgeneric().substring(statement.getStatementgeneric().startsWith("<") ? 1 : 0, statement.getStatementgeneric().indexOf(58)).replace('.', '/');
        String methodName = Helper.cut(statement.getStatementgeneric(), " ", 2);
        methodName = methodName.substring(0, methodName.indexOf(40));
        StringBuilder parameters = new StringBuilder();
        if (statement.getParameters() != null && !statement.getParameters().getParameter().isEmpty()) {
            for (Parameter param : statement.getParameters().getParameter()) {
                parameters.append(JawaHelper.toJawaType(param.getType()));
            }
        }
        String returnType = JawaHelper.toJawaType(Helper.cut(statement.getStatementgeneric(), ": ", " ").replace('.', '/'));
        return "L" + className + ";." + methodName + ":(" + parameters.toString() + ")" + returnType;
    }

    public static String toJawaType(String javaTypeStr) {
        if (javaTypeStr == null || javaTypeStr.isEmpty()) {
            return javaTypeStr;
        }
        String array = "";
        if (javaTypeStr.endsWith("[]")) {
            array = "[";
            javaTypeStr = javaTypeStr.replace("[]", "");
        }
        if ((javaTypeStr = javaTypeStr.replace('.', '/')).equals("boolean")) {
            return array + "Z";
        }
        if (javaTypeStr.equals("short")) {
            return array + "S";
        }
        if (javaTypeStr.equals("int")) {
            return array + "I";
        }
        if (javaTypeStr.equals("long")) {
            return array + "L";
        }
        if (javaTypeStr.equals("float")) {
            return array + "F";
        }
        if (javaTypeStr.equals("double")) {
            return array + "D";
        }
        if (javaTypeStr.equals("byte")) {
            return array + "B";
        }
        if (javaTypeStr.equals("char")) {
            return array + "C";
        }
        if (javaTypeStr.equals("void")) {
            return array + "V";
        }
        return array + "L" + javaTypeStr + ";";
    }

    public static String toJavaType(String jawaTypeStr) {
        if (jawaTypeStr == null || jawaTypeStr.isEmpty()) {
            return jawaTypeStr;
        }
        if (!jawaTypeStr.contains("/") && jawaTypeStr.replace("[", "").length() > 1) {
            StringBuilder sb = new StringBuilder();
            boolean array = false;
            for (int i = 0; i < jawaTypeStr.length(); ++i) {
                if (jawaTypeStr.charAt(i) == '[') {
                    array = true;
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (array) {
                    sb.append(JawaHelper.toJavaType("[" + String.valueOf(jawaTypeStr.charAt(i))));
                } else {
                    sb.append(JawaHelper.toJavaType(String.valueOf(jawaTypeStr.charAt(i))));
                }
                array = false;
            }
            return sb.toString();
        }
        if (jawaTypeStr.equals("Z")) {
            return "boolean";
        }
        if (jawaTypeStr.equals("S")) {
            return "short";
        }
        if (jawaTypeStr.equals("I")) {
            return "int";
        }
        if (jawaTypeStr.equals("L")) {
            return "long";
        }
        if (jawaTypeStr.equals("F")) {
            return "float";
        }
        if (jawaTypeStr.equals("D")) {
            return "double";
        }
        if (jawaTypeStr.equals("B")) {
            return "byte";
        }
        if (jawaTypeStr.equals("C")) {
            return "char";
        }
        if (jawaTypeStr.equals("V")) {
            return "void";
        }
        if (jawaTypeStr.endsWith(";")) {
            jawaTypeStr = jawaTypeStr.substring(0, jawaTypeStr.length() - 1);
        }
        if (jawaTypeStr.startsWith("[")) {
            return JawaHelper.toJavaType(jawaTypeStr.substring(1)) + "[]";
        }
        jawaTypeStr = jawaTypeStr.replace("/", ".");
        return jawaTypeStr.substring(1);
    }
}

