/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.Log;
import de.foellix.aql.helper.HashHelper;
import de.foellix.aql.helper.ManifestInfo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.dongliu.apk.parser.ApkFile;

public class ManifestHelper {
    private final Map<String, ApkFile> data = new HashMap<String, ApkFile>();
    private static ManifestHelper instance = new ManifestHelper();

    private ManifestHelper() {
    }

    public static ManifestHelper getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getManifestRAW(File apkFile) {
        ApkFile apkParserFile = null;
        try {
            if (apkFile.exists()) {
                String hash = HashHelper.sha256Hash(apkFile);
                apkParserFile = this.data.get(hash);
                if (apkParserFile == null) {
                    try {
                        apkParserFile = new ApkFile(apkFile);
                        this.data.put(hash, apkParserFile);
                    }
                    catch (Exception e) {
                        Log.error("apk-parser failed to parse: \"" + apkFile.getAbsolutePath() + "\"" + Log.getExceptionAppendix(e));
                        String string = null;
                        if (apkParserFile != null) {
                            try {
                                apkParserFile.close();
                            }
                            catch (IOException e2) {
                                Log.error("Read APK information from \"" + apkFile.getAbsolutePath() + "\" but could not close access!" + Log.getExceptionAppendix(e2));
                            }
                        }
                        return string;
                    }
                }
                String e = apkParserFile.getManifestXml();
                return e;
            }
            Log.error("Apk file does not exist: \"" + apkFile.getAbsolutePath() + "\"");
            String string = null;
            return string;
        }
        finally {
            if (apkParserFile != null) {
                try {
                    apkParserFile.close();
                }
                catch (IOException e) {
                    Log.error("Read APK information from \"" + apkFile.getAbsolutePath() + "\" but could not close access!" + Log.getExceptionAppendix(e));
                }
            }
        }
    }

    public ApkFile getApkParserFile(File apkFile) {
        String hash = HashHelper.sha256Hash(apkFile);
        if (!this.data.containsKey(hash)) {
            this.getManifestRAW(apkFile);
        }
        return this.data.get(hash);
    }

    public ManifestInfo getManifest(File apkFile) {
        return new ManifestInfo(this.getManifestRAW(apkFile));
    }
}

