/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import com.sun.management.OperatingSystemMXBean;
import de.foellix.aql.Log;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.system.task.Task;
import java.lang.management.ManagementFactory;
import java.util.Set;

public class MemoryHelper {
    private final OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private final int availableInGB = Math.max(1, (int)Math.floor((double)(this.operatingSystemMXBean.getFreeMemorySize() - Runtime.getRuntime().maxMemory()) / 1.0E9));
    private static MemoryHelper instance = new MemoryHelper();

    private MemoryHelper() {
        if (ConfigHandler.getInstance().getConfig() != null && this.availableInGB < ConfigHandler.getInstance().getConfig().getMaxMemory()) {
            Log.warning("Maximum memory (" + ConfigHandler.getInstance().getConfig().getMaxMemory() + " GB) specified in config file will never become available. Using maximal available memory instead: " + this.availableInGB + " GB");
            ConfigHandler.getInstance().getConfig().setMaxMemory(this.availableInGB);
        }
    }

    public static MemoryHelper getInstance() {
        return instance;
    }

    public int getCurrentlyAvailableMemory(Set<Task> tasks) {
        int memoryInUse = 0;
        for (Task task : tasks) {
            if (task.getTool().isExternal()) continue;
            memoryInUse += task.getTool().getExecute().getMemoryPerInstance().intValue();
        }
        return this.getMaxAssignableMemory() - memoryInUse;
    }

    public int getMaxAvailableMemory() {
        return this.availableInGB;
    }

    public int getMaxAssignableMemory() {
        if (ConfigHandler.getInstance().getConfig() != null) {
            return Math.min(ConfigHandler.getInstance().getConfig().getMaxMemory(), this.availableInGB);
        }
        return this.availableInGB;
    }

    public String getMemoryInfo() {
        return "Maximum memory available: " + this.availableInGB + " GB, Maximum memory assigned in config: " + ConfigHandler.getInstance().getConfig().getMaxMemory() + " GB";
    }
}

