/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Hash;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Permission;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.Helper;

public class RAWIdentifier {
    private boolean genericStatementOnly;
    private boolean considerLineNumbers;

    public RAWIdentifier() {
        this.genericStatementOnly = false;
        this.considerLineNumbers = true;
    }

    public RAWIdentifier(boolean genericStatementOnly, boolean considerLineNumbers) {
        this.genericStatementOnly = genericStatementOnly;
        this.considerLineNumbers = considerLineNumbers;
    }

    public String toRAW(Object item) {
        if (item instanceof Permission) {
            return this.toRAW((Permission)item);
        }
        if (item instanceof Intentsink) {
            return this.toRAW((Intentsink)item);
        }
        if (item instanceof Intentsource) {
            return this.toRAW((Intentsource)item);
        }
        if (item instanceof Reference) {
            return this.toRAW((Reference)item);
        }
        if (item instanceof Tool) {
            return this.toRAW((Tool)item);
        }
        return null;
    }

    public String toRAW(Tool tool) {
        return tool.getName() + "-" + tool.getVersion();
    }

    public String toRAW(Flow flow) {
        return Helper.toRAW(Helper.getFrom(flow), Helper.getTo(flow));
    }

    public String toRAW(Permission permission) {
        String temp = "Permission:" + permission.getName() + this.toRAW(permission.getReference());
        return Helper.replaceAllWhiteSpaceChars(temp);
    }

    public String toRAW(Intentsink intentsink) {
        StringBuilder sb = new StringBuilder("Intentsink:");
        if (intentsink.getTarget() != null) {
            sb.append(Helper.toString(intentsink.getTarget(), true));
        }
        if (intentsink.getReference() != null) {
            sb.append(this.toRAW(intentsink.getReference()));
        }
        if (sb.length() <= 0) {
            sb.append(intentsink.hashCode());
        }
        return Helper.replaceAllWhiteSpaceChars(sb.toString());
    }

    public String toRAW(Intentsource intentsource) {
        StringBuilder sb = new StringBuilder("Intentsource:");
        if (intentsource.getTarget() != null) {
            sb.append(Helper.toString(intentsource.getTarget(), true));
        }
        if (intentsource.getReference() != null) {
            sb.append(this.toRAW(intentsource.getReference()));
        }
        if (sb.length() <= 0) {
            sb.append(intentsource.hashCode());
        }
        return Helper.replaceAllWhiteSpaceChars(sb.toString());
    }

    public String toRAW(Reference from, Reference to) {
        return Helper.toRAW(from) + " -> " + Helper.toRAW(to);
    }

    public String toRAW(Reference reference) {
        StringBuilder sb = new StringBuilder();
        if (reference.getStatement() != null) {
            if (!this.genericStatementOnly) {
                sb.append(reference.getStatement().getStatementfull());
            } else {
                sb.append(reference.getStatement().getStatementgeneric());
            }
            if (this.considerLineNumbers) {
                sb.append(":" + (reference.getStatement().getLinenumber() == null ? -1 : reference.getStatement().getLinenumber()));
            }
        }
        if (reference.getMethod() != null) {
            sb.append(reference.getMethod());
        }
        if (reference.getClassname() != null) {
            sb.append(reference.getClassname());
        }
        if (reference.getApp() != null) {
            sb.append(this.toRAW(reference.getApp()));
        }
        return sb.toString();
    }

    public String toRAW(App app) {
        StringBuilder sb = new StringBuilder();
        if (app.getHashes() != null && !app.getHashes().getHash().isEmpty()) {
            for (Hash hash : app.getHashes().getHash()) {
                sb.append(hash.getType() + ": " + hash.getValue());
            }
        }
        return sb.toString();
    }
}

