/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipHelper {
    public static void zip(File fileToZip, File zipFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        ZipHelper.zipFile(fileToZip, fileToZip.getName(), zipOut, zipFile);
        zipOut.close();
        fos.close();
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut, File zipFile) throws IOException {
        int length;
        if (fileToZip.equals(zipFile)) {
            return;
        }
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children = fileToZip.listFiles();
            if (children != null) {
                for (File childFile : children) {
                    ZipHelper.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut, zipFile);
                }
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    public static void unzip(File zipFile, File destinationDirectory) {
        ZipHelper.unzip(zipFile, destinationDirectory, true, null);
    }

    public static void unzip(File zipFile, File destinationDirectory, boolean mkdirs) {
        ZipHelper.unzip(zipFile, destinationDirectory, mkdirs, null);
    }

    public static void unzip(File zipFile, File destinationDirectory, boolean mkdirs, String fileMatcher) {
        if (mkdirs) {
            destinationDirectory.mkdirs();
        }
        if (destinationDirectory.exists()) {
            byte[] buffer = new byte[1024];
            try {
                ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    File newFile = ZipHelper.getUnzipFile(destinationDirectory, zipEntry);
                    Log.msg("Unzipping: " + newFile.getAbsolutePath(), 6);
                    if (zipEntry.isDirectory()) {
                        if (mkdirs) {
                            newFile.mkdirs();
                        }
                    } else if (fileMatcher == null || newFile.getName().matches(fileMatcher)) {
                        int len;
                        if (newFile.getParentFile() != null && !newFile.getParentFile().exists()) {
                            newFile.getParentFile().mkdirs();
                        }
                        if (newFile.exists()) {
                            newFile.delete();
                        }
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                    }
                    zipEntry = zis.getNextEntry();
                }
                zis.closeEntry();
                zis.close();
            }
            catch (IOException e) {
                Log.error("Could not unzip \"" + zipFile.getAbsolutePath() + "\" into \"" + destinationDirectory + "\"." + Log.getExceptionAppendix(e));
            }
        } else if (mkdirs) {
            Log.error("Could not unzip \"" + zipFile.getAbsolutePath() + "\". Destination directory could not be created: " + destinationDirectory);
        } else {
            Log.error("Could not unzip \"" + zipFile.getAbsolutePath() + "\". Destination directory does not exist: " + destinationDirectory);
        }
    }

    private static File getUnzipFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the destination directory: " + zipEntry.getName());
        }
        return destFile;
    }
}

