/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper.tools;

import de.foellix.aql.Log;
import de.foellix.aql.system.ProcessWrapper;
import java.io.File;
import java.io.IOException;

public class APKSigner {
    private static final int SYSTEM_UNKNOWN = -1;
    private static final int SYSTEM_WINDOWS = 0;
    private static final int SYSTEM_LINUX_BASED = 1;
    private static final String SCRIPT = "data/sign/sign";
    private static final String TEMP_APK = "data/temp/tempApkForSigning.apk";
    private static final String DEFAULT_KEYSTORE_PASSWORD = "AQL123";
    private static final String DEFAULT_KEYSTORE = "data/sign/keyForSigning.jks";
    private File outputApk = null;
    private File script = null;
    private File zipAligner = null;
    private File apkSigner = null;
    private int system = -1;
    private File directory = null;

    public APKSigner(File sdkBuildTools) {
        this.system = this.getSystem();
        if (this.system == 0) {
            this.init(new File(sdkBuildTools, "zipalign.exe"), new File(sdkBuildTools, "apksigner.bat"));
        } else if (this.system == 0) {
            this.init(new File(sdkBuildTools, "zipalign"), new File(sdkBuildTools, "apksigner"));
        } else {
            Log.error("Cannot sign APK since the operating system could not be identified.");
        }
    }

    public APKSigner(File zipAligner, File apkSigner) {
        this.init(zipAligner, apkSigner);
    }

    private void init(File zipAligner, File apkSigner) {
        this.zipAligner = zipAligner;
        this.apkSigner = apkSigner;
        this.system = this.getSystem();
        if (this.system == -1) {
            if (zipAligner.getName().endsWith(".exe")) {
                Log.warning("Could not detext operating system. Assuming a Windows system.");
                this.system = 0;
            } else {
                Log.warning("Could not detext operating system. Assuming a Linux based system.");
                this.system = 1;
            }
        }
    }

    private int getSystem() {
        if (this.system != -1) {
            return this.system;
        }
        String system = System.getProperty("os.name").toLowerCase();
        if (system.contains("win")) {
            return 0;
        }
        if (system.contains("mac") || system.contains("nix") || system.contains("nux") || system.contains("aix")) {
            return 1;
        }
        return -1;
    }

    public boolean sign(File apkToSign) {
        return this.sign(apkToSign, DEFAULT_KEYSTORE_PASSWORD);
    }

    public boolean sign(File apkToSign, String keyStorePassword) {
        File keyStore = this.directory == null ? new File(DEFAULT_KEYSTORE) : new File(this.directory, DEFAULT_KEYSTORE);
        return this.sign(apkToSign, keyStorePassword, keyStore);
    }

    public boolean sign(File apkToSign, String keyStorePassword, File keyStore) {
        String[] cmd;
        this.script = this.directory == null ? (this.system == 0 ? new File("data/sign/sign.bat") : new File("data/sign/sign.sh")) : (this.system == 0 ? new File(this.directory, "data/sign/sign.bat") : new File(this.directory, "data/sign/sign.sh"));
        cmd = new String[]{this.script.getAbsolutePath(), this.zipAligner.getAbsolutePath(), this.apkSigner.getAbsolutePath(), keyStore.getAbsolutePath(), keyStorePassword, this.directory == null ? new File(TEMP_APK).getAbsolutePath() : new File(this.directory, TEMP_APK).getAbsolutePath(), apkToSign.getAbsolutePath(), this.outputApk == null ? cmd[6] : this.outputApk.getAbsolutePath()};
        try {
            ProcessWrapper pw;
            ProcessBuilder pb = new ProcessBuilder(cmd);
            if (this.directory != null) {
                pb.directory(this.directory);
            }
            if (Log.logIt(5)) {
                StringBuilder sb = new StringBuilder();
                for (String part : cmd) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(part);
                }
                Log.msg("Start signing \"" + apkToSign + "\" by running: " + sb.toString() + " (in: " + (this.directory != null ? this.directory.getAbsolutePath() : "local directory") + ")", 5);
            }
            if ((pw = new ProcessWrapper(pb.start())).waitFor() != 0) {
                Log.error("Something went wrong while signing \"" + apkToSign + "\". \"" + this.script + "\" did not terminate successfully!");
                return false;
            }
            Log.msg("Finished signing \"" + apkToSign + "\".", 5);
            return true;
        }
        catch (IOException e) {
            Log.error("Something went wrong while signing \"" + apkToSign + "\"." + Log.getExceptionAppendix(e));
            return false;
        }
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void setOutputApk(File outputApk) {
        this.outputApk = outputApk;
    }
}

