/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper.tools;

import de.foellix.aql.helper.AsteriskMap;
import de.foellix.aql.helper.SootHelper;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.util.Chain;

public class FeatureFinder {
    private static final File FEATURES_FILE = new File("data/Features.txt");
    private static Map<String, Set<String>> featureMap = null;

    public FeatureFinder() {
        if (featureMap == null) {
            featureMap = new AsteriskMap();
            ((AsteriskMap)featureMap).load(FEATURES_FILE);
        }
    }

    public List<String> getFeatures(File apkFile) {
        HashSet<String> features = new HashSet<String>();
        Chain classes = SootHelper.getScene(apkFile).getApplicationClasses();
        for (SootClass sc : classes) {
            if (!sc.isConcrete()) continue;
            for (SootMethod sm : sc.getMethods()) {
                this.addFeatures(features, sm);
            }
        }
        LinkedList<String> sortedFeatures = new LinkedList<String>(features);
        Collections.sort(sortedFeatures);
        return sortedFeatures;
    }

    public void addFeatures(Collection<String> features, SootMethod sm) {
        Body b;
        if (sm.isConcrete() && (b = sm.retrieveActiveBody()) != null) {
            for (Unit u : b.getUnits()) {
                String invokeStr;
                Stmt ss;
                if (!(u instanceof Stmt) || !(ss = (Stmt)u).containsInvokeExpr() || featureMap.get(invokeStr = ss.getInvokeExpr().toString()) == null) continue;
                features.addAll((Collection<String>)featureMap.get(invokeStr));
            }
        }
    }
}

