/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper.tools;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Data;
import de.foellix.aql.datastructure.Intent;
import de.foellix.aql.datastructure.Intentfilter;
import de.foellix.aql.datastructure.Intentfilters;
import de.foellix.aql.datastructure.Intents;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsinks;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Intentsources;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.AsteriskMap;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.helper.ManifestHelper;
import de.foellix.aql.helper.ManifestInfo;
import de.foellix.aql.helper.SootHelper;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;

public class IntentInformationFinder {
    private static final String NO_APK_MSG = "Cannot run IntentInformationFinder since apk file was not set!";
    private static final String INTENT = "Intent";
    private static final String INTENTFILTER = "Intentfilter";
    private static final String INTENTSINK = "Intentsink";
    private static final String INTENTSOURCE = "Intentsource";
    private static final File INTENT_INFORMATION_FILE = new File("data/IntentInformation.txt");
    private static Map<String, Set<String>> intentInformationMap = null;
    private File apkFile;
    private Collection<SootClass> classes = null;
    private Intents intents = null;
    private Intentfilters intentfilters = null;
    private Intentsinks intentsinks = null;
    private Intentsources intentsources = null;
    private boolean intentInformationRequested = false;
    private boolean intentFiltersRequested = false;

    public IntentInformationFinder(File apkFile) {
        if (intentInformationMap == null) {
            intentInformationMap = new AsteriskMap();
            ((AsteriskMap)intentInformationMap).load(INTENT_INFORMATION_FILE);
        }
        this.intents = new Intents();
        this.intentfilters = new Intentfilters();
        this.intentsinks = new Intentsinks();
        this.intentsources = new Intentsources();
        this.intentInformationRequested = false;
        this.intentFiltersRequested = false;
        this.apkFile = apkFile;
        this.classes = SootHelper.getScene(apkFile).getApplicationClasses();
    }

    private void getIntentInformation() {
        if (this.apkFile == null) {
            Log.error(NO_APK_MSG);
            return;
        }
        if (!this.intentInformationRequested) {
            App app = Helper.createApp(this.apkFile);
            for (SootClass sc : this.classes) {
                if (!sc.isConcrete()) continue;
                for (SootMethod sm : sc.getMethods()) {
                    Body b;
                    if (!sm.isConcrete() || (b = sm.retrieveActiveBody()) == null) continue;
                    for (Unit u : b.getUnits()) {
                        Serializable item;
                        String invokeStr;
                        Stmt ss;
                        if (!(u instanceof Stmt) || !(ss = (Stmt)u).containsInvokeExpr() || intentInformationMap.get(invokeStr = ss.getInvokeExpr().toString()) == null) continue;
                        Reference ref = new Reference();
                        ref.setStatement(Helper.createStatement(u.toString()));
                        ref.setMethod(sm.toString());
                        ref.setClassname(sc.toString());
                        ref.setApp(app);
                        if (intentInformationMap.get(invokeStr).contains(INTENT)) {
                            item = new Intent();
                            ((Intent)item).setReference(ref);
                            this.intents.getIntent().add((Intent)item);
                            continue;
                        }
                        if (intentInformationMap.get(invokeStr).contains(INTENTFILTER)) {
                            item = new Intentfilter();
                            ((Intentfilter)item).getAction().add("");
                            ((Intentfilter)item).getCategory().add("");
                            ((Intentfilter)item).getData().add(new Data());
                            ((Intentfilter)item).setReference(ref);
                            this.intentfilters.getIntentfilter().add((Intentfilter)item);
                            continue;
                        }
                        if (intentInformationMap.get(invokeStr).contains(INTENTSINK)) {
                            item = new Intentsink();
                            ((Intentsink)item).setReference(ref);
                            this.intentsinks.getIntentsink().add((Intentsink)item);
                            continue;
                        }
                        if (!intentInformationMap.get(invokeStr).contains(INTENTSOURCE)) continue;
                        item = new Intentsource();
                        ((Intentsource)item).setReference(ref);
                        this.intentsources.getIntentsource().add((Intentsource)item);
                    }
                }
            }
            this.intentInformationRequested = true;
        }
    }

    public Intents getIntents() {
        this.getIntentInformation();
        return this.intents;
    }

    public Intentfilters getIntentfilters() {
        this.getIntentInformation();
        if (!this.intentFiltersRequested) {
            ManifestInfo manifestInfo = ManifestHelper.getInstance().getManifest(this.apkFile);
            this.intentfilters.getIntentfilter().addAll(manifestInfo.getAllIntentfilters().getIntentfilter());
            this.intentFiltersRequested = true;
        }
        return this.intentfilters;
    }

    public Intentsinks getIntentsinks() {
        this.getIntentInformation();
        return this.intentsinks;
    }

    public Intentsources getIntentsources() {
        this.getIntentInformation();
        return this.intentsources;
    }
}

