/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper.tools;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.Sink;
import de.foellix.aql.datastructure.Sinks;
import de.foellix.aql.datastructure.Source;
import de.foellix.aql.datastructure.Sources;
import de.foellix.aql.helper.AsteriskMap;
import de.foellix.aql.helper.HashHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.helper.SootHelper;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;

public class SourceSinkFinder {
    private static final String NO_APK_MSG = "Cannot run SourceSinkFinder since apk file was not set!";
    private static final File SOURCES_AND_SINKS_FILE = new File("data/SourcesAndSinks.txt");
    private static String lastLoadedSaSFileHash;
    private static Map<String, Set<String>> sourceSinkMap;
    private File apkFile;
    private Collection<SootClass> classes = null;
    private Sources sources = null;
    private Sinks sinks = null;
    private boolean sourcesAndSinksRequested = false;

    public SourceSinkFinder(File apkFile) {
        this(apkFile, SOURCES_AND_SINKS_FILE);
    }

    public SourceSinkFinder(File apkFile, File sourceAndSinkFile) {
        String hash = HashHelper.sha256Hash(sourceAndSinkFile);
        if (lastLoadedSaSFileHash == null || !lastLoadedSaSFileHash.equals(hash)) {
            lastLoadedSaSFileHash = hash;
            sourceSinkMap = new AsteriskMap();
            ((AsteriskMap)sourceSinkMap).load(sourceAndSinkFile);
        }
        this.sources = new Sources();
        this.sinks = new Sinks();
        this.sourcesAndSinksRequested = false;
        this.apkFile = apkFile;
        this.classes = SootHelper.getScene(apkFile).getApplicationClasses();
    }

    private void getSourcesAndSinks() {
        if (this.apkFile == null) {
            Log.error(NO_APK_MSG);
            return;
        }
        if (!this.sourcesAndSinksRequested) {
            App app = Helper.createApp(this.apkFile);
            for (SootClass sc : this.classes) {
                if (!sc.isConcrete()) continue;
                for (SootMethod sm : sc.getMethods()) {
                    Body b;
                    if (!sm.isConcrete() || (b = sm.retrieveActiveBody()) == null) continue;
                    for (Unit u : b.getUnits()) {
                        Serializable item;
                        Stmt ss;
                        if (!(u instanceof Stmt) || !(ss = (Stmt)u).containsInvokeExpr()) continue;
                        Reference ref = null;
                        String invokeStr = ss.getInvokeExpr().toString();
                        if (sourceSinkMap.get(invokeStr) != null) {
                            ref = new Reference();
                            ref.setStatement(Helper.createStatement(u.toString()));
                            ref.setMethod(sm.toString());
                            ref.setClassname(sc.toString());
                            ref.setApp(app);
                            if (sourceSinkMap.get(invokeStr).contains("_SOURCE_")) {
                                item = new Source();
                                ((Source)item).setReference(ref);
                                this.sources.getSource().add((Source)item);
                                altRef = this.getAlternativeReference(ss, ref);
                                if (altRef != null) {
                                    item = new Source();
                                    ((Source)item).setReference(altRef);
                                    this.sources.getSource().add((Source)item);
                                }
                            } else if (sourceSinkMap.get(invokeStr).contains("_SINK_")) {
                                item = new Sink();
                                ((Sink)item).setReference(ref);
                                this.sinks.getSink().add((Sink)item);
                                altRef = this.getAlternativeReference(ss, ref);
                                if (altRef != null) {
                                    item = new Sink();
                                    ((Sink)item).setReference(altRef);
                                    this.sinks.getSink().add((Sink)item);
                                }
                            }
                        }
                        if ((invokeStr = this.getAlternativeInvokeStr(ss)) == null || sourceSinkMap.get(invokeStr) == null) continue;
                        if (ref == null) {
                            ref = new Reference();
                            ref.setStatement(Helper.createStatement(u.toString()));
                            ref.setMethod(sm.toString());
                            ref.setClassname(sc.toString());
                            ref.setApp(app);
                            if (sourceSinkMap.get(invokeStr).contains("_SOURCE_")) {
                                item = new Source();
                                ((Source)item).setReference(ref);
                                this.sources.getSource().add((Source)item);
                            } else if (sourceSinkMap.get(invokeStr).contains("_SINK_")) {
                                item = new Sink();
                                ((Sink)item).setReference(ref);
                                this.sinks.getSink().add((Sink)item);
                            }
                        }
                        if ((ref = this.getAlternativeReference(ss, ref)) == null) continue;
                        if (sourceSinkMap.get(invokeStr).contains("_SOURCE_")) {
                            item = new Source();
                            ((Source)item).setReference(ref);
                            this.sources.getSource().add((Source)item);
                            continue;
                        }
                        if (!sourceSinkMap.get(invokeStr).contains("_SINK_")) continue;
                        item = new Sink();
                        ((Sink)item).setReference(ref);
                        this.sinks.getSink().add((Sink)item);
                    }
                }
            }
            this.sourcesAndSinksRequested = true;
        }
    }

    private String getAlternativeInvokeStr(Stmt ss) {
        if (ss.containsInvokeExpr()) {
            String newClass = ss.getInvokeExpr().getMethod().getDeclaringClass().toString();
            String oldClass = ss.getInvokeExpr().toString();
            try {
                oldClass = oldClass.substring(oldClass.indexOf(60) + 1, oldClass.indexOf(58));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            if (!newClass.equals(oldClass)) {
                return ss.toString().replaceFirst(oldClass, newClass);
            }
        }
        return null;
    }

    private Reference getAlternativeReference(Stmt ss, Reference ref) {
        if (ss.containsInvokeExpr()) {
            String newClass = ss.getInvokeExpr().getMethod().getDeclaringClass().toString();
            String oldClass = ref.getStatement().getStatementgeneric();
            try {
                oldClass = oldClass.substring(0, oldClass.indexOf(58));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            if (!newClass.equals(oldClass)) {
                Reference newRef = Helper.copy(ref);
                newRef.setStatement(Helper.createStatement(ref.getStatement().getStatementfull().replaceFirst(oldClass, newClass)));
                return newRef;
            }
        }
        return null;
    }

    public Sources getSources() {
        this.getSourcesAndSinks();
        return this.sources;
    }

    public Sinks getSinks() {
        this.getSourcesAndSinks();
        return this.sinks;
    }

    static {
        sourceSinkMap = null;
    }
}

