/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.Log;
import de.foellix.aql.LogSilencer;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.datastructure.handler.QueryHandler;
import de.foellix.aql.datastructure.query.Query;
import de.foellix.aql.helper.CLIHelper;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.BackupAndReset;
import de.foellix.aql.system.IAnswerAvailable;
import de.foellix.aql.system.IProgressChanged;
import de.foellix.aql.system.Options;
import de.foellix.aql.system.ProgressHandler;
import de.foellix.aql.system.TaskCreator;
import de.foellix.aql.system.TaskHooks;
import de.foellix.aql.system.TaskScheduler;
import de.foellix.aql.system.exceptions.CancelExecutionException;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.transformations.RulesHandler;
import de.foellix.aql.ui.cli.AnswerToConsole;
import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.Storage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.fusesource.jansi.Ansi;
import org.slf4j.LoggerFactory;

public class AQLSystem {
    private final Options options;
    private final TaskScheduler taskScheduler;
    private final TaskCreator taskCreator;
    private final ProgressHandler progressHandler;
    private Map<String, String> globalVariables;
    private final TaskHooks taskHooksBefore;
    private final TaskHooks taskHooksAfter;
    private final List<IAnswerAvailable> answerReceivers;
    private final List<IProgressChanged> progressListener;
    private boolean wait;
    private Collection<Object> lastAnswer;
    private Lock systemLock;
    private String currentInputQuery;
    private double time;

    public AQLSystem() {
        this(new Options());
    }

    public AQLSystem(Options options) {
        try (LogSilencer s = new LogSilencer();){
            LoggerFactory.getLogger(AQLSystem.class);
        }
        CLIHelper.evaluateConfig(options.getConfig().getAbsolutePath());
        CLIHelper.evaluateRules(options.getRulesAsString());
        this.options = options;
        FileHelper.initializeFileSystem();
        if (options.getResetOutputDirectories()) {
            BackupAndReset.resetOutputDirectories();
        }
        this.taskScheduler = new TaskScheduler(this);
        this.taskCreator = new TaskCreator(this);
        this.progressHandler = new ProgressHandler(this);
        this.globalVariables = new HashMap<String, String>();
        this.taskHooksBefore = new TaskHooks();
        this.taskHooksAfter = new TaskHooks();
        this.answerReceivers = new LinkedList<IAnswerAvailable>();
        this.progressListener = new LinkedList<IProgressChanged>();
        this.wait = false;
        this.lastAnswer = null;
        this.systemLock = new ReentrantLock();
        if (Log.logIt(4)) {
            this.answerReceivers.add(new AnswerToConsole());
        }
    }

    public void query(String query) {
        this.systemLock.lock();
        this.time = System.currentTimeMillis();
        this.lastAnswer = null;
        Log.reset();
        this.currentInputQuery = Helper.replaceAllWhiteSpaceChars(query, true);
        Log.msg(Ansi.ansi().bold().fg(Ansi.Color.GREEN).a("Starting: " + this.currentInputQuery), 0);
        Query queryObj = QueryHandler.parseQuery(query);
        if (queryObj != null) {
            String parsed = queryObj.toString();
            Log.msg("Parsed:" + (parsed.contains("\n") ? (char)'\n' : ' ') + parsed, 4);
            try {
                this.taskScheduler.start(this.taskCreator.query(queryObj));
            }
            catch (CancelExecutionException e) {
                Log.error(e.getMessage());
            }
        } else {
            Log.error("Query could not be parsed: " + query);
        }
        this.systemLock.unlock();
    }

    public Collection<Object> queryAndWait(String query) {
        this.wait = true;
        new Thread(() -> this.query(query)).start();
        while (this.wait) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return this.lastAnswer;
    }

    public void queryCanceled(int status, String message) {
        this.time = ((double)System.currentTimeMillis() - this.time) / 1000.0;
        this.wait = false;
        this.taskScheduler.cancel();
        Log.error("Canceled (after " + this.time + "s): " + this.currentInputQuery + "\nReason: " + message);
        if (GUI.started && Boolean.parseBoolean(Storage.getInstance().getGuiConfigProperty("confirmQueryEnded"))) {
            GUI.alert(true, "Error", "Canceled (after " + this.time + "s): " + Helper.shorten(Helper.autoformat(this.currentInputQuery), 5), "Reason: " + message);
        }
        for (IAnswerAvailable receiver : this.answerReceivers) {
            receiver.answerAvailable(new Answer(), status);
        }
    }

    protected void queryFinished(Task task, int status) {
        this.time = ((double)System.currentTimeMillis() - this.time) / 1000.0;
        this.lastAnswer = new ArrayList<Object>();
        for (Task child : task.getChildren()) {
            this.lastAnswer.add(child.getTaskAnswer().getAnswer());
        }
        this.wait = false;
        this.createStats(task);
        if (GUI.started && Boolean.parseBoolean(Storage.getInstance().getGuiConfigProperty("confirmQueryEnded"))) {
            GUI.alert(false, "Done", "Successfully finished (after " + this.time + "s)!", "Query:\n" + Helper.shorten(Helper.autoformat(this.currentInputQuery), 5));
        }
        Log.msg(Ansi.ansi().bold().fg(Ansi.Color.GREEN).a("Finished (after " + this.time + "s): " + this.currentInputQuery), 0);
        for (Object answer : this.lastAnswer) {
            if (answer instanceof Answer) {
                Answer castedAnswer = (Answer)answer;
                File xmlFile = null;
                if (this.options.getStoreAnswers()) {
                    xmlFile = FileHelper.makeUnique(new File(FileHelper.getAnswersDirectory(), "answer_" + Helper.getDate() + "-0.xml"));
                    AnswerHandler.createXML(castedAnswer, xmlFile);
                }
                Log.msg(Ansi.ansi().bold().a("***** Answer " + (String)(this.options.getStoreAnswers() ? "(" + xmlFile.getAbsolutePath() + ") " : "") + "*****\n").reset().a(Helper.toString(castedAnswer)), 5);
            }
            for (IAnswerAvailable receiver : this.answerReceivers) {
                receiver.answerAvailable(answer, status);
            }
        }
    }

    private void createStats(Task task) {
        StringBuilder sb = new StringBuilder("*** Statistics ***\n");
        sb.append("- Status: " + task.getStatus() + "\n\n");
        sb.append("- Query: " + this.currentInputQuery + "\n\n");
        sb.append("- Answerfile" + (this.lastAnswer.size() <= 1 ? ": " : "s: "));
        for (Task child : task.getChildren()) {
            sb.append((this.lastAnswer.size() <= 1 ? "" : "\n\t- ") + child.getTaskAnswer().getAnswerFile().getAbsolutePath());
        }
        sb.append("\n\n");
        sb.append("- Time: " + this.time + "s (now is " + Helper.getDate(System.currentTimeMillis(), "dd.MM.yyyy HH:mm:ss.SSS") + ")\n\n");
        try {
            Files.write(task.getTaskAnswer().getAnswerFile().toPath(), sb.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Log.error("Could not write statistics file \"" + task.getTaskAnswer().getAnswerFile().getAbsolutePath() + "\"." + Log.getExceptionAppendix(e));
        }
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public TaskCreator getTaskCreator() {
        return this.taskCreator;
    }

    public ProgressHandler getProgressHandler() {
        return this.progressHandler;
    }

    public List<IAnswerAvailable> getAnswerReceivers() {
        return this.answerReceivers;
    }

    public List<IProgressChanged> getProgressListener() {
        return this.progressListener;
    }

    public TaskHooks getTaskHooksBefore() {
        return this.taskHooksBefore;
    }

    public TaskHooks getTaskHooksAfter() {
        return this.taskHooksAfter;
    }

    public Options getOptions() {
        this.options.setConfig(ConfigHandler.getInstance().getConfigFile());
        this.options.setRules(RulesHandler.getInstance().getRulesFiles());
        return this.options;
    }

    public void setGlobalVariables(Map<String, String> globalVariables) {
        this.globalVariables = globalVariables;
    }

    public Map<String, String> getGlobalVariables() {
        return this.globalVariables;
    }

    public boolean isRunning() {
        if (this.wait) {
            return true;
        }
        if (this.systemLock.tryLock()) {
            this.systemLock.unlock();
            return false;
        }
        return true;
    }
}

