/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.Log;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.helper.ZipHelper;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.ui.gui.viewer.web.ViewerWeb;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BackupAndReset {
    public static boolean backup() {
        return BackupAndReset.backup(Storage.DEFAULT_STORAGE_DIRECTORY);
    }

    public static boolean backup(File storageDirectory) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd_MM_yyyy-HH_mm_ss");
        Date currentTime = new Date();
        try {
            File zipFile = new File("data/storage_backup_" + formatter.format(currentTime) + ".zip");
            ZipHelper.zip(storageDirectory, zipFile);
            Log.msg("Successfully backuped storage to: " + zipFile.getAbsolutePath(), 4);
            return true;
        }
        catch (IOException e) {
            Log.error("Something went wrong while backing up the storage: " + e.getMessage());
            return false;
        }
    }

    public static void reset() {
        BackupAndReset.reset(Storage.DEFAULT_STORAGE_DIRECTORY);
    }

    public static void reset(File storageDirectory) {
        boolean failed = false;
        if (storageDirectory.exists() && !FileHelper.deleteDir(storageDirectory)) {
            failed = true;
        }
        Storage.getInstance().reset();
        storageDirectory.mkdir();
        if (failed) {
            Log.warning("Could not completely reset storage!");
        } else {
            Log.msg("Successfully reset storage!", 4);
        }
    }

    public static void resetOutputDirectories() {
        if (FileHelper.getTempDirectory().exists()) {
            FileHelper.deleteDir(FileHelper.getTempDirectory());
        }
        FileHelper.getTempDirectory().mkdir();
        if (ViewerWeb.TEMP_DIRECTORY.exists()) {
            FileHelper.deleteDir(ViewerWeb.TEMP_DIRECTORY);
        }
        ViewerWeb.TEMP_DIRECTORY.mkdir();
        if (FileHelper.getAnswersDirectory().exists()) {
            FileHelper.deleteDir(FileHelper.getAnswersDirectory());
        }
        FileHelper.getAnswersDirectory().mkdir();
    }
}

