/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.datastructure.query.DefaultQuestion;
import de.foellix.aql.datastructure.query.OperatorQuestion;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.datastructure.query.QuestionReference;
import de.foellix.aql.datastructure.query.QuestionString;
import de.foellix.aql.helper.FileHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DirectoryResolver {
    private static final int MODE_IN = 0;
    private static final int MODE_FROM = 1;
    private static final int MODE_TO = 2;

    protected static List<Question> resolveDirectoryReference(List<Question> questions) {
        ArrayList<Question> resolvedQuestions = new ArrayList<Question>();
        for (Question question : questions) {
            Question castedQuestion;
            if (question instanceof DefaultQuestion) {
                castedQuestion = (DefaultQuestion)question;
                boolean changed = false;
                if (((DefaultQuestion)castedQuestion).getFrom() == null && ((DefaultQuestion)castedQuestion).getTo() == null && ((DefaultQuestion)castedQuestion).getIn() != null && ((DefaultQuestion)castedQuestion).getIn().getApp().isComplete(true)) {
                    List<File> files;
                    File temp = new File(((DefaultQuestion)castedQuestion).getIn().getApp().toStringInAnswer(false));
                    if (temp.getName().contains("*") && !(files = FileHelper.findFilesWithAsteriskInParent(temp)).isEmpty()) {
                        resolvedQuestions.addAll(DirectoryResolver.createResolvedQuestions((DefaultQuestion)castedQuestion, files, 0));
                        changed = true;
                    }
                    if (temp.exists() && temp.isDirectory()) {
                        resolvedQuestions.addAll(DirectoryResolver.createResolvedQuestions((DefaultQuestion)castedQuestion, Arrays.asList(temp.listFiles()), 0));
                        changed = true;
                    }
                } else {
                    ArrayList<Question> tempResolvedQuestions = new ArrayList<Question>();
                    if (((DefaultQuestion)castedQuestion).getFrom() != null && ((DefaultQuestion)castedQuestion).getFrom().getApp().isComplete(true)) {
                        List<File> list;
                        File temp = new File(((DefaultQuestion)castedQuestion).getFrom().getApp().toStringInAnswer(false));
                        if (temp.getName().contains("*") && !(list = FileHelper.findFilesWithAsteriskInParent(temp)).isEmpty()) {
                            tempResolvedQuestions.addAll(DirectoryResolver.createResolvedQuestions((DefaultQuestion)castedQuestion, list, 1));
                            changed = true;
                        }
                        if (temp.exists() && temp.isDirectory()) {
                            tempResolvedQuestions.addAll(DirectoryResolver.createResolvedQuestions((DefaultQuestion)castedQuestion, Arrays.asList(temp.listFiles()), 1));
                            changed = true;
                        }
                    } else {
                        tempResolvedQuestions.add(castedQuestion);
                    }
                    for (DefaultQuestion defaultQuestion : tempResolvedQuestions) {
                        if (defaultQuestion.getTo() != null && defaultQuestion.getTo().getApp().isComplete(true)) {
                            List<File> files;
                            File temp = new File(defaultQuestion.getTo().getApp().toStringInAnswer(false));
                            if (temp.getName().contains("*") && !(files = FileHelper.findFilesWithAsteriskInParent(temp)).isEmpty()) {
                                resolvedQuestions.addAll(DirectoryResolver.createResolvedQuestions(defaultQuestion, files, 2));
                                changed = true;
                            }
                            if (!temp.exists() || !temp.isDirectory()) continue;
                            resolvedQuestions.addAll(DirectoryResolver.createResolvedQuestions(defaultQuestion, Arrays.asList(temp.listFiles()), 2));
                            changed = true;
                            continue;
                        }
                        if (!changed) continue;
                        resolvedQuestions.add(defaultQuestion);
                    }
                }
                if (changed) continue;
                resolvedQuestions.add(question);
                continue;
            }
            if (question instanceof OperatorQuestion) {
                castedQuestion = (OperatorQuestion)question;
                ((OperatorQuestion)castedQuestion).setQuestions(DirectoryResolver.resolveDirectoryReference(((OperatorQuestion)castedQuestion).getQuestions()));
            } else {
                DirectoryResolver.resolveDirectoryReference(question);
            }
            resolvedQuestions.add(question);
        }
        questions = null;
        return resolvedQuestions;
    }

    private static void resolveDirectoryReference(Question question) {
        if (question instanceof OperatorQuestion) {
            OperatorQuestion castedQuestion = (OperatorQuestion)question;
            castedQuestion.setQuestions(DirectoryResolver.resolveDirectoryReference(castedQuestion.getQuestions()));
        } else {
            for (Question child : question.getChildren()) {
                DirectoryResolver.resolveDirectoryReference(child);
            }
        }
    }

    private static List<DefaultQuestion> createResolvedQuestions(DefaultQuestion question, List<File> files, int mode) {
        ArrayList<DefaultQuestion> createdQuestions = new ArrayList<DefaultQuestion>();
        for (File file : files) {
            DefaultQuestion copy = question.copy();
            QuestionReference resolvedReference = mode == 1 ? question.getFrom().copy() : (mode == 2 ? question.getTo().copy() : question.getIn().copy());
            resolvedReference.setApp(new QuestionString(file.getAbsolutePath()));
            if (mode == 1) {
                copy.setFrom(resolvedReference);
            } else if (mode == 2) {
                copy.setTo(resolvedReference);
            } else {
                copy.setIn(resolvedReference);
            }
            if (copy.getFrom() != null && copy.getTo() != null && copy.getFrom().toString().equals(copy.getTo().toString())) continue;
            createdQuestions.add(copy);
        }
        return createdQuestions;
    }
}

