/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.transformations.RulesHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Options {
    public static final int TIMEOUT_MODE_MAX = 1;
    public static final int TIMEOUT_MODE_MIN = 2;
    public static final int TIMEOUT_MODE_OVERRIDE = 3;
    public static final boolean DEFAULT_OPTION_STORE_ANSWERS = true;
    public static final boolean DEFAULT_OPTION_RETRY = true;
    public static final long DEFAULT_OPTION_TIMEOUT = -1L;
    public static final int DEFAULT_OPTION_TIMEOUT_MODE = 1;
    public static final boolean DEFAULT_OPTION_RESET_OUTPUT_DIRECTORIES = false;
    public static final boolean DEFAULT_OPTION_FILENAME_BASED_ANSWER_HASH = false;
    public static final boolean DEFAULT_OPTION_SHOW_CONFIG_WIZARD = false;
    public static final boolean DEFAULT_OPTION_DRAW_GRAPHS = false;
    public static final boolean DEFAULT_OPTION_VIEW_ANSWER = false;
    public static final boolean DEFAULT_OPTION_NO_SPLASH_SCREEN = false;
    private File config = null;
    private List<File> rules = null;
    private boolean storeAnswers = true;
    private boolean retry = true;
    private long timeout = -1L;
    private int timeoutMode = 1;
    private boolean resetOutputDirectories = false;
    private boolean filenameBasedAnswersHash = false;
    private boolean showConfigWizard = false;
    private boolean drawGraphs = false;
    private boolean viewAnswer = false;
    private boolean noSplashScreen = false;

    public File getConfig() {
        if (this.config == null) {
            this.config = ConfigHandler.getInstance().getConfigFile();
        }
        return this.config;
    }

    public List<File> getRules() {
        if (this.rules == null) {
            this.rules = RulesHandler.getInstance().getRulesFiles();
        }
        return this.rules;
    }

    public String getRulesAsString() {
        List<File> rules = this.getRules();
        StringBuilder sb = new StringBuilder();
        for (File ruleFile : rules) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append(ruleFile.getAbsolutePath());
        }
        return sb.toString();
    }

    public boolean getStoreAnswers() {
        return this.storeAnswers;
    }

    public boolean getRetry() {
        return this.retry;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getTimeoutMode() {
        return this.timeoutMode;
    }

    public boolean getResetOutputDirectories() {
        return this.resetOutputDirectories;
    }

    public boolean getFilenameBasedAnswersHash() {
        return this.filenameBasedAnswersHash;
    }

    public Options setConfig(File config) {
        this.config = config;
        return this;
    }

    public Options setRules(File rules) {
        ArrayList<File> temp = new ArrayList<File>();
        temp.add(rules);
        return this.setRules(temp);
    }

    public Options setRules(List<File> rules) {
        this.rules = rules;
        return this;
    }

    public Options setStoreAnswers(boolean storeAnswers) {
        this.storeAnswers = storeAnswers;
        return this;
    }

    public Options setRetry(boolean retry) {
        this.retry = retry;
        return this;
    }

    public Options setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public Options setTimeoutMode(int timeoutMode) {
        this.timeoutMode = timeoutMode;
        return this;
    }

    public Options setResetOutputDirectories(boolean resetOutputDirectories) {
        this.resetOutputDirectories = resetOutputDirectories;
        return this;
    }

    public Options setFilenameBasedAnswersHash(boolean filenameBasedAnswersHash) {
        this.filenameBasedAnswersHash = filenameBasedAnswersHash;
        return this;
    }

    public boolean getShowConfigWizard() {
        return this.showConfigWizard;
    }

    public boolean getDrawGraphs() {
        return this.drawGraphs;
    }

    public boolean getViewAnswer() {
        return this.viewAnswer;
    }

    public boolean getNoSplashScreen() {
        return this.noSplashScreen;
    }

    public Options setShowConfigWizard(boolean showConfigWizard) {
        this.showConfigWizard = showConfigWizard;
        return this;
    }

    public Options setDrawGraphs(boolean drawGraphs) {
        this.drawGraphs = drawGraphs;
        return this;
    }

    public Options setViewAnswer(boolean viewAnswer) {
        this.viewAnswer = viewAnswer;
        return this;
    }

    public Options setNoSplashScreen(boolean noSplashScreen) {
        this.noSplashScreen = noSplashScreen;
        return this;
    }
}

