/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.Log;
import de.foellix.aql.system.ProcessWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.fusesource.jansi.Ansi;

public class ProcessOutputPipe
extends Thread {
    private InputStream inputStream;
    private ProcessWrapper pw;
    private boolean errorStream;
    private boolean canceled;

    public ProcessOutputPipe(InputStream inputStream, ProcessWrapper pw, boolean errorStream) {
        this.inputStream = inputStream;
        this.pw = pw;
        this.errorStream = errorStream;
        this.canceled = false;
    }

    @Override
    public void run() {
        try (BufferedReader outputStream = new BufferedReader(new InputStreamReader(this.inputStream));){
            while (!this.canceled || outputStream.ready()) {
                if (!outputStream.ready()) {
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        if (!this.canceled) continue;
                        break;
                    }
                }
                String line = outputStream.readLine();
                this.pw.addOutputLine(line);
                if (this.errorStream) {
                    Log.msg(Ansi.ansi().fg(Ansi.Color.RED).a("Process (" + this.pw.getPID() + ") error: " + line), 6);
                    continue;
                }
                Log.msg("Process (" + this.pw.getPID() + ") output: " + line, 6);
            }
        }
        catch (IOException e) {
            Log.msg("Could not read the " + (this.errorStream ? "error" : "default") + " output of process: " + this.pw.getPID() + Log.getExceptionAppendix(e), 6);
        }
    }

    @Override
    public void interrupt() {
        this.canceled = true;
        super.interrupt();
    }

    public void done() {
        this.canceled = true;
    }
}

