/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.Log;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.ProcessOutputPipe;
import de.foellix.aql.system.ProcessWrapperRegistry;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.ToolTask;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ProcessWrapper {
    private final Process process;
    private final long pid;
    private ProcessOutputPipe tOut;
    private ProcessOutputPipe tErr;
    private boolean canceled;
    private Lock lock;
    private List<String> output;

    public ProcessWrapper(Process process) {
        this(null, process);
    }

    public ProcessWrapper(Task task, Process process) {
        ProcessWrapperRegistry.getInstance().register(this);
        this.process = process;
        this.pid = Helper.getPid(process);
        this.canceled = false;
        this.lock = new ReentrantLock();
        this.output = null;
        if (task != null) {
            task.getTaskInfo().setData("%PID%", String.valueOf(this.pid));
            if (task instanceof ToolTask) {
                this.output = new LinkedList<String>();
            }
        }
    }

    public int waitFor() {
        try {
            int returnValue;
            this.tOut = new ProcessOutputPipe(this.process.getInputStream(), this, false);
            this.tErr = new ProcessOutputPipe(this.process.getErrorStream(), this, true);
            this.tOut.start();
            this.tErr.start();
            try {
                returnValue = this.process.waitFor();
            }
            catch (InterruptedException e) {
                returnValue = 1;
            }
            this.tOut.done();
            this.tErr.done();
            this.lock.lock();
            try {
                if (this.tOut.isAlive()) {
                    this.tOut.join();
                }
                if (this.tErr.isAlive()) {
                    this.tErr.join();
                }
            }
            catch (InterruptedException e) {
                Log.msg("Output forwarding was interrupted!", 6);
            }
            this.lock.unlock();
            int n = returnValue;
            return n;
        }
        finally {
            ProcessWrapperRegistry.getInstance().unregister(this);
        }
    }

    public boolean cancel() {
        this.lock.lock();
        if (this.process.isAlive()) {
            this.process.destroy();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.error("Someting went wrong while killing processes!" + Log.getExceptionAppendix(e));
            }
            if (this.process.isAlive()) {
                this.process.destroyForcibly();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Log.error("Someting went wrong while killing processes forcibly!" + Log.getExceptionAppendix(e));
                }
                if (this.process.isAlive()) {
                    Log.warning("Process " + this.pid + " could not be canceled! Consider canceling manually!");
                }
            }
        }
        if (this.tOut.isAlive()) {
            this.tOut.interrupt();
        }
        if (this.tErr.isAlive()) {
            this.tErr.interrupt();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Log.error("Someting went wrong while canceling output pipes!" + Log.getExceptionAppendix(e));
        }
        this.canceled = true;
        this.lock.unlock();
        return !this.process.isAlive();
    }

    public boolean isAlive() {
        return this.process.isAlive();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public long getPID() {
        return this.pid;
    }

    public List<String> getOutput() {
        return this.output;
    }

    protected void addOutputLine(String line) {
        if (this.output != null) {
            this.output.add(line);
        }
    }
}

