/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.Log;
import de.foellix.aql.system.ProcessWrapper;
import java.util.HashSet;
import java.util.Set;

public class ProcessWrapperRegistry {
    private Set<ProcessWrapper> processWrappers = new HashSet<ProcessWrapper>();
    private static ProcessWrapperRegistry instance = new ProcessWrapperRegistry();

    private ProcessWrapperRegistry() {
    }

    public static ProcessWrapperRegistry getInstance() {
        return instance;
    }

    public void register(ProcessWrapper processWrapper) {
        this.processWrappers.add(processWrapper);
    }

    public void unregister(ProcessWrapper processWrapper) {
        this.processWrappers.remove(processWrapper);
    }

    public void reportAlive() {
        int counter = 0;
        for (ProcessWrapper processWrapper : this.processWrappers) {
            if (!processWrapper.isAlive()) continue;
            ++counter;
        }
        Log.msg("Processes alive: " + counter + "/" + this.processWrappers.size(), 4);
    }

    public void cancelAll() {
        for (ProcessWrapper processWrapper : this.processWrappers) {
            if (processWrapper.isCanceled()) continue;
            processWrapper.cancel();
        }
    }
}

