/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.Log;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.query.DefaultQuestion;
import de.foellix.aql.datastructure.query.FilterQuestion;
import de.foellix.aql.datastructure.query.IStringOrQuestion;
import de.foellix.aql.datastructure.query.LoadingQuestion;
import de.foellix.aql.datastructure.query.OperatorQuestion;
import de.foellix.aql.datastructure.query.Query;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.datastructure.query.QuestionReference;
import de.foellix.aql.datastructure.query.StringOrQuestionPair;
import de.foellix.aql.helper.AppInfo;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.AQLSystem;
import de.foellix.aql.system.DirectoryResolver;
import de.foellix.aql.system.LoadAnswerTool;
import de.foellix.aql.system.ToolSelector;
import de.foellix.aql.system.defaulttools.operators.DefaultOperator;
import de.foellix.aql.system.exceptions.CancelExecutionException;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.ConverterTask;
import de.foellix.aql.system.task.ConverterTaskInfo;
import de.foellix.aql.system.task.FilterOperatorTask;
import de.foellix.aql.system.task.FilterOperatorTaskInfo;
import de.foellix.aql.system.task.LoadAnswerTask;
import de.foellix.aql.system.task.LoadAnswerTaskInfo;
import de.foellix.aql.system.task.OperatorTask;
import de.foellix.aql.system.task.OperatorTaskInfo;
import de.foellix.aql.system.task.PlaceholderTask;
import de.foellix.aql.system.task.PreprocessorTask;
import de.foellix.aql.system.task.PreprocessorTaskInfo;
import de.foellix.aql.system.task.RootTask;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskAnswer;
import de.foellix.aql.system.task.TaskInfo;
import de.foellix.aql.system.task.ToolTask;
import de.foellix.aql.system.task.ToolTaskInfo;
import de.foellix.aql.transformations.QueryTransformer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class TaskCreator {
    private final AQLSystem parent;
    private Query currentQuery;
    private Task currentTask;

    public TaskCreator(AQLSystem aqlSystem) {
        this.parent = aqlSystem;
    }

    public Task query(Query query) throws CancelExecutionException {
        return this.query(query, true);
    }

    public Task query(Query query, boolean initialQuery) throws CancelExecutionException {
        this.currentQuery = query;
        this.currentTask = new RootTask(this);
        if (initialQuery) {
            query.setQuestions(DirectoryResolver.resolveDirectoryReference(query.getQuestions()));
            String resolved = query.toString();
            Log.msg("Resolved:" + (resolved.contains("\n") ? (char)'\n' : ' ') + resolved, 5);
            boolean changed = false;
            for (Question question : query.getQuestions()) {
                if (!QueryTransformer.transform(query, question)) continue;
                changed = true;
            }
            if (changed) {
                resolved = Helper.replaceCustomVariables(query.toString(), this.parent.getGlobalVariables());
                Log.msg("Transformed:" + (resolved.contains("\n") ? (char)'\n' : ' ') + resolved, 5);
            }
        }
        for (Question question : query.getQuestions()) {
            this.currentTask.addChild(this.getTask(question));
        }
        if (!initialQuery) {
            this.parent.getTaskScheduler().changed(this.currentTask);
        }
        return this.currentTask;
    }

    private Task getTask(Question question) throws CancelExecutionException {
        Task task = Storage.getInstance().getData().getTaskFromQuestionTaskMap(question);
        if (task == null || task instanceof PlaceholderTask) {
            if (question.isComplete(false)) {
                Task newTask = null;
                if (question instanceof DefaultQuestion) {
                    newTask = this.getTask((DefaultQuestion)question);
                } else if (question instanceof FilterQuestion) {
                    newTask = this.getTask((FilterQuestion)question);
                } else if (question instanceof OperatorQuestion) {
                    newTask = this.getTask((OperatorQuestion)question);
                } else if (question instanceof LoadingQuestion) {
                    newTask = this.getTask((LoadingQuestion)question);
                } else {
                    Log.error("Unknown question type: " + question.getClass().getSimpleName());
                }
                if (task instanceof PlaceholderTask) {
                    task.replaceByTask(newTask);
                }
                task = newTask;
            } else if (task == null) {
                task = new PlaceholderTask(this);
            }
            this.appendPreprocessors(task, question);
            Storage.getInstance().getData().putIntoQuestionTaskMap(question, task);
        }
        for (Question child : question.getChildren(false)) {
            if (task instanceof ConverterTask) {
                if (task.getChildren().size() == 1) {
                    task.getChildren().iterator().next().addChild(this.getTask(child));
                    continue;
                }
                Log.warning("Invalid converter task with multiple children detected.");
                task.addChild(this.getTask(child));
                continue;
            }
            task.addChild(this.getTask(child));
        }
        return task;
    }

    private Task getTask(DefaultQuestion question) throws CancelExecutionException {
        Tool converter;
        AppInfo appInfo;
        Object apkFile;
        Tool tool = ToolSelector.selectAnalysisTool(question);
        if (tool == null) {
            String errorMsg = "No appropriate tool could be found to answer the following question: " + question;
            this.parent.queryCanceled(-4, errorMsg);
            throw new CancelExecutionException(errorMsg);
        }
        ToolTaskInfo taskInfo = new ToolTaskInfo();
        this.setAlwaysAttributes(taskInfo, tool);
        if (question.getIn() != null) {
            if (question.getIn().getApp() != null && question.getIn().getApp().isComplete(true) && question.getIn().isComplete(true)) {
                apkFile = new File(question.getIn().getApp().toStringInAnswer(false));
                if (!((File)apkFile).exists()) {
                    String errorMsg = ((File)apkFile).getAbsolutePath() + " does not exist but was used in: " + question;
                    this.parent.queryCanceled(-5, errorMsg);
                    throw new CancelExecutionException(errorMsg);
                }
                appInfo = new AppInfo((File)apkFile);
                taskInfo.setData("%APP_APK_IN%", appInfo.getApkFile().getAbsolutePath());
                taskInfo.setData("%APP_APK_IN_FILENAME%", appInfo.getFilename());
                taskInfo.setData("%APP_APK_IN_NAME%", appInfo.getAppName());
                taskInfo.setData("%APP_APK_IN_PACKAGE%", appInfo.getPkgName());
            }
            if (question.getIn().getStatement() != null && question.getIn().getStatement().isComplete(true)) {
                taskInfo.setData("%STATEMENT_IN%", question.getIn().getStatement().toStringInAnswer(false));
            }
            taskInfo.setData("%LINENUMBER_IN%", String.valueOf(question.getIn().getLineNumber()).toString());
            if (question.getIn().getMethod() != null && question.getIn().getMethod().isComplete(true)) {
                taskInfo.setData("%METHOD_IN%", question.getIn().getMethod().toStringInAnswer(false));
            }
            if (question.getIn().getClassname() != null && question.getIn().getClassname().isComplete(true)) {
                taskInfo.setData("%CLASS_IN%", question.getIn().getClassname().toStringInAnswer(false));
            }
        }
        if (question.getFrom() != null) {
            if (question.getFrom().getApp() != null && question.getFrom().getApp().isComplete(true) && question.getFrom().isComplete(true)) {
                apkFile = new File(question.getFrom().getApp().toStringInAnswer(false));
                appInfo = new AppInfo((File)apkFile);
                taskInfo.setData("%APP_APK_FROM%", appInfo.getApkFile().getAbsolutePath());
                taskInfo.setData("%APP_APK_FROM_FILENAME%", appInfo.getFilename());
                taskInfo.setData("%APP_APK_FROM_NAME%", appInfo.getAppName());
                taskInfo.setData("%APP_APK_FROM_PACKAGE%", appInfo.getPkgName());
            }
            if (question.getFrom().getStatement() != null && question.getIn().getStatement().isComplete(true)) {
                taskInfo.setData("%STATEMENT_FROM%", question.getFrom().getStatement().toStringInAnswer(false));
            }
            taskInfo.setData("%LINENUMBER_FROM%", String.valueOf(question.getFrom().getLineNumber()).toString());
            if (question.getFrom().getMethod() != null && question.getIn().getMethod().isComplete(true)) {
                taskInfo.setData("%METHOD_FROM%", question.getFrom().getMethod().toStringInAnswer(false));
            }
            if (question.getFrom().getClassname() != null && question.getIn().getClassname().isComplete(true)) {
                taskInfo.setData("%CLASS_FROM%", question.getFrom().getClassname().toStringInAnswer(false));
            }
        }
        if (question.getTo() != null) {
            if (question.getTo().getApp() != null && question.getTo().getApp().isComplete(true) && question.getTo().isComplete(true)) {
                apkFile = new File(question.getTo().getApp().toStringInAnswer(false));
                appInfo = new AppInfo((File)apkFile);
                taskInfo.setData("%APP_APK_TO%", appInfo.getApkFile().getAbsolutePath());
                taskInfo.setData("%APP_APK_TO_FILENAME%", appInfo.getFilename());
                taskInfo.setData("%APP_APK_TO_NAME%", appInfo.getAppName());
                taskInfo.setData("%APP_APK_TO_PACKAGE%", appInfo.getPkgName());
            }
            if (question.getTo().getStatement() != null && question.getIn().getStatement().isComplete(true)) {
                taskInfo.setData("%STATEMENT_TO%", question.getTo().getStatement().toStringInAnswer(false));
            }
            taskInfo.setData("%LINENUMBER_TO%", String.valueOf(question.getTo().getLineNumber()).toString());
            if (question.getTo().getMethod() != null && question.getIn().getMethod().isComplete(true)) {
                taskInfo.setData("%METHOD_TO%", question.getTo().getMethod().toStringInAnswer(false));
            }
            if (question.getTo().getClassname() != null && question.getIn().getClassname().isComplete(true)) {
                taskInfo.setData("%CLASS_TO%", question.getTo().getClassname().toStringInAnswer(false));
            }
        }
        if (question.getWiths() != null) {
            for (StringOrQuestionPair pair : question.getWiths()) {
                if (!pair.getKey().isComplete(true) || !pair.getValue().isComplete(true)) continue;
                taskInfo.setData("%" + pair.getKey().toStringInAnswer(false) + "%", pair.getValue().toStringInAnswer(false));
            }
        }
        ToolTask task = new ToolTask(this, taskInfo, tool);
        TaskAnswer taskAnswer = new TaskAnswer(task, this.getAnswerType(question), question.getSubjectOfInterest());
        task.setTaskAnswer(taskAnswer);
        if (!tool.isExternal() && (converter = ToolSelector.selectConverter(tool)) != null) {
            ConverterTaskInfo converterTaskInfo = new ConverterTaskInfo();
            for (String variable : taskInfo.getAllVariableNames()) {
                if (taskInfo.getData(variable) == null || taskInfo.getData(variable).isEmpty()) continue;
                converterTaskInfo.setData(variable, taskInfo.getData(variable));
            }
            ConverterTask converterTask = new ConverterTask(this, converterTaskInfo, converter);
            TaskAnswer converterTaskAnswer = new TaskAnswer(converterTask, 0, question.getSubjectOfInterest());
            converterTask.setTaskAnswer(converterTaskAnswer);
            converterTask.addChild(task);
            return converterTask;
        }
        return task;
    }

    private Task getTask(OperatorQuestion question) throws CancelExecutionException {
        Tool tool = ToolSelector.selectOperator(question);
        if (tool == null) {
            String errorMsg = "No appropriate operator could be found to answer the following question:\n" + question;
            this.parent.queryCanceled(-4, errorMsg);
            throw new CancelExecutionException(errorMsg);
        }
        OperatorTaskInfo taskInfo = new OperatorTaskInfo();
        this.setAlwaysAttributes(taskInfo, tool);
        OperatorTask task = new OperatorTask(this, taskInfo, tool);
        TaskAnswer taskAnswer = new TaskAnswer(task, this.getAnswerType(question));
        task.setTaskAnswer(taskAnswer);
        return task;
    }

    private Task getTask(FilterQuestion question) throws CancelExecutionException {
        Tool tool = ToolSelector.selectOperator(question);
        if (tool == null) {
            String errorMsg = "No appropriate filter-operator could be found to answer the following question:\n" + question;
            this.parent.queryCanceled(-4, errorMsg);
            throw new CancelExecutionException(errorMsg);
        }
        FilterOperatorTaskInfo taskInfo = new FilterOperatorTaskInfo();
        this.setAlwaysAttributes(taskInfo, tool);
        if (question.getFilterSubjectOfInterest() != null) {
            taskInfo.setData("%SOI%", question.getFilterSubjectOfInterest());
        }
        if (question.getFilterPair() != null) {
            if (question.getFilterPair().getKey() != null && question.getFilterPair().getKey().isComplete(true)) {
                taskInfo.setData("%KEY%", question.getFilterPair().getKey().toStringInAnswer(false));
            }
            if (question.getFilterPair().getValue() != null && question.getFilterPair().getValue().isComplete(true)) {
                taskInfo.setData("%VALUE%", question.getFilterPair().getValue().toStringInAnswer(false));
            }
        }
        if (question.getFilterReference() != null) {
            if (question.getFilterReference().getStatement() != null && question.getFilterReference().getStatement().isComplete(true)) {
                taskInfo.setData("%FILTER_STATEMENT%", question.getFilterReference().getStatement().toStringInAnswer(false));
                taskInfo.setData("%FILTER_LINENUMBER%", String.valueOf(question.getFilterReference().getLineNumber()).toString());
            }
            if (question.getFilterReference().getMethod() != null && question.getFilterReference().getMethod().isComplete(true)) {
                taskInfo.setData("%FILTER_METHOD%", question.getFilterReference().getMethod().toStringInAnswer(false));
            }
            if (question.getFilterReference().getClassname() != null && question.getFilterReference().getClassname().isComplete(true)) {
                taskInfo.setData("%FILTER_CLASS%", question.getFilterReference().getClassname().toStringInAnswer(false));
            }
            if (question.getFilterReference().getApp() != null && question.getFilterReference().getApp().isComplete(true)) {
                taskInfo.setData("%FILTER_APK%", question.getFilterReference().getApp().toStringInAnswer(false));
            }
        }
        FilterOperatorTask task = new FilterOperatorTask(this, taskInfo, tool);
        TaskAnswer taskAnswer = new TaskAnswer(task, this.getAnswerType(question));
        task.setTaskAnswer(taskAnswer);
        return task;
    }

    private Task getTask(LoadingQuestion question) {
        LoadAnswerTool tool = new LoadAnswerTool();
        LoadAnswerTaskInfo taskInfo = new LoadAnswerTaskInfo();
        taskInfo.setFileToLoad(question.getFile());
        LoadAnswerTask task = new LoadAnswerTask(this, taskInfo, (Tool)tool);
        TaskAnswer taskAnswer = new TaskAnswer(task, this.getAnswerType(question));
        task.setTaskAnswer(taskAnswer);
        return task;
    }

    private void appendPreprocessors(Task task, Question question) throws CancelExecutionException {
        if (task instanceof ConverterTask) {
            if (task.getChildren().size() == 1) {
                task = task.getChildren().iterator().next();
            } else {
                Log.warning("Cannot append preprocessor to converter task with multiple children.");
            }
        }
        if (task instanceof ToolTask) {
            for (QuestionReference ref : question.getAllReferences()) {
                for (IStringOrQuestion keyword : ref.getPreprocessorKeywords()) {
                    PreprocessorTask preprocessorTask = Storage.getInstance().getData().getPreprocessorTask(ref, keyword);
                    if (preprocessorTask == null) {
                        Tool preprocessor = ToolSelector.selectPreprocessor(keyword.toStringInAnswer(false));
                        if (preprocessor != null) {
                            PreprocessorTaskInfo preprocessorTaskInfo = new PreprocessorTaskInfo();
                            this.setAlwaysAttributes(preprocessorTaskInfo, preprocessor);
                            for (String variableName : task.getTaskInfo().getAllVariableNames()) {
                                if (task.getTaskInfo().getData(variableName) == null) continue;
                                preprocessorTaskInfo.setData(Helper.toVariableName(variableName), task.getTaskInfo().getData(variableName));
                            }
                            String apkFileString = ref.getApp().toStringInAnswer(false);
                            File apkFile = new File(apkFileString);
                            if (apkFile.exists()) {
                                AppInfo appInfo = new AppInfo(apkFile);
                                preprocessorTaskInfo.setData("%APP_APK%", appInfo.getApkFile().getAbsolutePath());
                                preprocessorTaskInfo.setData("%APP_APK_FILENAME%", appInfo.getFilename());
                                preprocessorTaskInfo.setData("%APP_APK_NAME%", appInfo.getAppName());
                                preprocessorTaskInfo.setData("%APP_APK_PACKAGE%", appInfo.getPkgName());
                            } else if (apkFileString.contains(",")) {
                                apkFileString = Helper.replaceDoubleSpaces(apkFileString).replace(", ", ",");
                                ArrayList<AppInfo> appInfos = new ArrayList<AppInfo>();
                                for (String oneApkFileString : apkFileString.split(",")) {
                                    File oneApkFile = new File(oneApkFileString);
                                    if (!oneApkFile.exists()) continue;
                                    appInfos.add(new AppInfo(oneApkFile));
                                }
                                StringBuilder appApk = new StringBuilder();
                                StringBuilder appApkFilename = new StringBuilder();
                                StringBuilder appApkName = new StringBuilder();
                                StringBuilder appApkPackage = new StringBuilder();
                                for (AppInfo appInfo : appInfos) {
                                    if (!appApk.isEmpty()) {
                                        appApk.append(", ");
                                    }
                                    appApk.append(appInfo.getApkFile().getAbsolutePath());
                                    if (!appApkFilename.isEmpty()) {
                                        appApkFilename.append("_");
                                    }
                                    appApkFilename.append(appInfo.getFilename());
                                    if (!appApkName.isEmpty()) {
                                        appApkName.append("_");
                                    }
                                    appApkName.append(appInfo.getAppName());
                                    if (!appApkPackage.isEmpty()) {
                                        appApkPackage.append("_ ");
                                    }
                                    appApkPackage.append(appInfo.getPkgName());
                                }
                                preprocessorTaskInfo.setData("%APP_APK%", appApk.toString());
                                preprocessorTaskInfo.setData("%APP_APK_FILENAME%", appApkFilename.toString());
                                preprocessorTaskInfo.setData("%APP_APK_NAME%", appApkName.toString());
                                preprocessorTaskInfo.setData("%APP_APK_PACKAGE%", appApkPackage.toString());
                            }
                            preprocessorTask = new PreprocessorTask(this, preprocessorTaskInfo, preprocessor, ref);
                            TaskAnswer preprocessorTaskAnswer = new TaskAnswer(preprocessorTask, 1);
                            preprocessorTask.setTaskAnswer(preprocessorTaskAnswer);
                            task.addChild(preprocessorTask);
                            Storage.getInstance().getData().addPreprocessorTask(ref, keyword, preprocessorTask);
                            continue;
                        }
                        String errorMsg = "No appropriate preprocessor (" + keyword + ") could be found to answer the following question: " + question;
                        this.parent.queryCanceled(-4, errorMsg);
                        throw new CancelExecutionException(errorMsg);
                    }
                    task.addChild(preprocessorTask);
                }
            }
        }
    }

    public void checkTransformations(Task task) {
        this.currentQuery.replaceAvailableRAW();
        if (Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task) != null && QueryTransformer.transform(this.currentQuery, Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task))) {
            try {
                this.currentTask = this.query(this.currentQuery, false);
            }
            catch (CancelExecutionException e) {
                Log.warning("Could not apply transformation rule. Continuing without." + Log.getExceptionAppendix(e));
            }
        }
    }

    private void setAlwaysAttributes(TaskInfo taskInfo, Tool tool) {
        if (!(tool instanceof DefaultOperator)) {
            if (!tool.isExternal()) {
                taskInfo.setData("%MEMORY%", Integer.toString(tool.getExecute().getMemoryPerInstance()));
            }
            if (ConfigHandler.getInstance().getConfig() != null) {
                taskInfo.setData("%ANDROID_PLATFORMS%", ConfigHandler.getInstance().getConfig().getAndroidPlatforms());
                taskInfo.setData("%ANDROID_BUILDTOOLS%", ConfigHandler.getInstance().getConfig().getAndroidBuildTools());
            }
            taskInfo.setData("%DATE%", Helper.getDate());
        }
    }

    private int getAnswerType(Question question) {
        switch (question.getEndingSymbol()) {
            case '!': {
                return 1;
            }
            case '.': {
                return 2;
            }
        }
        return 0;
    }

    public AQLSystem getParent() {
        return this.parent;
    }

    public void tryPlaceholderReplacement(Task task) {
        for (Task child : task.getChildren()) {
            if (child.isReady()) continue;
            return;
        }
        try {
            if (task instanceof PlaceholderTask) {
                this.getTask(Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task));
            }
            for (Task parent : new HashSet<Task>(task.getParents())) {
                this.tryPlaceholderReplacement(parent);
            }
        }
        catch (CancelExecutionException e) {
            Log.error("While trying to replace placeholders." + Log.getExceptionAppendix(e));
        }
    }
}

