/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.Log;
import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.query.DefaultQuestion;
import de.foellix.aql.datastructure.query.OperatorQuestion;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.helper.MemoryHelper;
import de.foellix.aql.system.AQLSystem;
import de.foellix.aql.system.ToolSelector;
import de.foellix.aql.system.defaulttools.DefaultTool;
import de.foellix.aql.system.defaulttools.analysistools.DefaultSootAnalysisTool;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.ConverterTask;
import de.foellix.aql.system.task.ConverterTaskRunner;
import de.foellix.aql.system.task.LoadAnswerTask;
import de.foellix.aql.system.task.LoadAnswerTaskRunner;
import de.foellix.aql.system.task.OperatorTask;
import de.foellix.aql.system.task.OperatorTaskRunner;
import de.foellix.aql.system.task.PreprocessorTask;
import de.foellix.aql.system.task.PreprocessorTaskRunner;
import de.foellix.aql.system.task.RootTask;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskRunner;
import de.foellix.aql.system.task.ToolTask;
import de.foellix.aql.system.task.ToolTaskRunner;
import de.foellix.aql.system.task.gui.TaskTreeViewer;
import de.foellix.aql.ui.gui.GUI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TaskScheduler {
    private final AQLSystem parent;
    private long timeout;
    private Task taskTree;
    private Map<Task, TaskRunner> runningTasks;
    private Lock lock;
    private int iterationCounter;

    public TaskScheduler(AQLSystem aqlSystem) {
        this.parent = aqlSystem;
        this.timeout = -1L;
        this.runningTasks = new ConcurrentHashMap<Task, TaskRunner>();
        this.lock = new ReentrantLock(true);
    }

    public void start(Task taskTree) {
        this.iterationCounter = 0;
        this.runningTasks.clear();
        this.taskTree = taskTree;
        this.next();
    }

    private void next() {
        this.updateExecutionGraph();
        Set<Task> converterLeafs = this.filterConverterLeafs(this.taskTree.getLeafs(true));
        Set<Task> leafs = !converterLeafs.isEmpty() ? this.filterDoubleLeafs(converterLeafs) : this.filterDoubleLeafs(this.taskTree.getLeafs(true));
        for (Task task : leafs) {
            if (task instanceof RootTask) {
                this.parent.queryFinished(task, 1);
                this.updateProgress(false);
                return;
            }
            if (task.getTaskAnswer().isAnswered() || this.runningTasks.containsKey(task) || !this.checkMemory(task) || !this.checkInstances(task)) continue;
            if (task instanceof ToolTask) {
                this.runningTasks.put(task, new ToolTaskRunner(this, task));
            } else if (task instanceof ConverterTask) {
                this.runningTasks.put(task, new ConverterTaskRunner(this, task));
            } else if (task instanceof PreprocessorTask) {
                this.runningTasks.put(task, new PreprocessorTaskRunner(this, task));
            } else if (task instanceof OperatorTask) {
                this.runningTasks.put(task, new OperatorTaskRunner(this, task));
            } else if (task instanceof LoadAnswerTask) {
                this.runningTasks.put(task, new LoadAnswerTaskRunner(this, task));
            }
            if (this.runningTasks.get(task).isAlive()) continue;
            this.runningTasks.get(task).start();
        }
        this.updateProgress(false);
    }

    private boolean checkMemory(Task task) {
        if (!task.getTool().isExternal()) {
            if (task.getTool().getExecute().getMemoryPerInstance() <= MemoryHelper.getInstance().getCurrentlyAvailableMemory(this.runningTasks.keySet())) {
                return true;
            }
            if (task.getTool().getExecute().getMemoryPerInstance() > MemoryHelper.getInstance().getMaxAssignableMemory()) {
                Log.warning(Helper.getQualifiedName(task.getTool()) + " requests " + task.getTool().getExecute().getMemoryPerInstance() + " GB memory. That amount of memory will never become available. Reducing requested memory to: " + MemoryHelper.getInstance().getMaxAssignableMemory() + " GB (" + MemoryHelper.getInstance().getMemoryInfo() + ")");
                task.getTool().getExecute().setMemoryPerInstance(MemoryHelper.getInstance().getMaxAssignableMemory());
                for (Task taskToUpdate : this.taskTree.getChildren(true)) {
                    if (taskToUpdate.getTool() != task.getTool()) continue;
                    taskToUpdate.getTaskInfo().setData("%MEMORY%", String.valueOf(taskToUpdate.getTool().getExecute().getMemoryPerInstance()));
                }
                if (task.getTool().getExecute().getMemoryPerInstance() <= MemoryHelper.getInstance().getCurrentlyAvailableMemory(this.runningTasks.keySet())) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkInstances(Task task) {
        int instances;
        if (!task.getTool().isExternal() && (instances = task.getTool().getExecute().getInstances().intValue()) != 0) {
            int counter = 0;
            for (Task taskToCheck : this.runningTasks.keySet()) {
                if (taskToCheck.getTool() != task.getTool() && (!(task.getTool() instanceof DefaultTool) || !task.getTool().getClass().equals(taskToCheck.getTool().getClass())) && (!(task.getTool() instanceof DefaultSootAnalysisTool) || !(taskToCheck.getTool() instanceof DefaultSootAnalysisTool))) continue;
                ++counter;
            }
            if (counter >= instances) {
                return false;
            }
        }
        return true;
    }

    private void updateProgress(boolean aborted) {
        if (this.parent.getProgressHandler().hasListener()) {
            if (aborted) {
                this.parent.getProgressHandler().progress("Aborted", 0, 0, 0);
            } else {
                this.parent.getProgressHandler().progress("Running iteration " + ++this.iterationCounter, this.runningTasks.size(), this.taskTree.countAvailableAnswersOfChildren(), this.taskTree.getChildren().size());
            }
        }
    }

    private void updateExecutionGraph() {
        if (this.parent.getOptions().getDrawGraphs()) {
            TaskTreeViewer.update(this.taskTree, this.runningTasks.keySet());
            if (!GUI.started || Log.logIt(5, true)) {
                Log.msg(this.taskTree.toString(), 4);
            }
        }
    }

    private Set<Task> filterDoubleLeafs(Set<Task> leafs) {
        HashSet<Task> filteredLeafs = new HashSet<Task>();
        HashSet<String> hashes = new HashSet<String>();
        for (Task leaf : leafs) {
            String hash = leaf.getRunCommand(true, false);
            if (hashes.contains(hash)) continue;
            filteredLeafs.add(leaf);
            hashes.add(hash);
        }
        return filteredLeafs;
    }

    private Set<Task> filterConverterLeafs(Set<Task> leafs) {
        HashSet<Task> filteredLeafs = new HashSet<Task>();
        for (Task leaf : leafs) {
            if (!(leaf instanceof ConverterTask)) continue;
            filteredLeafs.add(leaf);
        }
        return filteredLeafs;
    }

    public void cancel() {
        Log.msg("Stopping scheduler!", 5);
        for (TaskRunner taskRunner : this.runningTasks.values()) {
            if (!taskRunner.isAlive()) continue;
            taskRunner.interrupt();
        }
        this.updateProgress(true);
    }

    private boolean retry(Task task) {
        Question question = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task, true);
        Tool altTool = task instanceof ToolTask && question instanceof DefaultQuestion ? ToolSelector.selectAnalysisTool((DefaultQuestion)question, task.getToolsFailedAsArray()) : (task instanceof ConverterTask ? ToolSelector.selectConverter(task.getChildren().iterator().next().getTool(), task.getToolsFailedAsArray()) : (task instanceof PreprocessorTask ? ToolSelector.selectPreprocessor(task.getTool().getQuestions(), task.getToolsFailedAsArray()) : (task instanceof OperatorTask && question instanceof OperatorQuestion ? ToolSelector.selectOperator((OperatorQuestion)question, task.getToolsFailedAsArray()) : null)));
        if (!(altTool == null || altTool == task.getTool() || altTool instanceof DefaultTool && altTool.getName() == task.getTool().getName() && altTool.getVersion() == task.getTool().getVersion())) {
            task.setTool(altTool);
            return true;
        }
        return false;
    }

    public void changed(Task taskTree) {
        this.taskTree = taskTree;
    }

    public void taskFinished(Task task, int status) {
        this.taskFinished(task, status, null);
    }

    public void taskFinished(Task task, String feedback) {
        this.taskFinished(task, -1, feedback);
    }

    public void taskFinished(Task task, int status, String feedback) {
        this.lock.lock();
        this.runningTasks.remove(task);
        this.updateProgress(false);
        if (status == 1) {
            task.update();
            this.next();
        } else {
            task.getToolsFailed().add(task.getTool());
            this.updateExecutionGraph();
            if (feedback != null) {
                this.parent.queryCanceled(-1, "Feedback-Answer received while answering: " + Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task, true) + "\nFeedback: " + feedback);
            } else if (status <= -1) {
                Tool oldTool = task.getTool();
                if (this.getParent().getOptions().getRetry() && this.retry(task)) {
                    Log.msg(Helper.getQualifiedName(oldTool) + " execution failed! Retrying with " + Helper.getQualifiedName(task.getTool()) + ".", 4);
                    this.next();
                } else if (status == -1) {
                    this.parent.queryCanceled(-1, "Answering a part of the query failed: " + Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task, true));
                } else if (status == -2) {
                    this.parent.queryCanceled(-1, "Answering a part of the query timed out: " + Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task, true));
                } else if (status == -3) {
                    this.parent.queryCanceled(-1, "Answering a part of the query canceled: " + Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task, true));
                }
            }
        }
        this.lock.unlock();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public AQLSystem getParent() {
        return this.parent;
    }

    public Task getTaskTree() {
        return this.taskTree;
    }

    public boolean inProgress(Task task) {
        return this.runningTasks.keySet().contains(task);
    }
}

