/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.Log;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.defaulttools.DefaultTool;
import de.foellix.aql.system.task.TaskRunner;

public class TaskTimer
extends Thread {
    private final TaskRunner runner;
    private final long timeoutInSeconds;
    private boolean stop;
    private boolean timedOut;

    public TaskTimer(TaskRunner runner, long timeoutInSeconds) {
        this.runner = runner;
        this.timeoutInSeconds = timeoutInSeconds;
        this.stop = false;
        this.timedOut = false;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        while (start + this.timeoutInSeconds * 1000L > System.currentTimeMillis()) {
            try {
                Thread.sleep(500L);
                if (this.stop) {
                    if (!(this.runner.getTask().getTool() instanceof DefaultTool)) {
                        Log.msg("Timeout-Timer stopped normally.", 6);
                    }
                    return;
                }
            }
            catch (InterruptedException e) {
                Log.msg("Timeout-Timer stopped: " + e.getMessage(), 6);
                return;
            }
            if (!this.runner.getTask().getTaskAnswer().isAnswered()) continue;
            return;
        }
        this.timedOut = true;
        Log.warning("Timeout-Timer expired for " + Helper.getQualifiedName(this.runner.getTask().getTool()));
        this.runner.runOnAbort();
        this.runner.interrupt();
    }

    @Override
    public void interrupt() {
        this.stop = true;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }
}

