/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.config.Priority;
import de.foellix.aql.config.Tool;
import de.foellix.aql.converter.DefaultConverterRegistry;
import de.foellix.aql.datastructure.query.DefaultQuestion;
import de.foellix.aql.datastructure.query.IStringOrQuestion;
import de.foellix.aql.datastructure.query.OperatorQuestion;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.datastructure.query.StringOrQuestionPair;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.defaulttools.DefaultTool;
import de.foellix.aql.system.defaulttools.analysistools.DefaultFeatureFinder;
import de.foellix.aql.system.defaulttools.analysistools.DefaultIntentInformationFinder;
import de.foellix.aql.system.defaulttools.analysistools.DefaultPermissionFinder;
import de.foellix.aql.system.defaulttools.analysistools.DefaultSourceSinkFinder;
import de.foellix.aql.system.defaulttools.operators.DefaultOperator;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class ToolSelector {
    public static final String MODE_INTRA_FLOWS = "IntraAppFlows";
    public static final String MODE_INTER_FLOWS = "InterAppFlows";
    public static final String MODE_PERMISSIONS = "Permissions";
    public static final String MODE_INTENTS = "Intents";
    public static final String MODE_INTENTFILTER = "IntentFilters";
    public static final String MODE_INTENTSOURCES = "IntentSources";
    public static final String MODE_INTENTSINKS = "IntentSinks";
    public static final String MODE_SLICE = "Slice";
    public static final String MODE_SOURCES = "Sources";
    public static final String MODE_SINKS = "Sinks";
    public static final String MODE_ARGUMENTS = "Arguments";

    public static Tool selectAnalysisTool(DefaultQuestion question) {
        return ToolSelector.selectAnalysisTool(question, null);
    }

    public static Tool selectAnalysisTool(DefaultQuestion question, Tool[] exceptions) {
        Tool defaultTool;
        ArrayList<Tool> choices = new ArrayList<Tool>();
        String mode = ToolSelector.soiToMode(question);
        if (ConfigHandler.getInstance().getConfig() != null && ConfigHandler.getInstance().getConfig().getTools() != null && !ConfigHandler.getInstance().getConfig().getTools().getTool().isEmpty()) {
            for (Tool tool : ConfigHandler.getInstance().getConfig().getTools().getTool()) {
                if (!ToolSelector.modeAvailable(tool, mode)) continue;
                choices.add(tool);
            }
        }
        if ((defaultTool = ToolSelector.selectDefaultAnalysisTool(question)) != null) {
            choices.add(defaultTool);
        }
        return ToolSelector.selectTool(choices, -1, exceptions, question);
    }

    private static Tool selectDefaultAnalysisTool(DefaultQuestion question) {
        if (question.getSubjectOfInterest() == 2 || question.getSubjectOfInterest() == 3 || question.getSubjectOfInterest() == 5 || question.getSubjectOfInterest() == 4) {
            return new DefaultIntentInformationFinder();
        }
        if (question.getSubjectOfInterest() == 7 || question.getSubjectOfInterest() == 8) {
            return new DefaultSourceSinkFinder();
        }
        if (question.getSubjectOfInterest() == 1) {
            return new DefaultPermissionFinder();
        }
        if (question.getSubjectOfInterest() == 9) {
            return new DefaultFeatureFinder();
        }
        return null;
    }

    private static boolean modeAvailable(Tool tool, String mode) {
        return Arrays.asList(tool.getQuestions().replace(" ", "").split(",")).contains(mode);
    }

    public static Tool selectConverter(Tool analysisTool) {
        return ToolSelector.selectConverter(analysisTool, null);
    }

    public static Tool selectConverter(Tool analysisTool, Tool[] exceptions) {
        ArrayList<Tool> choices = new ArrayList<Tool>();
        if (ConfigHandler.getInstance().getConfig() != null && ConfigHandler.getInstance().getConfig().getConverters() != null && !ConfigHandler.getInstance().getConfig().getConverters().getTool().isEmpty()) {
            List<String> targetTools;
            Object needle = analysisTool.getName().toLowerCase() + "(" + analysisTool.getVersion().toLowerCase() + ")";
            for (Tool tool : ConfigHandler.getInstance().getConfig().getConverters().getTool()) {
                targetTools = Arrays.asList(tool.getQuestions().toLowerCase().replace(" ", "").split(","));
                if (!targetTools.contains(needle)) continue;
                choices.add(tool);
            }
            if (choices.isEmpty()) {
                needle = analysisTool.getName().toLowerCase();
                for (Tool tool : ConfigHandler.getInstance().getConfig().getConverters().getTool()) {
                    targetTools = Arrays.asList(tool.getQuestions().toLowerCase().replace(" ", "").split(","));
                    if (!targetTools.contains(needle)) continue;
                    choices.add(tool);
                }
            }
        }
        if (choices.isEmpty()) {
            return DefaultConverterRegistry.getInstance().getConverter(analysisTool);
        }
        return ToolSelector.selectTool(choices, -1, exceptions);
    }

    public static Tool selectPreprocessor(String keyword) {
        return ToolSelector.selectPreprocessor(keyword, null);
    }

    public static Tool selectPreprocessor(String keyword, Tool[] exceptions) {
        ArrayList<Tool> choices = new ArrayList<Tool>();
        if (ConfigHandler.getInstance().getConfig().getPreprocessors() != null && !ConfigHandler.getInstance().getConfig().getPreprocessors().getTool().isEmpty()) {
            for (Tool preprocessor : ConfigHandler.getInstance().getConfig().getPreprocessors().getTool()) {
                if (!preprocessor.getQuestions().equals(keyword) && !keyword.equals(preprocessor.getName()) && !keyword.equals(preprocessor.getName() + "-" + preprocessor.getVersion())) continue;
                choices.add(preprocessor);
            }
        }
        return ToolSelector.selectTool(choices, -1, exceptions);
    }

    public static Tool selectOperator(OperatorQuestion question) {
        return ToolSelector.selectOperator(question, null);
    }

    public static Tool selectOperator(OperatorQuestion question, Tool[] exceptions) {
        Tool defaultOperator;
        ArrayList<Tool> choices = new ArrayList<Tool>();
        if (ConfigHandler.getInstance().getConfig().getOperators() != null && !ConfigHandler.getInstance().getConfig().getOperators().getTool().isEmpty()) {
            for (Tool operator : ConfigHandler.getInstance().getConfig().getOperators().getTool()) {
                for (String splitStr : operator.getQuestions().replace(" ", "").split(",")) {
                    if (!splitStr.equals(question.getOperator()) && (!splitStr.contains("(") || !splitStr.substring(0, splitStr.indexOf("(")).equals(question.getOperator()))) continue;
                    choices.add(operator);
                }
                if (choices.contains(operator) || !question.getOperator().equals(operator.getName()) && !question.getOperator().equals(operator.getName() + "-" + operator.getVersion())) continue;
                choices.add(operator);
            }
        }
        if ((defaultOperator = ToolSelector.selectDefaultOperator(question)) != null) {
            choices.add(defaultOperator);
        }
        return ToolSelector.selectTool(choices, -1, exceptions);
    }

    private static Tool selectDefaultOperator(OperatorQuestion question) {
        return DefaultOperator.getOperator(question.getOperator());
    }

    private static Tool selectTool(List<Tool> choices, int minPriority, Tool[] exceptions) {
        return ToolSelector.selectTool(choices, minPriority, exceptions, null);
    }

    private static Tool selectTool(List<Tool> choices, int minPriority, Tool[] exceptions, DefaultQuestion question) {
        if (exceptions != null) {
            choices = ToolSelector.removeExceptions(choices, exceptions, question);
        }
        if (!choices.isEmpty()) {
            Tool selectedChoice = null;
            int selectedPriority = -1;
            for (Tool choice : choices) {
                int newPriority;
                int n = newPriority = question != null ? ToolSelector.getPriority(choice, question) : ToolSelector.getPriority(choice);
                if (newPriority <= minPriority && !(choice instanceof DefaultTool) || selectedChoice != null && selectedPriority > newPriority) continue;
                if (selectedChoice != null && selectedPriority == newPriority) {
                    selectedChoice = ToolSelector.breakTie(selectedChoice, choice, question);
                    continue;
                }
                selectedChoice = choice;
                selectedPriority = newPriority;
            }
            return selectedChoice;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Tool breakTie(Tool tool1, Tool tool2, DefaultQuestion question) {
        if (tool1.isExternal() && !tool2.isExternal()) {
            return tool2;
        }
        if (!tool1.isExternal() && !tool2.isExternal()) {
            int tool1Priority = 0;
            int tool2Priority = 0;
            if (question.getWiths() != null && !question.getWiths().isEmpty()) {
                HashSet<CallSite> variablesUsed = new HashSet<CallSite>();
                for (StringOrQuestionPair stringOrQuestionPair : question.getWiths()) {
                    if (!stringOrQuestionPair.getKey().isComplete(true)) continue;
                    variablesUsed.add((CallSite)((Object)("%" + stringOrQuestionPair.getKey().toStringInAnswer(false) + "%")));
                }
                for (String string : variablesUsed) {
                    if (tool1.getExecute().getRun().contains(string)) {
                        ++tool1Priority;
                    }
                    if (!tool2.getExecute().getRun().contains(string)) continue;
                    ++tool2Priority;
                }
                if (tool2Priority > tool1Priority) {
                    return tool2;
                }
            }
            if (tool1Priority == tool2Priority) {
                void var7_11;
                String runTool1 = tool1.getExecute().getRun();
                String runTool2 = tool2.getExecute().getRun();
                boolean bl = false;
                int tool2Priority2 = 0;
                for (String var : Helper.getAllDefaultVariableNames()) {
                    var7_11 += Helper.countStringOccurences(runTool1, var);
                    tool2Priority2 += Helper.countStringOccurences(runTool2, var);
                    runTool1 = runTool1.replace(var, "");
                    runTool2 = runTool2.replace(var, "");
                }
                tool1Priority = Helper.countStringOccurences(runTool1, "%");
                tool2Priority = Helper.countStringOccurences(runTool2, "%");
                if (tool2Priority < tool1Priority) {
                    return tool2;
                }
                if (tool2Priority == tool1Priority && tool2Priority2 > var7_11) {
                    return tool2;
                }
            }
        }
        return tool1;
    }

    private static List<Tool> removeExceptions(List<Tool> choices, Tool[] exceptions, DefaultQuestion question) {
        ArrayList<Tool> toRemove = new ArrayList<Tool>(Arrays.asList(exceptions));
        choices.removeAll(toRemove);
        if (!choices.isEmpty()) {
            int lowestPriority = Integer.MAX_VALUE;
            for (Tool tool : exceptions) {
                int toolPriority = ToolSelector.getPriority(tool, question);
                if (toolPriority >= lowestPriority) continue;
                lowestPriority = toolPriority;
            }
            toRemove.clear();
            for (Tool tool : choices) {
                if (ToolSelector.getPriority(tool, question) <= lowestPriority) continue;
                toRemove.add(tool);
            }
            choices.removeAll(toRemove);
        }
        return choices;
    }

    public static int getPriority(Tool tool, DefaultQuestion question) {
        if (question != null) {
            if (question.getUses() != null && !question.getUses().isEmpty()) {
                if (Helper.contains(question.getUses(), tool.getName()) || Helper.contains(question.getUses(), tool.getName() + "-" + tool.getVersion()) || tool instanceof DefaultTool && Helper.contains(question.getUses(), "Default")) {
                    return ConfigHandler.getInstance().getMaxConfiguredPriority() + Math.max(0, ToolSelector.getPriorityByFeatures(tool, question)) + 1;
                }
            } else if (question.getFeatures() != null && !question.getFeatures().isEmpty()) {
                return ToolSelector.getPriorityByFeatures(tool, question);
            }
        }
        return ToolSelector.getPriority(tool);
    }

    public static int getPriorityByFeatures(Tool tool, DefaultQuestion question) {
        int priorityValue = ToolSelector.getPriority(tool);
        for (Priority priority : tool.getPriority()) {
            if (priority.getFeature() == null || question.getFeatures() == null) continue;
            String feature = priority.getFeature();
            boolean found = false;
            for (IStringOrQuestion candidate : question.getFeatures()) {
                if (!candidate.toStringInAnswer(false).equals(feature)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            priorityValue += priority.getValue();
        }
        return priorityValue;
    }

    public static int getPriority(Tool tool) {
        for (Priority priority : tool.getPriority()) {
            if (priority.getFeature() != null) continue;
            return priority.getValue();
        }
        return 0;
    }

    private static String soiToMode(DefaultQuestion question) {
        switch (question.getSubjectOfInterest()) {
            case 0: {
                if (ToolSelector.detectInterApp(question)) {
                    return MODE_INTER_FLOWS;
                }
                return MODE_INTRA_FLOWS;
            }
            case 1: {
                return MODE_PERMISSIONS;
            }
            case 3: {
                return MODE_INTENTFILTER;
            }
            case 2: {
                return MODE_INTENTS;
            }
            case 5: {
                return MODE_INTENTSINKS;
            }
            case 4: {
                return MODE_INTENTSOURCES;
            }
            case 6: {
                return MODE_SLICE;
            }
            case 7: {
                return MODE_SOURCES;
            }
            case 8: {
                return MODE_SINKS;
            }
            case 9: {
                return MODE_ARGUMENTS;
            }
        }
        return null;
    }

    private static boolean detectInterApp(Question question) {
        DefaultQuestion castedQuestion;
        return question instanceof DefaultQuestion && (castedQuestion = (DefaultQuestion)question).getFrom() != null && castedQuestion.getTo() != null && castedQuestion.getFrom().toReference() != null && castedQuestion.getTo().toReference() != null && castedQuestion.getFrom().toReference().getApp() != null && castedQuestion.getTo().toReference().getApp() != null && !EqualsHelper.equals(castedQuestion.getFrom().toReference().getApp(), castedQuestion.getTo().toReference().getApp());
    }
}

