/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.defaulttools.analysistools;

import de.foellix.aql.Log;
import de.foellix.aql.helper.tools.FeatureFinder;
import de.foellix.aql.system.defaulttools.analysistools.DefaultSootAnalysisTool;
import de.foellix.aql.system.task.ToolTask;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DefaultFeatureFinder
extends DefaultSootAnalysisTool {
    @Override
    public File applyAnalysisTool(ToolTask task) {
        File answerFile;
        block14: {
            List<Object> features = new ArrayList();
            String apk = task.getTaskInfo().getData("%APP_APK%");
            if (apk != null) {
                File apkFile = new File(apk);
                if (apkFile.exists()) {
                    FeatureFinder fd = new FeatureFinder();
                    features = fd.getFeatures(apkFile);
                }
            } else {
                Log.warning("Cannot run FeatureFinder - no APK specified!");
            }
            answerFile = task.getTaskAnswer().getAnswerFile();
            try {
                if (features.isEmpty()) {
                    answerFile.createNewFile();
                    break block14;
                }
                try (FileWriter fw = new FileWriter(answerFile);){
                    boolean first = true;
                    for (String string : features) {
                        if (!first) {
                            fw.append(", ");
                        } else {
                            first = false;
                        }
                        fw.append(string);
                    }
                }
            }
            catch (IOException e) {
                Log.warning("Could not create answer file: " + answerFile.getAbsolutePath() + Log.getExceptionAppendix(e));
            }
        }
        return answerFile;
    }
}

